/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.access_both.version0;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttribute_V0;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EOFrameData_V0
extends EOEncodableObject
implements ICockpitProjectData {
    private final Map oldAttributes = new HashMap();
    private final Collection oldChildren = new ArrayList();
    public static final String XML_NAME = "frame.frameData";
    private static final String XML_ATTR_PROJECT_UID = "projectUID";
    private static final String XML_ATTR_UID = "uID";
    private static final String XML_ATTR_DATATYPE_ID = "dataTypeID";
    private static final String XML_ATTR_MODCOUNT = "modCount";
    private static final String XML_ATTR_MODTIME = "modTime";
    private String projectUID;
    private String uID;
    private String dataTypeID;
    private int modCount = 0;
    private Timestamp modTime;
    private final Collection<EOAttribute_V0> attributes = new ArrayList<EOAttribute_V0>();

    public EOFrameData_V0() {
        super(XML_NAME);
    }

    public EOFrameData_V0(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOFrameData_V0(String xmlName) {
        super(xmlName);
    }

    public EOFrameData_V0(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    public void addAttribute(EOAttribute_V0 attribute) {
        Iterator<EOAttribute_V0> i = this.attributes.iterator();
        while (i.hasNext()) {
            EOAttribute_V0 contained = i.next();
            if (!contained.getAttributeTypeUID().getUID().equals(attribute.getAttributeTypeUID().getUID())) continue;
            i.remove();
            break;
        }
        this.attributes.add(attribute);
    }

    public void setUID(String uID) {
        this.uID = uID;
    }

    public void setDataTypeID(String dataTypeID) {
        assert (dataTypeID.length() < 129);
        this.dataTypeID = dataTypeID;
    }

    public Collection<EOAttribute_V0> getAttributes() {
        return this.attributes;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public String getUID() {
        return this.uID;
    }

    public String getTypeID() {
        return this.dataTypeID;
    }

    public void setProjectUID(String projectUID) {
        this.projectUID = projectUID;
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (name.equals(XML_ATTR_PROJECT_UID)) {
            this.projectUID = value;
        } else if (name.equals(XML_ATTR_UID)) {
            this.uID = value;
        } else if (name.equals(XML_ATTR_DATATYPE_ID)) {
            this.dataTypeID = value;
        } else if (name.equals(XML_ATTR_MODCOUNT)) {
            this.modCount = this.toInt(value);
        } else if (name.equals(XML_ATTR_MODTIME)) {
            this.modTime = this.toTimestamp(value);
        } else {
            this.oldAttributes.put(name, value);
        }
        return true;
    }

    public String getOldAttributeValue(String name) {
        return (String)this.oldAttributes.get(name);
    }

    public void clearOldAttribute(String name) {
        this.oldAttributes.remove(name);
    }

    public Map getOldAttributes() {
        return this.oldAttributes;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, XML_ATTR_MODCOUNT, this.modCount);
        this.appendAttrToXML(writeContext, XML_ATTR_PROJECT_UID, this.projectUID);
        this.appendAttrToXML(writeContext, XML_ATTR_UID, this.uID);
        this.appendAttrToXML(writeContext, XML_ATTR_DATATYPE_ID, this.dataTypeID);
        this.appendAttrToXML(writeContext, XML_ATTR_MODTIME, this.modTime);
        for (String name : this.oldAttributes.keySet()) {
            String value = (String)this.oldAttributes.get(name);
            this.appendAttrToXML(writeContext, name, value);
        }
    }

    protected boolean hasChildren() {
        return !this.attributes.isEmpty() || !this.oldChildren.isEmpty();
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        for (EOAttribute_V0 attribute : this.attributes) {
            attribute.writeXMLBody(writeContext, depth);
        }
        for (EncodableObjectBase eo : this.oldChildren) {
            eo.writeXMLBody(writeContext, depth);
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild instanceof EOAttribute_V0) {
            this.attributes.add((EOAttribute_V0)newChild);
            return true;
        }
        this.oldChildren.add(newChild);
        return true;
    }

    public Collection getOldChildren() {
        return this.oldChildren;
    }

    @Deprecated
    protected void setOldAttributes(Map attributes) {
        this.oldAttributes.clear();
        for (String name : attributes.keySet()) {
            String value = (String)attributes.get(name);
            this.oldAttributes.put(name, value);
        }
    }

    @Deprecated
    protected void setOldChildren(Collection children) {
        this.oldChildren.clear();
        for (Object child : children) {
            this.oldChildren.add(child);
        }
    }

    public int getModCount() {
        return this.modCount;
    }

    public void setModCount(int i) {
        this.modCount = i;
    }

    public Timestamp getModTime() {
        return this.modTime;
    }

    public void setModTime(Timestamp timestamp) {
        this.modTime = timestamp;
    }
}

