/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.client.base.interfaces.frame.ProjectDirectoryLayout;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.AddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.DeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UniqueElementLabelDecorator;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameLockManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.IUniqueElementRelationshipManager;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IDataAddID;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.locking.LockRequest;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.loproviders.UniqueElementLinkedDataAccessFacade;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanAddID;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.PlanAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.ExportDataProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IImportedPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElementAddID;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.OccurrenceList;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementIdentifier;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementModificationMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementOccurrenceCache;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementOccurrenceModificationMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementServerCache;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.UserDefinedAtributeDataManagementFacade;
import com.arcway.cockpit.frame.client.project.datainterchange.IUniqueElementExportDataProvider;
import com.arcway.cockpit.frame.client.project.modules.IModuleUniqueElementManager;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.planimportexport.IExternalPlanImporterExporterControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorManager;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.UniqueElementNormalizer;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.EOUniqueElement;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementModification;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementOccurrence;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import de.plans.lib.util.gui.DecoratingLabelProvider;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UniqueElementMgr
implements IFrameUniqueElementManager,
IModuleUniqueElementManager,
IProjectCloseListener {
    private static final ILogger logger = Logger.getLogger(UniqueElementMgr.class);
    private IFrameProjectAgent projectAgent;
    private PlanAgentManager planAgentManager;
    private PlanEditorManager planEditorManager;
    private UniqueElementServerCache uniqueElementCache;
    private UniqueElementOccurrenceCache uniqueElementOccurrenceCache;
    private UniqueElementModificationMgr uniqueElementModificationMgr;
    private UniqueElementOccurrenceModificationMgr uniqueElementOccurrenceModificationMgr;
    private UniqueElementLinkedDataAccessFacade linkableObjectProvider;
    private IUniqueElementExportDataProvider exportDataProvider;
    private IDataLabelProvider labelProvider;
    private final Map<IUniqueElementAddID, IUniqueElement> grantedAddIDs = new HashMap<IUniqueElementAddID, IUniqueElement>();
    private IXMLDataAccessor<EOList<EOList<EOUniqueElement>>> modificationFileAccessor;
    private ILOLinkAccessFacade linkFacade;
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return UniqueElementMgr.this.projectAgent;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return null;
        }
    };

    public void construct(IFrameProjectAgent newProjectAgent) {
        assert (newProjectAgent != null) : "projectAgent can't be null";
        this.projectAgent = newProjectAgent;
        this.planAgentManager = this.projectAgent.getPlanAgentManager();
        this.planEditorManager = this.projectAgent.getPlanEditorManager();
        this.linkableObjectProvider = new UniqueElementLinkedDataAccessFacade(this);
        this.exportDataProvider = new ExportDataProvider(this);
        this.modificationFileAccessor = this.projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.FILEKEY_UNIQUE_ELEMENTS, (IEncodableObjectFactory)MessageDataFactory.getInstance());
    }

    private EOList<EOList<EOUniqueElement>> readUniqueElementModifications() throws EXCorruptProjectData {
        EOList mods;
        try {
            mods = (EOList)this.modificationFileAccessor.read();
        }
        catch (Exception e) {
            throw new EXCorruptProjectData(e);
        }
        if (mods == null) {
            mods = new EOList();
        }
        return mods;
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.uniqueElementModificationMgr = new UniqueElementModificationMgr();
        this.uniqueElementOccurrenceModificationMgr = new UniqueElementOccurrenceModificationMgr(this.projectAgent);
        this.loadUniqueElementCache(serverDataContainer);
        this.loadUniqueElementOccurrenceCache(serverDataContainer);
        EOList<EOList<EOUniqueElement>> readUniqueElementModifications = this.readUniqueElementModifications();
        if (readUniqueElementModifications.isEmpty()) {
            this.uniqueElementModificationMgr.intialize(new UniqueElement[0], new UniqueElement[0], new UniqueElement[0]);
        } else {
            EOList lstCreated = (EOList)readUniqueElementModifications.get(0);
            EOList eOList = (EOList)readUniqueElementModifications.get(1);
            EOList lstDeleted = (EOList)readUniqueElementModifications.get(2);
            UniqueElement[] created = this.getArrayFromList((Collection<EOUniqueElement>)lstCreated);
            UniqueElement[] modified = this.getArrayFromList((Collection<EOUniqueElement>)eOList);
            UniqueElement[] deleted = this.getArrayFromList((Collection<EOUniqueElement>)lstDeleted);
            this.uniqueElementModificationMgr.intialize(created, modified, deleted);
        }
        ArrayList<? extends IPlan> plans = new ArrayList<IPlan>(this.projectAgent.getFrameSectionManager().getPlans());
        plans.addAll(this.projectAgent.getFrameSectionManager().getDeletedPlans());
        for (IPlan iPlan : plans) {
            EOList<EOList<EOUniqueElementOccurrence>> readOccurrenceModifications = this.readUniqueElementOccurrenceModifications(iPlan.getUID());
            if (readOccurrenceModifications.isEmpty()) continue;
            this.uniqueElementOccurrenceModificationMgr.addModifications((Collection)readOccurrenceModifications.get(0), (Collection)readOccurrenceModifications.get(1));
        }
        administrator.getFrameProjectAgent().addProjectCloseListener(this);
        this.linkFacade = this.getProjectAgent().getLinkManager().getLOLinkAccessFacade("com.arcway.cockpit.uniqueelement");
    }

    @Override
    public void closeProject(IFrameProjectAgent pa) {
        this.linkFacade = null;
    }

    @Override
    public ILOLinkAccessFacade getUniqueElementLinkFacade() {
        return this.linkFacade;
    }

    private UniqueElement[] getArrayFromList(Collection<EOUniqueElement> list) {
        UniqueElement[] array = new UniqueElement[list.size()];
        int nr = 0;
        for (EOUniqueElement eo : list) {
            UniqueElementAttributeModificationManager modManager = new UniqueElementAttributeModificationManager(this.projectAgent);
            UniqueElement ue = new UniqueElement(eo, modManager, this.projectAgent);
            modManager.setUniqueElement(ue);
            array[nr++] = ue;
        }
        return array;
    }

    private void loadUniqueElementCache(ServerDataContainer serverDataContainer) {
        EOUniqueElement[] eoElements = serverDataContainer.getUniqueElements();
        this.uniqueElementCache = new UniqueElementServerCache();
        EOUniqueElement[] eOUniqueElementArray = eoElements;
        int n = eoElements.length;
        int n2 = 0;
        while (n2 < n) {
            EOUniqueElement element2 = eOUniqueElementArray[n2];
            UniqueElementAttributeModificationManager modManager = new UniqueElementAttributeModificationManager(this.projectAgent);
            UniqueElement element = new UniqueElement(element2, modManager, this.projectAgent);
            modManager.setUniqueElement(element);
            this.uniqueElementCache.addUniqueElement(element);
            ++n2;
        }
    }

    private void loadUniqueElementOccurrenceCache(ServerDataContainer serverDataContainer) {
        Collection<EOUniqueElementOccurrence> items = serverDataContainer.getUniqueElementOccurrences();
        this.uniqueElementOccurrenceCache = new UniqueElementOccurrenceCache(this);
        if (items != null) {
            this.uniqueElementOccurrenceCache.setUpCache(items);
        }
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    @Override
    public void planDeletedOnClient(IPlan plan) {
        OccurrenceList occurences = this.getUniqueElementOccurrencesForPlan(plan.getUID());
        ArrayList<EOUniqueElementOccurrence> removedOccurences = new ArrayList<EOUniqueElementOccurrence>(occurences.size());
        for (IUniqueElementOccurrence occurence : occurences) {
            EOUniqueElementOccurrence removedOccurrence = this.deleteUniqueElementOccurenceWithoutInforming(occurence.getPlanUID(), occurence.getPlanElementUID());
            if (removedOccurrence == null) continue;
            removedOccurences.add(removedOccurrence);
        }
        this.saveUniqueElementOccurrenceModifications(plan.getUID());
        this.notifyUniqueElementRelationshipManagerAboutPlanDeletedOnClient(plan);
        PropertyChanges changes = new PropertyChanges(null, null, removedOccurences);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElementOccurrence.class);
    }

    private void notifyUniqueElementRelationshipManagerAboutPlanDeletedOnClient(IPlan plan) {
        this.projectAgent.getUniqueElementRelationshipManager().planDeletedOnClient(plan.getUID());
    }

    @Override
    public boolean hasLocalModifications() {
        return this.uniqueElementModificationMgr.isModified() || this.uniqueElementOccurrenceModificationMgr.isModified();
    }

    private UniqueElement getUniqueElementInternal(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        UniqueElement modifiedUniqueElement = this.uniqueElementModificationMgr.getUniqueElement(uniqueElementUID);
        if (modifiedUniqueElement != null) {
            return modifiedUniqueElement;
        }
        UniqueElement cachedUniqueElement = this.uniqueElementCache.getUniqueElement(uniqueElementUID);
        if (cachedUniqueElement != null && !this.uniqueElementModificationMgr.isUniqueElementDeleted(uniqueElementUID)) {
            return cachedUniqueElement;
        }
        return null;
    }

    @Override
    public IUniqueElement getUniqueElement(String uniqueElementUID) {
        return this.getUniqueElementInternal(uniqueElementUID);
    }

    private UniqueElement getUniqueElementInternal(UniqueElementIdentifier uniqueElementIdentifier) {
        UniqueElement modifiedUniqueElement = this.uniqueElementModificationMgr.getUniqueElement(uniqueElementIdentifier);
        if (modifiedUniqueElement != null) {
            return modifiedUniqueElement;
        }
        UniqueElement cachedUniqueElement = this.uniqueElementCache.getUniqueElement(uniqueElementIdentifier);
        if (cachedUniqueElement != null) {
            UniqueElement modificationOfCachedUniqueElement = this.uniqueElementModificationMgr.getUniqueElement(cachedUniqueElement.getUID());
            if (!this.uniqueElementModificationMgr.isUniqueElementDeleted(uniqueElementIdentifier) && modificationOfCachedUniqueElement == null) {
                return cachedUniqueElement;
            }
        }
        return null;
    }

    @Override
    public IUniqueElement getUniqueElement(String name, String type) {
        UniqueElementIdentifier uniqueElementIdentifier = new UniqueElementIdentifier(name, type);
        return this.getUniqueElementInternal(uniqueElementIdentifier);
    }

    public Collection<IPlan> getPlansOfUniqueElement(IUniqueElement uniqueElement) {
        ArrayList<IPlan> plans = new ArrayList<IPlan>();
        OccurrenceList occurences = this.getUniqueElementOccurrences(uniqueElement.getUID());
        for (String planUID : occurences.getPlans()) {
            IPlan plan = this.projectAgent.getFrameSectionManager().getPlan(planUID);
            if (plan != null) {
                plans.add(plan);
                continue;
            }
            assert (false);
            logger.error("Erroneus occurence of uniqueElement (Name=\"" + uniqueElement.getElementName() + "\", UID=\"" + uniqueElement.getUID() + "\") on non-existing plan (planUID=\"" + planUID + "\") still available in Project (projectUID=\"" + uniqueElement.getProjectUID() + "\").");
        }
        return plans;
    }

    @Override
    public List<? extends IUniqueElement> getUniqueElements() {
        Collection<String> cachedElementUIDs = this.uniqueElementCache.getAllUniqueElementUIDs();
        List<UniqueElement> uniqueElements = this.uniqueElementModificationMgr.getUniqueElements();
        Collection<UniqueElement> deletedUniqueElements = this.uniqueElementModificationMgr.getDeletedElements();
        int i = 0;
        while (i < uniqueElements.size()) {
            UniqueElement uniqueElement = uniqueElements.get(i);
            cachedElementUIDs.remove(uniqueElement.getUID());
            ++i;
        }
        for (UniqueElement uniqueElement : deletedUniqueElements) {
            cachedElementUIDs.remove(uniqueElement.getUID());
        }
        for (String uniqueElementUID : cachedElementUIDs) {
            uniqueElements.add(this.uniqueElementCache.getUniqueElement(uniqueElementUID));
        }
        return uniqueElements;
    }

    @Override
    public Collection<IUniqueElement> getUnassignedUniqueElements() {
        HashSet<IUniqueElement> unassignedUniqueElements = new HashSet<IUniqueElement>();
        for (IUniqueElement iUniqueElement : this.getUniqueElements()) {
            if (this.hasOccurrences(iUniqueElement.getUID())) continue;
            unassignedUniqueElements.add(iUniqueElement);
        }
        return unassignedUniqueElements;
    }

    @Override
    public List<IUniqueElement> getUniqueElements(String type) {
        ArrayList<IUniqueElement> uniquElementsOfType = new ArrayList<IUniqueElement>();
        List<? extends IUniqueElement> uniqueElements = this.getUniqueElements();
        for (IUniqueElement iUniqueElement : uniqueElements) {
            if (!iUniqueElement.getElementTypeID().equals(type)) continue;
            uniquElementsOfType.add(iUniqueElement);
        }
        return uniquElementsOfType;
    }

    @Override
    public IUniqueElement createUniqueElement(String name, String type, ObjectTypeCategoryID categoryID) throws EXModificationProblem {
        assert (name != null) : "name can't be null";
        assert (type != null) : "type can't be null";
        UniqueElementIdentifier uniqueElementIdentifier = new UniqueElementIdentifier(name, type);
        ModificationProblem modProblem = null;
        UniqueElement newElement = this.getUniqueElementInternal(uniqueElementIdentifier);
        if (newElement != null) {
            String concequence = NLS.bind((String)Messages.getString("UniqueElementMgr.UEWithSameNameExists.Consequence"), (Object)name);
            String cause = Messages.getString("UniqueElementMgr.UEWithSameNameExists.Cause");
            modProblem = new ModificationProblem(cause, concequence);
            throw new EXModificationProblem(Collections.singletonList(modProblem));
        }
        EOLock uniqueNameLock = new LockRequest(this.projectAgent, this.getRenameOperationForLock(UniqueElementNormalizer.normalizeValue((String)name), type)).createEOLock();
        ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
        ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
        locksToBeChecked.add(uniqueNameLock);
        locksToBeSet.add(uniqueNameLock);
        LockResult lockResult = this.projectAgent.getFrameLockManager().atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
        Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
        if (!lockResult.wasSuccessful()) {
            if (!conflictingLocks.isEmpty()) {
                EOLock conflictingLock = conflictingLocks.iterator().next();
                modProblem = new ModificationProblem(conflictingLock, Messages.getString("UniqueElementMgr.UECannotBeAdded.NoLock"));
                throw new EXModificationProblem(Collections.singletonList(modProblem));
            }
            if (lockResult.getPossibleServerException() != null) {
                modProblem = new ModificationProblem(lockResult.getPossibleServerException(), Messages.getString("UniqueElementMgr.UECannotBeAdded.ServerException"));
                throw new EXModificationProblem(Collections.singletonList(modProblem));
            }
        }
        UniqueElementAttributeModificationManager modManager = new UniqueElementAttributeModificationManager(this.projectAgent);
        newElement = new UniqueElement(UUIDGenerator.getUniqueID(), name, type, categoryID, Collections.emptyList(), modManager, this.projectAgent);
        modManager.setUniqueElement(newElement);
        this.uniqueElementModificationMgr.addCreatedUniqueElement(newElement);
        this.saveUniqueElementModifications();
        PropertyChanges changes = new PropertyChanges((Object)newElement, null, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElement.class);
        return newElement;
    }

    @Override
    public IUniqueElement createUniqueElement(IUniqueElementAddID addID) throws EXNoPermission {
        UniqueElement uniqueElement = (UniqueElement)this.getData(addID);
        UserDefinedAtributeDataManagementFacade.attributeOwnerCreated(uniqueElement);
        UniqueElementAttributeModificationManager modManager = new UniqueElementAttributeModificationManager(this.projectAgent);
        modManager.setUniqueElement(uniqueElement);
        uniqueElement.setAttributeModificationManager(modManager);
        this.uniqueElementModificationMgr.addCreatedUniqueElement(uniqueElement);
        this.saveUniqueElementModifications();
        PropertyChanges changes = new PropertyChanges((Object)uniqueElement, null, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElement.class);
        return uniqueElement;
    }

    @Override
    public void requestUniqueElementCreationPermission(String name, String type) throws EXModificationProblem {
        UniqueElementIdentifier uniqueElementIdentifier = new UniqueElementIdentifier(name, type);
        ModificationProblem modProblem = null;
        UniqueElement newElement = this.getUniqueElementInternal(uniqueElementIdentifier);
        if (newElement != null) {
            String concequence = NLS.bind((String)Messages.getString("UniqueElementMgr.UEWithSameNameExists.Consequence"), (Object)name);
            String cause = Messages.getString("UniqueElementMgr.UEWithSameNameExists.Cause");
            modProblem = new ModificationProblem(cause, concequence);
            throw new EXModificationProblem(Collections.singletonList(modProblem));
        }
        EOLock uniqueNameLock = new LockRequest(this.projectAgent, this.getRenameOperationForLock(UniqueElementNormalizer.normalizeValue((String)name), type)).createEOLock();
        ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
        ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
        locksToBeChecked.add(uniqueNameLock);
        locksToBeSet.add(uniqueNameLock);
        LockResult lockResult = this.projectAgent.getFrameLockManager().atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
        Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
        if (!lockResult.wasSuccessful()) {
            if (!conflictingLocks.isEmpty()) {
                EOLock conflictingLock = conflictingLocks.iterator().next();
                modProblem = new ModificationProblem(conflictingLock, Messages.getString("UniqueElementMgr.UECannotBeAdded.NoLock"));
                throw new EXModificationProblem(Collections.singletonList(modProblem));
            }
            if (lockResult.getPossibleServerException() != null) {
                modProblem = new ModificationProblem(lockResult.getPossibleServerException(), Messages.getString("UniqueElementMgr.UECannotBeAdded.ServerException"));
                throw new EXModificationProblem(Collections.singletonList(modProblem));
            }
        }
    }

    @Override
    public String getRenameOperationForLock(String normalizedNewName, String typeID) {
        return "uniqueName_" + typeID + "_" + normalizedNewName;
    }

    @Override
    public IUniqueElementAddID requestUniqueElementCreationPermission(String name, String elementTypeID, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        UniqueElement uniqueElement = new UniqueElement(UUIDGenerator.getUniqueID(), name, elementTypeID, attributes, IAttributeModificationManager.DUMMY, this.projectAgent);
        uniqueElement.setCategoryID(objectTypeCategoryID);
        return this.requestUniqueElementCreationPermissionInternal(uniqueElement);
    }

    @Override
    public IUniqueElementAddID requestUniqueElementCreationPermission(String uniqueElementUID, String name, String elementTypeID, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        UniqueElement uniqueElement = new UniqueElement(uniqueElementUID, name, elementTypeID, attributes, IAttributeModificationManager.DUMMY, this.projectAgent);
        uniqueElement.setCategoryID(objectTypeCategoryID);
        return this.requestUniqueElementCreationPermissionInternal(uniqueElement);
    }

    @Override
    public IUniqueElementAddID requestUniqueElementImportPermission(EOUniqueElement eoUniqueElement) {
        UniqueElement uniqueElement = new UniqueElement(eoUniqueElement, IAttributeModificationManager.DUMMY, this.projectAgent);
        return this.requestUniqueElementCreationPermissionInternal(uniqueElement);
    }

    private IUniqueElementAddID requestUniqueElementCreationPermissionInternal(IUniqueElement uniqueElement) {
        ModificationProblem mp;
        IUniqueElementAddID addID;
        String uniqueElementTypeID;
        ModificationProblem modProblem = null;
        String uniqueElementName = uniqueElement.getElementName();
        UniqueElementIdentifier uniqueElementIdentifier = new UniqueElementIdentifier(uniqueElementName, uniqueElementTypeID = uniqueElement.getElementTypeID());
        IUniqueElement newElement = this.getUniqueElementInternal(uniqueElementIdentifier);
        if (newElement == null) {
            for (IUniqueElement ue : this.grantedAddIDs.values()) {
                if (!ue.getElementName().equals(uniqueElementName) || !ue.getElementTypeID().equals(uniqueElementTypeID)) continue;
                newElement = ue;
            }
        }
        if (newElement != null) {
            String causerDescription = NLS.bind((String)Messages.getString("UniqueElementMgr.UEWithSameNameExists"), (Object)uniqueElementName);
            modProblem = new ModificationProblem(causerDescription, Messages.getString("UniqueElementMgr.UECannotBeAdded"));
        }
        if (modProblem == null) {
            IFrameLockManager lockMgr = this.projectAgent.getFrameLockManager();
            EOLock uniqueNameLock = new LockRequest(this.projectAgent, this.getRenameOperationForLock(UniqueElementNormalizer.normalizeValue((String)uniqueElementName), uniqueElementTypeID)).createEOLock();
            ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
            ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
            locksToBeChecked.add(uniqueNameLock);
            locksToBeSet.add(uniqueNameLock);
            LockResult lockResult = lockMgr.atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
            Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
            if (!lockResult.wasSuccessful()) {
                if (!conflictingLocks.isEmpty()) {
                    EOLock conflictingLock = conflictingLocks.iterator().next();
                    modProblem = new ModificationProblem(conflictingLock, Messages.getString("UniqueElementMgr.UECannotBeAdded"));
                } else if (lockResult.getPossibleServerException() != null) {
                    modProblem = new ModificationProblem(lockResult.getPossibleServerException(), Messages.getString("UniqueElementMgr.UECannotBeAdded.ServerException"));
                }
            }
        }
        if ((addID = new IUniqueElementAddID(mp = modProblem){
            private final /* synthetic */ IModificationProblem val$mp;
            {
                this.val$mp = iModificationProblem;
            }

            @Override
            public boolean permissionGranted() {
                return this.val$mp == null;
            }

            @Override
            public IModificationProblem getModificationProblem() {
                return this.val$mp;
            }
        }).permissionGranted()) {
            this.grantedAddIDs.put(addID, uniqueElement);
        }
        return addID;
    }

    private Object getData(IDataAddID dataAddID) {
        IUniqueElement data = this.grantedAddIDs.get(dataAddID);
        this.grantedAddIDs.remove(dataAddID);
        return data;
    }

    @Override
    public IModificationProblem checkUniqueElementCreationPermission(String name, String type, boolean includingLocks) {
        ModificationProblem modProblem = null;
        Throwable serverException = null;
        if (includingLocks) {
            try {
                EOLock conflictingLock = this.projectAgent.getFrameLockManager().anotherClientHasProjectLock();
                if (conflictingLock == null) {
                    conflictingLock = this.projectAgent.getFrameLockManager().anotherClientHasLock(this.projectAgent, this.getRenameOperationForLock(UniqueElementNormalizer.normalizeValue((String)name), type));
                }
                if (conflictingLock != null) {
                    modProblem = new ModificationProblem(conflictingLock, Messages.getString("UniqueElementMgr.UECannotBeAdded.NoLock"));
                }
            }
            catch (ServerNotAvailableException e) {
                serverException = e;
            }
            catch (LoginCanceledException e) {
                serverException = e;
            }
            catch (EXServerException e) {
                serverException = e;
            }
            catch (UnknownServerException e) {
                serverException = e;
            }
            if (serverException != null) {
                modProblem = new ModificationProblem((Exception)serverException, Messages.getString("UniqueElementMgr.UECannotBeAdded.NoLock"));
            }
        }
        return modProblem;
    }

    public void deleteUniqueElement(String uniqueElementUID) throws EXModificationProblem {
        boolean wasCreatedOnClient;
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        UniqueElement uniqueElementToDelete = this.getUniqueElementInternal(uniqueElementUID);
        if (uniqueElementToDelete == null) {
            return;
        }
        if (this.getUniqueElementOccurrences(uniqueElementUID).size() > 0) {
            return;
        }
        List<ICockpitProjectData> linkedModuleData = this.linkFacade.getCrossLinkedModuleData(uniqueElementUID, ILinkContentProvider.NO_LINK_TYPE_FILTER);
        if (!linkedModuleData.isEmpty()) {
            return;
        }
        boolean bl = wasCreatedOnClient = this.uniqueElementModificationMgr.getCreatedUniqueElement(uniqueElementUID) != null;
        if (!wasCreatedOnClient) {
            EOLock addLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectAgent.getProjectUID(), "add", uniqueElementUID, "com.arcway.cockpit.uniqueelement", "", "", new Timestamp(System.currentTimeMillis()));
            EOLock delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectAgent.getProjectUID(), "delete", uniqueElementUID, "com.arcway.cockpit.uniqueelement", "", "", new Timestamp(System.currentTimeMillis()));
            EOLock modLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectAgent.getProjectUID(), "modify", uniqueElementUID, "com.arcway.cockpit.uniqueelement", "", "", new Timestamp(System.currentTimeMillis()));
            ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
            ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
            locksToBeChecked.add(addLock);
            locksToBeChecked.add(delLock);
            locksToBeChecked.add(modLock);
            locksToBeSet.add(delLock);
            locksToBeSet.add(modLock);
            LockResult lockResult = this.projectAgent.getFrameLockManager().atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
            if (lockResult.getPossibleServerException() != null) {
                ArrayList<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
                modificationProblems.add(new ModificationProblem(lockResult.getPossibleServerException(), Messages.getString("UniqueElementMgr.delNotPossibleServerEX")));
                throw new EXModificationProblem(modificationProblems);
            }
            Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
            if (!conflictingLocks.isEmpty()) {
                ArrayList<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
                for (EOLock conflictingLock : conflictingLocks) {
                    modificationProblems.add(new ModificationProblem(conflictingLock, Messages.getString("UniqueElementMgr.delNotPossibleNoLock")));
                }
                throw new EXModificationProblem(modificationProblems);
            }
        }
        if (this.uniqueElementModificationMgr.containsCreatedUniqueElement(uniqueElementUID)) {
            this.uniqueElementModificationMgr.removeCreatedUniqueElement(uniqueElementUID);
        } else if (this.uniqueElementModificationMgr.containsModifiedUniqueElement(uniqueElementUID)) {
            this.uniqueElementModificationMgr.removeModifiedUniqueElement(uniqueElementUID);
            this.uniqueElementModificationMgr.addDeletedUniqueElement(uniqueElementToDelete);
        } else {
            this.uniqueElementModificationMgr.addDeletedUniqueElement(uniqueElementToDelete);
        }
        UserDefinedAtributeDataManagementFacade.attributeOwnerDeleted(uniqueElementToDelete);
        this.projectAgent.getUniqueElementLinkFacade().linkableObjectDeleted((ICockpitProjectData)uniqueElementToDelete);
        PropertyChanges changes = new PropertyChanges(null, null, (Object)uniqueElementToDelete);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElement.class);
        this.saveUniqueElementModifications();
    }

    private void saveUniqueElementModifications() {
        this.modificationFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOList<EOList<EOUniqueElement>>>(){

            public EOList<EOList<EOUniqueElement>> getFileContent() {
                EOList eoTree;
                if (UniqueElementMgr.this.uniqueElementModificationMgr.isModified()) {
                    EOList uniqueElementModifications = new EOList();
                    EOList<EOUniqueElement> createdUniqueElements = UniqueElementMgr.this.uniqueElementModificationMgr.getCreatedUniqueElementsAsEO();
                    createdUniqueElements.setRole("Created_unique_elements");
                    uniqueElementModifications.add(createdUniqueElements);
                    EOList<EOUniqueElement> modifiedUniqueElements = UniqueElementMgr.this.uniqueElementModificationMgr.getModifiedUniqueElementsAsEO();
                    modifiedUniqueElements.setRole("Modified_unique_elements");
                    uniqueElementModifications.add(modifiedUniqueElements);
                    EOList<EOUniqueElement> deletedUniqueElements = UniqueElementMgr.this.uniqueElementModificationMgr.getDeletedUniqueElementsAsEO();
                    deletedUniqueElements.setRole("Deleted_unique_elements");
                    uniqueElementModifications.add(deletedUniqueElements);
                    eoTree = uniqueElementModifications;
                } else {
                    eoTree = null;
                }
                return eoTree;
            }
        });
    }

    public boolean isAssignedToUniqueElement(String planUID, String planElementUID) {
        assert (planUID != null) : "planUID can't be null";
        assert (planElementUID != null) : "planElementUID can't be null";
        return this.getUniqueElementOfOccurrence(planUID, planElementUID) != null;
    }

    @Override
    public boolean hasOccurrencesOnPlan(String uniqueElementUID, String planUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        assert (planUID != null) : "planUID can't be null";
        return !this.getUniqueElementOccurrencesOnPlan(uniqueElementUID, planUID).isEmpty();
    }

    @Override
    public boolean hasOccurrences(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        return !this.getUniqueElementOccurrences(uniqueElementUID).isEmpty();
    }

    public IUniqueElement getUniqueElementOfOccurrence(String planUID, String planElementUID) {
        assert (planUID != null) : "planUID can't be null";
        assert (planElementUID != null) : "planElementUID can't be null";
        EOUniqueElementOccurrence occurrence = this.getEOUniqueElementOccurrence(planUID, planElementUID);
        if (occurrence != null) {
            String uniqueElementUID = occurrence.getElementUID();
            return this.getUniqueElement(uniqueElementUID);
        }
        return null;
    }

    public EOUniqueElementOccurrence getEOUniqueElementOccurrence(String planUID, String planElementUID) {
        assert (planUID != null) : "planUID can't be null";
        assert (planElementUID != null) : "planElementUID can't be null";
        EOUniqueElementOccurrence occurence = null;
        EOUniqueElementOccurrence createdOccurrence = this.uniqueElementOccurrenceModificationMgr.getCreatedUniqueElementOccurrence(planUID, planElementUID);
        if (createdOccurrence != null) {
            occurence = createdOccurrence;
        } else {
            EOUniqueElementOccurrence cachedOccurrence = this.uniqueElementOccurrenceCache.getUniqueElementOccurrence(planUID, planElementUID);
            if (cachedOccurrence != null) {
                occurence = cachedOccurrence;
                EOUniqueElementOccurrence deletedOccurrence = this.uniqueElementOccurrenceModificationMgr.getDeletedUniqueElementOccurrence(planUID, planElementUID);
                if (deletedOccurrence != null) {
                    occurence = null;
                }
            }
        }
        return occurence;
    }

    @Override
    public IUniqueElementOccurrence getUniqueElementOccurrence1(String planUID, String planElementUID) {
        return this.getEOUniqueElementOccurrence(planUID, planElementUID);
    }

    @Override
    public Collection<? extends IUniqueElementOccurrence> getUniqueElementOccurrencesOfPlan(IPlan plan) {
        OccurrenceList occurrenceList = this.getUniqueElementOccurrencesForPlan(plan.getUID());
        return occurrenceList;
    }

    @Override
    public OccurrenceList getUniqueElementOccurrencesForPlan(String planUID) {
        assert (planUID != null) : "planUID can't be null";
        OccurrenceList occurrencesForPlan = this.uniqueElementOccurrenceCache.getOccurrencesForPlan(planUID);
        occurrencesForPlan.removeAll(this.uniqueElementOccurrenceModificationMgr.getDeletedUniqueElementOccurrences(planUID));
        occurrencesForPlan.addAll((Collection<? extends EOUniqueElementOccurrence>)this.uniqueElementOccurrenceModificationMgr.getCreatedUniqueElementOccurrences(planUID));
        return occurrencesForPlan;
    }

    @Override
    public Collection<IUniqueElement> getUniqueElementsOfPlan(String planUID) {
        assert (planUID != null) : "planUID can't be null";
        OccurrenceList occurrences = this.getUniqueElementOccurrencesForPlan(planUID);
        return occurrences.getUniqueElementsOfPlan(planUID);
    }

    @Override
    public OccurrenceList getUniqueElementOccurrences(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        OccurrenceList occurrences = this.uniqueElementOccurrenceCache.getOccurrencesForUniqueElement(uniqueElementUID);
        Collection<EOUniqueElementOccurrence> createdOccurrences = this.uniqueElementOccurrenceModificationMgr.getCreatedUniqueElementOccurrences();
        for (EOUniqueElementOccurrence createdOccurrence : createdOccurrences) {
            if (!createdOccurrence.getElementUID().equals(uniqueElementUID)) continue;
            occurrences.add(createdOccurrence);
        }
        Collection<EOUniqueElementOccurrence> deletedOccurrences = this.uniqueElementOccurrenceModificationMgr.getDeletedUniqueElementOccurrences();
        for (EOUniqueElementOccurrence deletedOccurrence : deletedOccurrences) {
            if (!deletedOccurrence.getElementUID().equals(uniqueElementUID)) continue;
            occurrences.remove(deletedOccurrence.getPlanUID(), deletedOccurrence.getPlanElementUID());
        }
        return occurrences;
    }

    public Collection<EOUniqueElementOccurrence> getUniqueElementOccurrencesOnPlan(String uniqueElementUID, String planUID) {
        OccurrenceList allOccurrencesOfUniqueElement = this.getUniqueElementOccurrences(uniqueElementUID);
        return allOccurrencesOfUniqueElement.getUniqueElementOccurrencesOnPlan(planUID);
    }

    @Override
    public void updateRelationshipsUnsaved(IExternalPlanEditorControllerExtension planEditorControllerExtension, boolean removeOrphanedOccurences) {
        String planUID = planEditorControllerExtension.getPlanUID();
        Collection<? extends IPlanAgentStructuredPlanElement> structuredPlanElements = planEditorControllerExtension.getPlanStructure();
        Collection<Object> removedOccurences = removeOrphanedOccurences ? this.removeOrphanedUniqueElementOccurences(planUID, structuredPlanElements) : Collections.emptyList();
        this.projectAgent.getUniqueElementRelationshipManager().uniqueElementOccurrencesOrPlanStructureChanged_internal(planUID, structuredPlanElements);
        if (!removedOccurences.isEmpty()) {
            PropertyChanges changes = new PropertyChanges(null, null, removedOccurences);
            this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElementOccurrence.class);
        }
    }

    private Collection<EOUniqueElementOccurrence> removeOrphanedUniqueElementOccurences(String planUID, Collection<? extends IPlanAgentStructuredPlanElement> structuredPlanElements) {
        HashSet<String> exisitingPlanElementUIDs = new HashSet<String>(2 * structuredPlanElements.size());
        for (IPlanAgentStructuredPlanElement iPlanAgentStructuredPlanElement : structuredPlanElements) {
            exisitingPlanElementUIDs.add(iPlanAgentStructuredPlanElement.getPlanElementUID());
        }
        OccurrenceList occurrenceList = this.getUniqueElementOccurrencesForPlan(planUID);
        ArrayList<EOUniqueElementOccurrence> removedOccurences = new ArrayList<EOUniqueElementOccurrence>(occurrenceList.size());
        for (IUniqueElementOccurrence occurence : occurrenceList) {
            String planElementUID = occurence.getPlanElementUID();
            if (exisitingPlanElementUIDs.contains(planElementUID)) continue;
            EOUniqueElementOccurrence removedOccurrence = this.deleteUniqueElementOccurenceWithoutInforming(planUID, planElementUID);
            logger.warn("orphaned unique element occurence removed: " + planElementUID);
            if (removedOccurrence == null) continue;
            removedOccurences.add(removedOccurrence);
        }
        return removedOccurences;
    }

    @Override
    public void createUniqueElementOccurencesUnsaved(IExternalPlanEditorControllerExtension planEditorControllerExtension, Map<String, String> planElementUIDs2uniqueElementUID) throws EXModificationProblem {
        this.createUniqueElementOccurencesUnsaved(planEditorControllerExtension.getPlan().getUID(), planEditorControllerExtension.getPlanStructure(), planElementUIDs2uniqueElementUID);
    }

    private void createUniqueElementOccurencesUnsaved(String planUID, Collection<? extends IPlanAgentStructuredPlanElement> structuredPlanElements, Map<String, String> planElementUIDs2uniqueElementUID) throws EXModificationProblem {
        assert (planUID != null);
        assert (planElementUIDs2uniqueElementUID != null) : "planElementUID2uniqueElementUID can't be null";
        ArrayList<EOUniqueElementOccurrence> createdOccurences = new ArrayList<EOUniqueElementOccurrence>(planElementUIDs2uniqueElementUID.size());
        ArrayList<EOUniqueElementOccurrence> removedOccurences = new ArrayList<EOUniqueElementOccurrence>(planElementUIDs2uniqueElementUID.size());
        this.allocateOccurrenceLocks(planUID, planElementUIDs2uniqueElementUID.values());
        for (Map.Entry<String, String> planElementUID2uniqueElementUID : planElementUIDs2uniqueElementUID.entrySet()) {
            EOUniqueElementOccurrence deletedOccurrence;
            String planElementUID = planElementUID2uniqueElementUID.getKey();
            String uniqueElementUID = planElementUID2uniqueElementUID.getValue();
            EOUniqueElementOccurrence newOccurrence = null;
            boolean finished = false;
            if (this.uniqueElementOccurrenceModificationMgr.containsDeletedUniqueElementOccurrence(planUID, planElementUID) && (deletedOccurrence = this.uniqueElementOccurrenceModificationMgr.getDeletedUniqueElementOccurrence(planUID, planElementUID)).getElementUID().equals(uniqueElementUID)) {
                newOccurrence = deletedOccurrence;
                EOUniqueElementOccurrence removedCreatedOccurence = this.uniqueElementOccurrenceModificationMgr.removeCreatedUniqueElementOccurrence(planUID, planElementUID);
                if (removedCreatedOccurence != null) {
                    removedOccurences.add(removedCreatedOccurence);
                }
                this.uniqueElementOccurrenceModificationMgr.removeDeletedUniqueElementOccurrence(planUID, planElementUID);
                finished = true;
            }
            if (!finished) {
                if (this.uniqueElementOccurrenceModificationMgr.containsCreatedUniqueElementOccurrence(planUID, planElementUID)) {
                    EOUniqueElementOccurrence occurrence = this.uniqueElementOccurrenceModificationMgr.getCreatedUniqueElementOccurrence(planUID, planElementUID);
                    String uidOfAssignedElement = occurrence.getElementUID();
                    if (uidOfAssignedElement.equals(uniqueElementUID)) {
                        newOccurrence = occurrence;
                    } else {
                        this.uniqueElementOccurrenceModificationMgr.removeCreatedUniqueElementOccurrence(planUID, planElementUID);
                        newOccurrence = new EOUniqueElementOccurrence();
                        newOccurrence.setPlanUID(planUID);
                        newOccurrence.setPlanElementUID(planElementUID);
                        newOccurrence.setElementUID(uniqueElementUID);
                        newOccurrence.setProjectUID(this.projectAgent.getUID());
                        this.uniqueElementOccurrenceModificationMgr.addCreatedUniqueElementOccurrence(newOccurrence);
                    }
                } else {
                    EOUniqueElementOccurrence cachedOccurrence = this.uniqueElementOccurrenceCache.getUniqueElementOccurrence(planUID, planElementUID);
                    if (cachedOccurrence != null) {
                        if (cachedOccurrence.getElementUID().equals(uniqueElementUID)) {
                            newOccurrence = cachedOccurrence;
                        } else {
                            if (!this.uniqueElementOccurrenceModificationMgr.containsDeletedUniqueElementOccurrence(planUID, planElementUID)) {
                                this.uniqueElementOccurrenceModificationMgr.addDeletedUniqueElementOccurrence(cachedOccurrence);
                            }
                            newOccurrence = new EOUniqueElementOccurrence();
                            newOccurrence.setPlanUID(planUID);
                            newOccurrence.setPlanElementUID(planElementUID);
                            newOccurrence.setElementUID(uniqueElementUID);
                            newOccurrence.setProjectUID(this.projectAgent.getUID());
                            this.uniqueElementOccurrenceModificationMgr.addCreatedUniqueElementOccurrence(newOccurrence);
                        }
                    } else {
                        newOccurrence = new EOUniqueElementOccurrence();
                        newOccurrence.setPlanUID(planUID);
                        newOccurrence.setPlanElementUID(planElementUID);
                        newOccurrence.setElementUID(uniqueElementUID);
                        newOccurrence.setProjectUID(this.projectAgent.getUID());
                        this.uniqueElementOccurrenceModificationMgr.addCreatedUniqueElementOccurrence(newOccurrence);
                    }
                }
            }
            createdOccurences.add(newOccurrence);
        }
        this.projectAgent.getUniqueElementRelationshipManager().uniqueElementOccurrencesOrPlanStructureChanged_internal(planUID, structuredPlanElements);
        PropertyChanges changes = new PropertyChanges(createdOccurences, null, removedOccurences);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElementOccurrence.class);
    }

    private void allocateOccurrenceLocks(String planUID, Collection<String> uniqueElementUIDs) throws EXModificationProblem {
        ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
        ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
        boolean locksTohandle = false;
        for (String uniqueElementUID : uniqueElementUIDs) {
            if (this.isLocallyAdded(uniqueElementUID)) continue;
            locksTohandle = true;
            EOLock addLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectAgent.getProjectUID(), "add", uniqueElementUID, "com.arcway.cockpit.uniqueelement", null, null, new Timestamp(System.currentTimeMillis()));
            EOLock delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectAgent.getProjectUID(), "delete", uniqueElementUID, "com.arcway.cockpit.uniqueelement", null, null, new Timestamp(System.currentTimeMillis()));
            locksToBeChecked.add(delLock);
            locksToBeSet.add(addLock);
        }
        if (locksTohandle) {
            LockResult lockResult = this.projectAgent.getFrameLockManager().atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
            if (lockResult.getPossibleServerException() != null) {
                ArrayList<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
                modificationProblems.add(new ModificationProblem(lockResult.getPossibleServerException(), Messages.getString("UniqueElementMgr.cannotCreateOccurencePossibleServerEX")));
                throw new EXModificationProblem(modificationProblems);
            }
            Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
            if (!conflictingLocks.isEmpty()) {
                ArrayList<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
                for (EOLock conflictingLock : conflictingLocks) {
                    modificationProblems.add(new ModificationProblem(conflictingLock, Messages.getString("UniqueElementMgr.cannotCreateOccurence")));
                }
                throw new EXModificationProblem(modificationProblems);
            }
            this.uniqueElementOccurrenceModificationMgr.addTemporaryLockResult(planUID, lockResult);
        }
    }

    private EOUniqueElementOccurrence deleteUniqueElementOccurenceWithoutInforming(String planUID, String planElementUID) {
        EOUniqueElementOccurrence removedOccurence;
        assert (planUID != null);
        assert (planElementUID != null) : "planElementUID can't be null";
        EOUniqueElementOccurrence cachedOccurrence = this.uniqueElementOccurrenceCache.getUniqueElementOccurrence(planUID, planElementUID);
        if (cachedOccurrence != null) {
            this.uniqueElementOccurrenceModificationMgr.addDeletedUniqueElementOccurrence(cachedOccurrence);
            removedOccurence = cachedOccurrence;
        } else {
            removedOccurence = this.uniqueElementOccurrenceModificationMgr.removeCreatedUniqueElementOccurrence(planUID, planElementUID);
        }
        return removedOccurence;
    }

    @Override
    public void deleteUniqueElementOccurencesUnsaved(IExternalPlanEditorControllerExtension planEditorControllerExtension, Collection<String> planElementUIDs) {
        this.deleteUniqueElementOccurencesUnsaved(planEditorControllerExtension.getPlan().getUID(), planEditorControllerExtension.getPlanStructure(), planElementUIDs);
    }

    private void deleteUniqueElementOccurencesUnsaved(String planUID, Collection<? extends IPlanAgentStructuredPlanElement> planStructure, Collection<String> planElementUIDs) {
        ArrayList<EOUniqueElementOccurrence> removedOccurences = new ArrayList<EOUniqueElementOccurrence>(planElementUIDs.size());
        for (String planElementUID : planElementUIDs) {
            EOUniqueElementOccurrence removedOccurrence = this.deleteUniqueElementOccurenceWithoutInforming(planUID, planElementUID);
            if (removedOccurrence == null) continue;
            removedOccurences.add(removedOccurrence);
        }
        this.projectAgent.getUniqueElementRelationshipManager().uniqueElementOccurrencesOrPlanStructureChanged_internal(planUID, planStructure);
        PropertyChanges changes = new PropertyChanges(null, null, removedOccurences);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElementOccurrence.class);
    }

    private void notifyUniqueElementPropertyChanges() {
        PropertyChanges changes = new PropertyChanges(null, null, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElement.class);
    }

    public boolean isModified(String planUID) {
        assert (planUID != null) : "planUID can't be null";
        return this.uniqueElementOccurrenceModificationMgr.isModified(planUID);
    }

    public EOList<EOList<EOUniqueElementOccurrence>> getModifications(String planUID) {
        assert (planUID != null) : "planUID can't be null";
        EOList uniqueElementOccurrenceModifications = new EOList();
        EOList createdOccurrences = new EOList(this.uniqueElementOccurrenceModificationMgr.getCreatedUniqueElementOccurrences(planUID));
        createdOccurrences.setRole("Created_unique_element_occurrences");
        uniqueElementOccurrenceModifications.add((EncodableObjectBase)createdOccurrences);
        EOList deletedOccurrences = new EOList(this.uniqueElementOccurrenceModificationMgr.getDeletedUniqueElementOccurrences(planUID));
        deletedOccurrences.setRole("Deleted_unique_element_occurrences");
        uniqueElementOccurrenceModifications.add((EncodableObjectBase)deletedOccurrences);
        return uniqueElementOccurrenceModifications;
    }

    public EOUniqueElementModification getModification() {
        EOUniqueElementModification mod = new EOUniqueElementModification();
        mod.setCreatedOccurrences(this.uniqueElementOccurrenceModificationMgr.getCreatedUniqueElementOccurrences());
        mod.setDeletedOccurrences(this.uniqueElementOccurrenceModificationMgr.getDeletedUniqueElementOccurrences());
        mod.setCreatedUniqueElements(this.uniqueElementModificationMgr.getCreatedUniqueElementsAsEO());
        mod.setModifiedUniqueElements(this.uniqueElementModificationMgr.getModifiedUniqueElementsAsEO());
        mod.setDeletedUniqueElements(this.uniqueElementModificationMgr.getDeletedUniqueElementsAsEO());
        return mod;
    }

    @Override
    public void saveOccurenceAndRelationShipModifications(IExternalPlanEditorControllerExtension planEditorControllerExtension) {
        this.saveUniqueElementOccurrenceAndRelationshipModifications(planEditorControllerExtension.getPlanUID());
    }

    private void saveUniqueElementOccurrenceAndRelationshipModifications(String planUID) {
        this.saveUniqueElementOccurrenceModifications(planUID);
        this.saveUniqueElementRelationshipModifications(planUID);
    }

    private void saveUniqueElementOccurrenceModifications(String planUID) {
        assert (planUID != null) : "planUID can't be null";
        if (this.uniqueElementOccurrenceModificationMgr.isModified(planUID)) {
            this.uniqueElementOccurrenceModificationMgr.saveUniqueElementOccurrenceModifications(this.getModifications(planUID), planUID);
        } else {
            this.uniqueElementOccurrenceModificationMgr.saveUniqueElementOccurrenceModifications(null, planUID);
        }
    }

    private void saveUniqueElementRelationshipModifications(String planUID) {
        this.projectAgent.getUniqueElementRelationshipManager().writeUniqueElementRelationships(planUID);
    }

    @Override
    public void discardOccurenceAndRelationShipModifications(IExternalPlanEditorControllerExtension planEditorControllerExtension) {
        this.reloadOccurenceAndRelationShipModifications(planEditorControllerExtension.getPlanUID());
    }

    private void reloadOccurenceAndRelationShipModifications(final String planUID) {
        this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                UniqueElementMgr.this.reloadUniqueElementOccurenceModifications(planUID);
                UniqueElementMgr.this.reloadUniqueElementRelationshipModifications(planUID);
            }
        });
        this.notifyUniqueElementPropertyChanges();
    }

    private void reloadUniqueElementRelationshipModifications(String planUID) {
        this.projectAgent.getUniqueElementRelationshipManager().reloadUniqueElementRelationships(planUID);
    }

    private void reloadUniqueElementOccurenceModifications(String planUID) {
        assert (planUID != null) : "planUID can't be null";
        this.uniqueElementOccurrenceModificationMgr.removeModifications(planUID);
        EOList<EOList<EOUniqueElementOccurrence>> readModification = this.readUniqueElementOccurrenceModifications(planUID);
        if (readModification.size() > 0) {
            this.uniqueElementOccurrenceModificationMgr.addModifications((Collection)readModification.get(0), (Collection)readModification.get(1));
        }
    }

    private EOList<EOList<EOUniqueElementOccurrence>> readUniqueElementOccurrenceModifications(String planUID) {
        assert (planUID != null) : "planUID can't be null";
        return this.uniqueElementOccurrenceModificationMgr.readUniqueElementOccurrenceModifications(planUID);
    }

    public void applyAsynchronousUniqueElementModifications(EOUniqueElementModification modification) {
        ArrayList<UniqueElement> addedUEs = new ArrayList<UniqueElement>();
        ArrayList<IUniqueElement> modifiedUEs = new ArrayList<IUniqueElement>();
        for (EOUniqueElement createdEOUniqueElement : modification.getCreatedUniqueElements()) {
            UniqueElement ue = this.createUniqueElement(createdEOUniqueElement);
            this.uniqueElementCache.addUniqueElement(ue);
            addedUEs.add(ue);
        }
        HashMap<String, ArrayList<String>> planUIDs_2_planElementUIDs = new HashMap<String, ArrayList<String>>();
        for (EOUniqueElement modifiedEOUniqueElement : modification.getModifiedUniqueElements()) {
            UniqueElement modifiedUniqueElement = this.createUniqueElement(modifiedEOUniqueElement);
            this.uniqueElementCache.replaceUniqueElement(modifiedUniqueElement);
            modifiedUEs.add(modifiedUniqueElement);
            OccurrenceList occurrences = this.getUniqueElementOccurrences(modifiedUniqueElement.getUID());
            for (EOUniqueElementOccurrence occurrence : occurrences) {
                String planUID = occurrence.getPlanUID();
                String planElementUID = occurrence.getPlanElementUID();
                ArrayList<String> planElementUIDs = (ArrayList<String>)planUIDs_2_planElementUIDs.get(planUID);
                if (planElementUIDs == null) {
                    planElementUIDs = new ArrayList<String>();
                    planUIDs_2_planElementUIDs.put(planUID, planElementUIDs);
                }
                planElementUIDs.add(planElementUID);
            }
        }
        for (Map.Entry planUID_2_planElementUIDs : planUIDs_2_planElementUIDs.entrySet()) {
            String planUID = (String)planUID_2_planElementUIDs.getKey();
            Collection planElementUIDs = (Collection)planUID_2_planElementUIDs.getValue();
            this.planAgentManager.uniqueElementsChanged(planUID, planElementUIDs);
        }
        for (EOUniqueElementOccurrence occurrenceToRemove : modification.getDeletedOccurrences()) {
            this.uniqueElementOccurrenceCache.removeUniqueElementOccurrence(occurrenceToRemove);
        }
        for (EOUniqueElementOccurrence createdOccurrence : modification.getCreatedOccurrences()) {
            this.uniqueElementOccurrenceCache.addUniqueElementOccurrence(createdOccurrence);
        }
        modifiedUEs.addAll(this.getUniqueElements((Collection<? extends IUniqueElementOccurrence>)modification.getCreatedOccurrences()));
        modifiedUEs.addAll(this.getUniqueElements((Collection<? extends IUniqueElementOccurrence>)modification.getDeletedOccurrences()));
        PropertyChanges changes = new PropertyChanges(addedUEs, modifiedUEs, Collections.emptyList(), true);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElement.class);
    }

    private Collection<IUniqueElement> getUniqueElements(Collection<? extends IUniqueElementOccurrence> occurrences) {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>();
        for (IUniqueElementOccurrence iUniqueElementOccurrence : occurrences) {
            this.addUniqueElement(iUniqueElementOccurrence, uniqueElements);
        }
        return uniqueElements;
    }

    private void addUniqueElement(IUniqueElementOccurrence occurrence, Collection<IUniqueElement> uniqueElements) {
        IUniqueElement ue = this.getUniqueElement(occurrence.getElementUID());
        for (IUniqueElement containedUE : uniqueElements) {
            if (!containedUE.getUID().equals(ue.getUID())) continue;
            return;
        }
        uniqueElements.add(ue);
    }

    public void applyAsynchronousUniqueElementDeletions(EOUniqueElementModification modification) {
        ArrayList<UniqueElement> deletedElements = new ArrayList<UniqueElement>();
        for (EOUniqueElement eoDeletedUniqueElement : modification.getDeletedUniqueElements()) {
            UniqueElement elementToBeDeleted = this.getUniqueElementInternal(eoDeletedUniqueElement.getUID());
            if (elementToBeDeleted != null) {
                deletedElements.add(elementToBeDeleted);
            }
            this.secureAsynchronousUniqueElementDeletion(eoDeletedUniqueElement.getUID());
        }
        PropertyChanges changes = new PropertyChanges(Collections.emptyList(), Collections.emptyList(), deletedElements, true);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElement.class);
    }

    public void applySynchronousUniqueElementModificationsExceptDeletions(EOUniqueElementModification modification) {
        if (modification != null) {
            String planUID;
            HashSet<String> changedPlanUIDs = new HashSet<String>();
            for (EOUniqueElement eoCreatedUniqueElement : modification.getCreatedUniqueElements()) {
                UniqueElement createdUniqueElement = this.createUniqueElement(eoCreatedUniqueElement);
                this.uniqueElementCache.addUniqueElement(createdUniqueElement);
                this.uniqueElementModificationMgr.removeCreatedUniqueElement(createdUniqueElement.getUID());
            }
            for (EOUniqueElement eoModifiedUniqueElement : modification.getModifiedUniqueElements()) {
                UniqueElement modifiedUniqueElement = this.createUniqueElement(eoModifiedUniqueElement);
                this.uniqueElementCache.replaceUniqueElement(modifiedUniqueElement);
                this.uniqueElementModificationMgr.removeModifiedUniqueElement(modifiedUniqueElement.getUID());
            }
            for (EOUniqueElementOccurrence occurrenceToRemove : modification.getDeletedOccurrences()) {
                planUID = occurrenceToRemove.getPlanUID();
                this.uniqueElementOccurrenceCache.removeUniqueElementOccurrence(occurrenceToRemove);
                this.uniqueElementOccurrenceModificationMgr.removeDeletedUniqueElementOccurrence(planUID, occurrenceToRemove.getPlanElementUID());
                changedPlanUIDs.add(planUID);
            }
            for (EOUniqueElementOccurrence createdOccurrence : modification.getCreatedOccurrences()) {
                planUID = createdOccurrence.getPlanUID();
                this.uniqueElementOccurrenceCache.addUniqueElementOccurrence(createdOccurrence);
                this.uniqueElementOccurrenceModificationMgr.removeCreatedUniqueElementOccurrence(planUID, createdOccurrence.getPlanElementUID());
                changedPlanUIDs.add(planUID);
            }
            this.saveUniqueElementModifications();
            for (String planUID2 : changedPlanUIDs) {
                this.saveUniqueElementOccurrenceModifications(planUID2);
            }
        }
    }

    private UniqueElement createUniqueElement(EOUniqueElement eo) {
        UniqueElementAttributeModificationManager modManager = new UniqueElementAttributeModificationManager(this.projectAgent);
        UniqueElement ue = new UniqueElement(eo, modManager, this.projectAgent);
        modManager.setUniqueElement(ue);
        return ue;
    }

    public void applySynchronousUniqueElementDeletions(List<EOUniqueElement> deletedUniqueElements) {
        assert (deletedUniqueElements != null) : "deletedUniqueElements can't be null";
        int i = 0;
        while (i < deletedUniqueElements.size()) {
            EOUniqueElement deletedUniqueElement = deletedUniqueElements.get(i);
            this.uniqueElementCache.deleteUniqueElement(deletedUniqueElement.getUID());
            this.uniqueElementModificationMgr.removeDeletedUniqueElement(deletedUniqueElement.getUID());
            ++i;
        }
        this.saveUniqueElementModifications();
    }

    private void secureAsynchronousUniqueElementDeletion(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        OccurrenceList occurrences = this.getUniqueElementOccurrences(uniqueElementUID);
        if (occurrences.size() == 0) {
            this.uniqueElementCache.deleteUniqueElement(uniqueElementUID);
        } else {
            UniqueElement uniqueElementToDelete = this.getUniqueElementInternal(uniqueElementUID);
            this.uniqueElementCache.deleteUniqueElement(uniqueElementUID);
            String uidDummy = String.valueOf(UniqueElementNormalizer.normalizeValue((String)uniqueElementToDelete.getElementName())) + uniqueElementToDelete.getElementTypeID();
            EOLock lockToSet = new EOLock(UUIDGenerator.getUniqueID(), this.projectAgent.getProjectUID(), "add", uidDummy, "com.arcway.cockpit.uniqueelement", "", "", new Timestamp(System.currentTimeMillis()));
            ArrayList<EOLock> locks = new ArrayList<EOLock>();
            locks.add(lockToSet);
            LockResult lockResult = this.projectAgent.getFrameLockManager().atomicCheckAndSetLocks(locks, locks, false);
            if (lockResult.getConflictingLocks().isEmpty()) {
                return;
            }
            this.uniqueElementModificationMgr.addCreatedUniqueElement(uniqueElementToDelete);
        }
    }

    @Override
    public IUniqueElement getUniqueElementOfOccurrence(IUniqueElementOccurrence occurrence) {
        return this.getUniqueElementOfOccurrence(occurrence.getPlanUID(), occurrence.getPlanElementUID());
    }

    @Override
    public Collection<IUniqueElement> getUniqueElementsOfPlan(IPlan plan) {
        return this.getUniqueElementsOfPlan(plan.getUID());
    }

    @Override
    public IFrameProjectAgent getFrameProjectAgent() {
        return this.projectAgent;
    }

    @Override
    public IUniqueElementOccurrence getUniqueElementOccurence(IPlanElement planElement) {
        return this.getUniqueElementOccurrence1(planElement.getPlanUID(), planElement.getPlanElementUID());
    }

    @Override
    public IUniqueElement getUniqueElementOfOccurrence(IPlanElement planElement) {
        return this.getUniqueElementOfOccurrence(planElement.getPlanUID(), planElement.getPlanElementUID());
    }

    @Override
    public boolean isAssignedToUniqueElement(IPlanElement planElement) {
        return this.isAssignedToUniqueElement(planElement.getPlanUID(), planElement.getPlanElementUID());
    }

    public UniqueElementLinkedDataAccessFacade getUniqueElementLinkedDataAccessProvider() {
        return this.linkableObjectProvider;
    }

    protected IUniqueElementRelationshipManager getRelationshipManager() {
        return this.projectAgent.getUniqueElementRelationshipManager();
    }

    @Override
    public IUniqueElementExportDataProvider getExportDataProvider() {
        return this.exportDataProvider;
    }

    @Override
    public Collection<IUniqueElement> getContainedUniqueElements(String parentElementUID) {
        return this.getRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider().getAllNextUniqueElements(parentElementUID);
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
    }

    @Override
    public String getLocalizedManagerName() {
        return Messages.getString("UniqueElementMgr.ue_manager");
    }

    @Override
    public void discardLocalModifications() {
        this.uniqueElementModificationMgr = new UniqueElementModificationMgr();
        this.saveUniqueElementModifications();
        this.uniqueElementOccurrenceModificationMgr.cleanUp();
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return "com.arcway.cockpit.uniqueelement".equals(cockpitDataTypeID);
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        return this.uniqueElementCache.getUniqueElement(cockpitDataUID) != null;
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        return this.getUniqueElement(cockpitDataUID);
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        if (this.labelProvider == null) {
            final DecoratingLabelProvider baseLP = new DecoratingLabelProvider((ILabelProvider)new ProjectTreeContentProvider(null));
            baseLP.addLabelDecorator((ILabelDecorator)new UniqueElementLabelDecorator());
            this.labelProvider = new IDataLabelProvider(){

                public Image getImageOfType(String dataTypeID) {
                    return baseLP.getImage((Object)UniqueElementMgr.this);
                }

                public String getTypeDisplayName(String dataTypeID) {
                    return baseLP.getText((Object)UniqueElementMgr.this);
                }

                public Image getImage(Object element) {
                    return baseLP.getImage(element);
                }

                public String getText(Object element) {
                    return baseLP.getText(element);
                }

                public void addListener(ILabelProviderListener listener) {
                    baseLP.addListener(listener);
                }

                public void dispose() {
                    baseLP.dispose();
                }

                public boolean isLabelProperty(Object element, String property) {
                    return baseLP.isLabelProperty(element, property);
                }

                public void removeListener(ILabelProviderListener listener) {
                    baseLP.removeListener(listener);
                }
            };
        }
        return this.labelProvider;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        if (this.hasLocalModifications()) {
            ILocalModificationContainer[] items = new ILocalModificationContainer[]{new ILocalModificationContainer(){

                public IDataLabelProvider getDataLabelProvider() {
                    return UniqueElementMgr.this.getDataLabelProvider();
                }

                public Image getGeneralImage() {
                    return this.getDataLabelProvider().getImageOfType("com.arcway.cockpit.uniqueelement");
                }

                public String getGeneralDescription() {
                    return Messages.getString("UniqueElementMgr.unique_elements");
                }

                public boolean isEmpty() {
                    return !UniqueElementMgr.this.uniqueElementModificationMgr.isModified();
                }

                public IAddedItem[] getAddedItems() {
                    Collection<UniqueElement> added = UniqueElementMgr.this.uniqueElementModificationMgr.getCreatedElements();
                    if (!added.isEmpty()) {
                        IAddedItem[] addedItems = new IAddedItem[added.size()];
                        int nr = 0;
                        for (ICockpitProjectData iCockpitProjectData : added) {
                            addedItems[nr++] = new AddedItem((Object)iCockpitProjectData);
                        }
                        return addedItems;
                    }
                    return null;
                }

                public IModifiedItem[] getModifiedItems() {
                    Collection<UniqueElement> mod = UniqueElementMgr.this.uniqueElementModificationMgr.getModifiedElements();
                    if (!mod.isEmpty()) {
                        IModifiedItem[] modifiedItems = new IModifiedItem[mod.size()];
                        int nr = 0;
                        for (ICockpitProjectData iCockpitProjectData : mod) {
                            modifiedItems[nr++] = new ModifiedItem((Object)iCockpitProjectData);
                        }
                        return modifiedItems;
                    }
                    return null;
                }

                public IDeletedItem[] getDeletedItems() {
                    Collection<UniqueElement> del = UniqueElementMgr.this.uniqueElementModificationMgr.getDeletedElements();
                    if (!del.isEmpty()) {
                        IDeletedItem[] deletedItems = new IDeletedItem[del.size()];
                        int nr = 0;
                        for (ICockpitProjectData iCockpitProjectData : del) {
                            deletedItems[nr++] = new DeletedItem((Object)iCockpitProjectData);
                        }
                        return deletedItems;
                    }
                    return null;
                }

                public String getTypeIDOfContainedData() {
                    return "com.arcway.cockpit.uniqueelement";
                }
            }};
            return items;
        }
        return null;
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> dataTypeClazz) {
        return this.projectAgent.getAllAttributesOfType(this.getUniqueElements(), dataTypeClazz);
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        IAttributeTypesProvider typesProvider = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.uniqueelement");
        ArrayList<IAttributeType> allTypes = new ArrayList<IAttributeType>();
        for (IAttributeType type : typesProvider.getAttributeTypes()) {
            if (!dataTypeClass.isAssignableFrom(type.getDataType().getClass())) continue;
            allTypes.add(type);
        }
        return allTypes;
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        return this.getUniqueElements();
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
        IAttributeOwnerRW.Visitor.visitAllAttributeOwnerRWs(this.getData(), visitor);
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        assert (child instanceof IUniqueElement);
        return this.projectAgent.getProjectMetaDataManager().getProject();
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        assert (parent instanceof IUniqueElement);
        return Collections.emptyList();
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem("Functionality is not implemented.", "Can not add data."));
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new EXNoPermission("Permission was not requested!");
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        return dataTypeID.equals("frame.project");
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem("Unique elements can not be moved.", "Can not move unique element."));
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new EXNoPermission("Unique elements can not be moved.");
    }

    @Override
    public void dataModified(IAttributeOwner modifiedData) {
        if (modifiedData instanceof UniqueElement) {
            ArrayList<String> planElementUIDs;
            String planUID;
            UniqueElement modifiedUniqueElement = (UniqueElement)modifiedData;
            if (this.uniqueElementModificationMgr.containsCreatedUniqueElement(modifiedUniqueElement.getUID())) {
                this.uniqueElementModificationMgr.addCreatedUniqueElement(modifiedUniqueElement);
            } else {
                this.uniqueElementModificationMgr.addModifiedUniqueElement(modifiedUniqueElement);
            }
            OccurrenceList occurrences = this.getUniqueElementOccurrences(modifiedUniqueElement.getUID());
            HashMap<String, ArrayList<String>> planUIDs_2_planElementUIDs = new HashMap<String, ArrayList<String>>();
            for (IUniqueElementOccurrence iUniqueElementOccurrence : occurrences) {
                planUID = iUniqueElementOccurrence.getPlanUID();
                planElementUIDs = (ArrayList<String>)planUIDs_2_planElementUIDs.get(planUID);
                if (planElementUIDs == null) {
                    planElementUIDs = new ArrayList<String>();
                    planUIDs_2_planElementUIDs.put(planUID, planElementUIDs);
                }
                planElementUIDs.add(iUniqueElementOccurrence.getPlanElementUID());
                this.planEditorManager.updatePlanElementTooltip(iUniqueElementOccurrence.getPlanUID(), iUniqueElementOccurrence.getPlanElementUID(), modifiedUniqueElement.getElementName(), modifiedUniqueElement.getDescription());
            }
            for (Map.Entry entry : planUIDs_2_planElementUIDs.entrySet()) {
                planUID = (String)entry.getKey();
                planElementUIDs = (Collection)entry.getValue();
                this.planAgentManager.uniqueElementsChanged(planUID, planElementUIDs);
            }
            PropertyChanges changes = new PropertyChanges(null, (Object)modifiedUniqueElement, null);
            this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IUniqueElement.class);
            this.saveUniqueElementModifications();
        } else assert (false);
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        return null;
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        return this.uniqueElementModificationMgr.containsModifiedUniqueElement(dataUID);
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        return this.uniqueElementModificationMgr.containsCreatedUniqueElement(dataUID);
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        return null;
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        return null;
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        return null;
    }

    @Override
    public IImportedPlan importPlan(ISection section, String planUID, String planTypeID, String planName, String planDescription, ObjectTypeCategoryID categoryID, Collection<IAttribute> planAttributes, File tempFile, boolean planFileAlreadyStored, IProgressDisplay progressDisplay) throws PlanAgentManager.EXPlanAgentLaunchException, EXWriteAccessDeniedException, EXSetupPlanException, EXModificationProblem {
        return new ImportedPlan(section, planUID, planTypeID, planName, planDescription, categoryID, planAttributes, tempFile, planFileAlreadyStored, progressDisplay);
    }

    @Override
    public IImportedPlan openPlan(IPlan plan, IProgressDisplay progressDisplay) throws PlanAgentManager.EXPlanAgentLaunchException, EXWriteAccessDeniedException, EXModificationProblem {
        return new ImportedPlan(plan, progressDisplay);
    }

    @Override
    public void openPlanForUniqueElement(IUniqueElement modelElement, IPlan exception, IWorkbenchPage page) {
        String message;
        IPlan plan;
        Iterator<Object> i;
        Collection<? extends IPlan> refiningPlans = this.projectAgent.getUniqueElementRelationshipManager().getRefiningPlans(modelElement);
        Collection<IPlan> plans = new ArrayList<IPlan>(refiningPlans);
        boolean exceptionShowsRefinement = false;
        if (exception != null) {
            i = plans.iterator();
            while (i.hasNext()) {
                plan = (IPlan)i.next();
                if (!exception.getUID().equals(plan.getUID())) continue;
                i.remove();
                exceptionShowsRefinement = true;
            }
        }
        if (plans.isEmpty()) {
            plans = this.getPlansOfUniqueElement(modelElement);
            if (exception != null) {
                i = plans.iterator();
                while (i.hasNext()) {
                    plan = (IPlan)i.next();
                    if (!exception.getUID().equals(plan.getUID())) continue;
                    i.remove();
                }
            }
            if (plans.isEmpty()) {
                if (exception != null) {
                    MessageDialog.openInformation((Shell)page.getWorkbenchWindow().getShell(), (String)Messages.getString("UniqueElementMgr.open_refining_plans"), (String)Messages.getString("UniqueElementMgr.could_not_open_other"));
                } else {
                    MessageDialog.openInformation((Shell)page.getWorkbenchWindow().getShell(), (String)Messages.getString("UniqueElementMgr.open_refining_plans"), (String)Messages.getString("UniqueElementMgr.could_not_open"));
                }
            } else {
                message = exceptionShowsRefinement ? Messages.getString("UniqueElementMgr.choose_other_plan") : Messages.getString("UniqueElementMgr.choose_plan");
                this.projectAgent.getPlanEditorManager().choosePlanToOpen(plans, refiningPlans, modelElement, page, message);
            }
        } else {
            if (plans.size() > 1) {
                plans = this.getPlansOfUniqueElement(modelElement);
                if (exception != null) {
                    i = plans.iterator();
                    while (i.hasNext()) {
                        plan = (IPlan)i.next();
                        if (!exception.getUID().equals(plan.getUID())) continue;
                        i.remove();
                    }
                }
            }
            message = Messages.getString("UniqueElementMgr.choose_refined_plan");
            this.projectAgent.getPlanEditorManager().choosePlanToOpen(plans, refiningPlans, modelElement, page, message);
        }
    }

    private class ImportedPlan
    implements IImportedPlan {
        private final IPlan plan;
        private final Collection<? extends IPlanAgentStructuredPlanElement> planStructure;

        protected ImportedPlan(ISection section, String planUID, String planTypeID, String planName, String planDescription, ObjectTypeCategoryID categoryID, Collection<IAttribute> attributes, File tempFile, boolean planFileAlreadyStored, IProgressDisplay progressDisplay) throws PlanAgentManager.EXPlanAgentLaunchException, EXWriteAccessDeniedException, EXSetupPlanException, EXModificationProblem {
            IPlanAddID addID;
            assert (section != null);
            assert (planTypeID != null);
            assert (planName != null);
            IFrameSectionManager sectionManager = UniqueElementMgr.this.projectAgent.getFrameSectionManager();
            HashMap<IAttributeTypeID, IAttribute> attributesWithDescription = new HashMap<IAttributeTypeID, IAttribute>(2 * (attributes.size() + 1));
            for (IAttribute attribute : attributes) {
                attributesWithDescription.put(attribute.getAttributeTypeID(), attribute);
            }
            if (planDescription != null) {
                Attribute descriptionAttribute = new Attribute(PlanAttributeTypeProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(planDescription, null, null));
                attributesWithDescription.put(PlanAttributeTypeProvider.ATTRID_DESCRIPTION, descriptionAttribute);
            }
            if (!(addID = planUID == null ? sectionManager.requestPlanAdditionPermission(planName, planTypeID, section, categoryID, attributesWithDescription.values()) : sectionManager.requestPlanAdditionPermission(planUID, planName, planTypeID, section, categoryID, attributesWithDescription.values())).permissionGranted()) {
                throw new EXModificationProblem(Collections.singleton(addID.getModificationProblem()));
            }
            IExternalPlanImporterExporterControllerExtension importer = UniqueElementMgr.this.projectAgent.getPlanImporterExporterManager().getImporter(addID, section, planFileAlreadyStored, progressDisplay);
            importer.importPlan(tempFile, progressDisplay);
            this.plan = importer.getPlan();
            this.planStructure = importer.getPlanStructure();
            importer.close();
        }

        public ImportedPlan(IPlan plan, IProgressDisplay progressDisplay) throws PlanAgentManager.EXPlanAgentLaunchException, EXWriteAccessDeniedException, EXModificationProblem {
            assert (plan != null);
            this.plan = plan;
            IFrameSectionManager sectionManager = UniqueElementMgr.this.projectAgent.getFrameSectionManager();
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(UniqueElementMgr.this.projectAgent);
            sectionManager.requestPlanEditPermission(plan, transactionController);
            Collection<IModificationProblem> modificationProblems = transactionController.execute();
            if (!modificationProblems.isEmpty()) {
                throw new EXModificationProblem(modificationProblems);
            }
            IExternalPlanImporterExporterControllerExtension importer = UniqueElementMgr.this.projectAgent.getPlanImporterExporterManager().getModifier(plan, progressDisplay);
            this.planStructure = importer.getPlanStructure();
            importer.close();
        }

        @Override
        public IPlan getPlan() {
            return this.plan;
        }

        @Override
        public IUniqueElement createUniqueElement(IPlanAgentPlanElement planElement) throws EXModificationProblem {
            IUniqueElement uniqueElement;
            IConstructionElementTypeDescription ct = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(planElement.getPlanElementTypeID());
            String elementTypeID = ct.getConstructionElementTypeID();
            IUniqueElementAddID addID = UniqueElementMgr.this.requestUniqueElementCreationPermission(planElement.getPlanElementName(), elementTypeID, null, Collections.emptyList());
            if (addID.permissionGranted()) {
                try {
                    uniqueElement = UniqueElementMgr.this.createUniqueElement(addID);
                }
                catch (EXNoPermission e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new EXModificationProblem(Collections.singleton(addID.getModificationProblem()));
            }
            return uniqueElement;
        }

        @Override
        public void createUniqueElementOccurences(Map<? extends IPlanAgentPlanElement, ? extends IUniqueElement> planElements2uniqueElement) throws EXModificationProblem {
            HashMap<String, String> planElementUIDs2uniqueElementUID = new HashMap<String, String>(2 * planElements2uniqueElement.size());
            for (Map.Entry<? extends IPlanAgentPlanElement, ? extends IUniqueElement> planElement2uniqueElement : planElements2uniqueElement.entrySet()) {
                planElementUIDs2uniqueElementUID.put(planElement2uniqueElement.getKey().getPlanElementUID(), planElement2uniqueElement.getValue().getUID());
            }
            this.modifyUniqueElementOccurencesByUIDs(Collections.emptyList(), planElementUIDs2uniqueElementUID);
        }

        @Override
        public void modifyUniqueElementOccurencesByUIDs(Collection<String> planElementUIDsOfOccurencesToDelete, Map<String, String> planElementUIDs2uniqueElementUIDOfOccurencesToCreate) throws EXModificationProblem {
            UniqueElementMgr.this.deleteUniqueElementOccurencesUnsaved(this.plan.getUID(), this.planStructure, planElementUIDsOfOccurencesToDelete);
            UniqueElementMgr.this.createUniqueElementOccurencesUnsaved(this.plan.getUID(), this.planStructure, planElementUIDs2uniqueElementUIDOfOccurencesToCreate);
            UniqueElementMgr.this.saveUniqueElementOccurrenceAndRelationshipModifications(this.plan.getUID());
        }

        @Override
        public Collection<? extends IPlanAgentStructuredPlanElement> getPlanStructure() {
            return this.planStructure;
        }

        @Override
        public IUniqueElement searchUniqueElement(IPlanAgentPlanElement planElement) {
            IConstructionElementTypeDescription ct = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(planElement.getPlanElementTypeID());
            String type = ct.getConstructionElementTypeID();
            IUniqueElement ue = UniqueElementMgr.this.getUniqueElement(planElement.getPlanElementName(), type);
            return ue;
        }
    }
}

