/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.permissions;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameStakeholderManager;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.client.project.modules.IPermissionChecker;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProjectPermissionChecker
implements IPermissionChecker {
    private static final ILogger logger = Logger.getLogger(ProjectPermissionChecker.class);
    private ProjectAgent projectAgent;

    public void construct(ProjectAgent pa) {
        assert (pa != null) : "projectAgent is missing";
        this.projectAgent = pa;
    }

    @Override
    public boolean hasPermission(String operation, String operation2, IPermissionOperand operand) {
        return this.hasPermission(operation, operation2, operand, false);
    }

    public boolean hasPermission(String operation, String operation2, IPermissionOperand operand, boolean forceLogin) {
        CurrentUserInfo currentUserInfo = new CurrentUserInfo(this, forceLogin);
        return this.hasPermission_adv(operation, operation2, operand, currentUserInfo);
    }

    @Override
    public boolean hasPermission_adv(String operation, String operation2, IPermissionOperand operand, CurrentUserInfo currentUserInfo) {
        String operandUID;
        String projectUID;
        ArrayList permissions;
        assert (operation != null);
        assert (operand != null);
        assert (currentUserInfo.projectPermissionChecker == this);
        if (!currentUserInfo.arePermissionsNeeded() || currentUserInfo.isAdmin()) {
            return true;
        }
        EOUserAndGroupAndPermissions user = currentUserInfo.getUserData();
        if (user != null && (permissions = user.getAllPermissionsOfSubsetForOperand(projectUID = this.projectAgent.getProjectUID(), operandUID = operand.getPermissionOperandUID())) != null) {
            for (EOPermission permission : permissions) {
                assert (StringUtil.equals((String)projectUID, (String)permission.getSubSetUID()) && StringUtil.equals((String)operandUID, (String)permission.getOperandUID()));
                if (!StringUtil.equals((String)operation, (String)permission.getOperation()) || !StringUtil.equals((String)operation2, (String)permission.getOperation2()) || permission.getOwnerType() == 2 && !currentUserInfo.isOfUsersRole(permission) || !StringUtil.equals((String)operand.getPermissionOperandType(), (String)permission.getOperandType()) || !StringUtil.equals((String)"PROJECT", (String)permission.getSubSetType()) || !StringUtil.equals((String)operandUID, (String)permission.getOperandUID()) || !StringUtil.equals((String)projectUID, (String)permission.getSubSetUID())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasPermission(CockpitPermissionTemplate template, IPermissionOperand permissionOperand) {
        CurrentUserInfo currentUserInfo = new CurrentUserInfo(this);
        return this.hasPermission_adv(template, permissionOperand, currentUserInfo);
    }

    private boolean hasPermission_adv(CockpitPermissionTemplate template, IPermissionOperand permissionOperand, CurrentUserInfo currentUserInfo) {
        assert (currentUserInfo.projectPermissionChecker == this);
        return this.hasPermission_adv(template.getOperation(), template.getOperation2(), permissionOperand, currentUserInfo);
    }

    @Override
    public boolean isAdmin() {
        try {
            return this.isAdmin_adv(new CurrentUserInfo(this, true));
        }
        catch (Throwable ta) {
            logger.error("could not get user data", ta);
            return false;
        }
    }

    public boolean isAdmin_adv(CurrentUserInfo currentUserInfo) {
        return currentUserInfo.isAdmin();
    }

    public static ImageDescriptor getForbiddenIcon() {
        return FramePlugin.getImageDescriptor("forbidden.gif");
    }

    @Override
    public boolean hasAttributeModificationPermission(IAttributeType attributeType, IParentOperandTree operandTree, boolean forCreation) {
        if (!forCreation && attributeType.restrictedAccess() || forCreation && attributeType.restrictedAccessOnCreation()) {
            IPermissionOperand permissionOperand = operandTree.getBaseOperand();
            if (permissionOperand == null) {
                return true;
            }
            CurrentUserInfo currentUserInfo = new CurrentUserInfo(this);
            while (permissionOperand != null) {
                ICockpitDataType cockpitDataType = attributeType.getCockpitDataType();
                AllAttributeModificationPermissionTemplate allAttributePermissionTemplate = AllAttributeModificationPermissionTemplate.getAllAttrTemplate(cockpitDataType.getCockpitDataTypeID(), cockpitDataType.getDisplayName(), permissionOperand.getPermissionOperandType());
                if (this.hasPermission_adv(allAttributePermissionTemplate, permissionOperand, currentUserInfo)) {
                    return true;
                }
                AttributeModificationPermissionTemplate template = this.projectAgent.getFrameUserDefinedAttributeTypesManager().getPermissionsTemplate(attributeType, permissionOperand.getPermissionOperandType());
                if (this.hasPermission_adv(template, permissionOperand, currentUserInfo)) {
                    return true;
                }
                permissionOperand = operandTree.getParent(permissionOperand);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAttributeModificationPermission(String attributeTypeID, IParentOperandTree operandTree, IModuleDataTypeDescriptionForFrame moduleDataType) {
        IPermissionOperand permissionOperand = operandTree.getBaseOperand();
        if (permissionOperand == null) {
            return true;
        }
        CurrentUserInfo currentUserInfo = new CurrentUserInfo(this);
        while (permissionOperand != null) {
            AllAttributeModificationPermissionTemplate allAttributePermissionTemplate = AllAttributeModificationPermissionTemplate.getAllAttrTemplate(moduleDataType.getCockpitDataTypeID(), moduleDataType.getDisplayName(), permissionOperand.getPermissionOperandType());
            if (this.hasPermission_adv(allAttributePermissionTemplate, permissionOperand, currentUserInfo)) {
                return true;
            }
            AttributeModificationPermissionTemplate template = this.projectAgent.getFrameUserDefinedAttributeTypesManager().getPermissionsTemplate(attributeTypeID, moduleDataType, permissionOperand.getPermissionOperandType());
            if (this.hasPermission_adv(template, permissionOperand, currentUserInfo)) {
                return true;
            }
            permissionOperand = operandTree.getParent(permissionOperand);
        }
        return false;
    }

    @Override
    public boolean hasPermission(String operation, String operation2, IParentOperandTree operandTree) {
        CurrentUserInfo currentUserInfo = new CurrentUserInfo(this);
        IPermissionOperand permissionOperand = operandTree.getBaseOperand();
        while (permissionOperand != null) {
            if (this.hasPermission_adv(operation, operation2, permissionOperand, currentUserInfo)) {
                return true;
            }
            permissionOperand = operandTree.getParent(permissionOperand);
        }
        return false;
    }

    @Override
    public CurrentUserInfo getCurrentUserInfoForComplexPermissionCheck() {
        return new CurrentUserInfo(this);
    }

    public static class CurrentUserInfo {
        private final ProjectPermissionChecker projectPermissionChecker;
        private Boolean arePermissionsNeeded = null;
        private final EOUserAndGroupAndPermissions userData;
        private Boolean isAdmin = null;
        private Set<String> roleUIDsOfStakeholderOfCurrentUser = null;

        private CurrentUserInfo(ProjectPermissionChecker projectPermissionChecker) {
            this(projectPermissionChecker, false);
        }

        private CurrentUserInfo(ProjectPermissionChecker projectPermissionChecker, boolean forceLogin) {
            this.projectPermissionChecker = projectPermissionChecker;
            this.userData = projectPermissionChecker.projectAgent.getUserData(forceLogin);
        }

        private boolean arePermissionsNeeded() {
            if (this.arePermissionsNeeded == null) {
                this.arePermissionsNeeded = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.projectPermissionChecker.projectAgent.getServerID()).arePermissionsNeeded();
            }
            return this.arePermissionsNeeded;
        }

        private EOUserAndGroupAndPermissions getUserData() {
            return this.userData;
        }

        private boolean isAdmin() {
            if (this.isAdmin == null) {
                this.isAdmin = this.isAdmin_int();
            }
            return this.isAdmin;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isAdmin_int() {
            try {
                EOGroup group;
                if ("Administrator".equals(this.userData.getUser().getPermissionOwnerID())) {
                    return true;
                }
                Iterator iterator = this.userData.getGroups().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while (!"Administrators".equals((group = (EOGroup)iterator.next()).getPermissionOwnerID()));
                return true;
            }
            catch (Throwable ta) {
                logger.error("could not get user data", ta);
            }
            return false;
        }

        private boolean isOfUsersRole(EOPermission permission) {
            if (this.userData != null) {
                return this.getRoleUIDsOfStakeholderOfCurrentUser().contains(permission.getOwnerID());
            }
            assert (false);
            return false;
        }

        private Set<String> getRoleUIDsOfStakeholderOfCurrentUser() {
            if (this.roleUIDsOfStakeholderOfCurrentUser == null) {
                IFrameStakeholderManager stakeholderManager = this.projectPermissionChecker.projectAgent.getFrameStakeholderManager();
                IStakeholder stakeholderForCurrentUser = null;
                if (stakeholderManager != null) {
                    stakeholderForCurrentUser = stakeholderManager.getStakeholderForCurrentUser();
                }
                this.roleUIDsOfStakeholderOfCurrentUser = this.getRoleUIDsOfStakeholder(stakeholderForCurrentUser);
            }
            return this.roleUIDsOfStakeholderOfCurrentUser;
        }

        private Set<String> getRoleUIDsOfStakeholder(IStakeholder stakeholder) {
            Set<String> roleUIDs;
            if (stakeholder != null) {
                Collection roles = this.projectPermissionChecker.projectAgent.getStakeholderManager().getRolesOfStakeholder(stakeholder);
                if (roles.isEmpty()) {
                    roleUIDs = Collections.emptySet();
                } else {
                    roleUIDs = new HashSet<String>(2 * roles.size());
                    for (IStakeholderRole role : roles) {
                        roleUIDs.add(role.getUID());
                    }
                }
            } else {
                roleUIDs = Collections.emptySet();
            }
            return roleUIDs;
        }
    }
}

