/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementList;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ListEntryParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.lib.eclipse.file.UrlLauncher;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DataTypeURL
extends AbstractDataType {
    public static final String EMPTY_URL_STRING = "";
    public static final String DATATYPE_ID = "url";
    private static final DataTypeURL INSTANCE = new DataTypeURL();
    private static final HashSet<String> COCKPIT_KNOWN_URL_PROTOCOLS = new HashSet();

    static {
        COCKPIT_KNOWN_URL_PROTOCOLS.add("data");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("dav");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("file");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("ftp");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("http");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("https");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("imap");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("ipp");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("ldap");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("mailto");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("news");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("nfs");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("nntp");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("pop");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("shttp");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("snmp");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("telnet");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("tftp");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("urn");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("xmpp");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("aim");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("apt");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("cvs");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("finger");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("irc");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("ircs");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("irc6");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("jar");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("ldaps");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("mms");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("msnim");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("notes");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("rsync");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("rtmp");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("skype");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("ssh");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("sftp");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("smb");
        COCKPIT_KNOWN_URL_PROTOCOLS.add("svn");
    }

    public static DataTypeURL getSingleInstance() {
        return INSTANCE;
    }

    public String getID() {
        return DATATYPE_ID;
    }

    public boolean supportsValue(Object value, IValueRange valueRange) {
        return value instanceof String;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return "URL";
    }

    public String getValueAsSingleLineString(Object value, IValueRange valueRange, String separator, Locale locale) {
        return (String)value;
    }

    @Override
    public Comparator<Object> getComparator(IValueRange valueRange) {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (!$assertionsDisabled && o1 != null && !(o1 instanceof String)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && o2 != null && !(o2 instanceof String)) {
                    throw new AssertionError();
                }
                if (o1 instanceof String && o2 instanceof String) {
                    return ((String)o1).compareToIgnoreCase((String)o2);
                }
                if (o1 instanceof String && o2 == null) {
                    return -1;
                }
                if (o1 == null && o2 instanceof String) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public EOEncodableObject getValueAsEO(Object value, IValueRange baseValueRange) {
        String url = (String)value;
        return new EOString(url);
    }

    public Object getEOAsValue(EOEncodableObject eo) {
        EOString eoString = (EOString)eo;
        return eoString.getString();
    }

    @Override
    protected AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(Composite parent, Object initialValue, IValueRange valueRange) {
        final Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setText((String)initialValue);
        final AbstractDataType.SWTControlForModification wrapper = new AbstractDataType.SWTControlForModification(this, (Control)text, null);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataTypeURL.this.informSWTModifyListeners(wrapper, text.getText(), null);
            }
        });
        return wrapper;
    }

    public Object getDefaultValue() {
        return EMPTY_URL_STRING;
    }

    public Object getCopy(Object originalValue, IValueRange valueRange) {
        return originalValue;
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        return valueAsString;
    }

    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) {
        String link = (String)value;
        Hyperlink hyperLink = new Hyperlink(parent, 0);
        hyperLink.setBackground(parent.getBackground());
        hyperLink.setFont(parent.getFont());
        hyperLink.setForeground(Display.getDefault().getSystemColor(9));
        hyperLink.setText(link);
        hyperLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        Menu contextMenu = menuManager.createContextMenu((Control)hyperLink);
        hyperLink.setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
            }
        });
        return hyperLink;
    }

    private Runnable getLinkSelectionRunnable(final String link, final IWorkbenchPage workbenchPage) {
        return new Runnable(){

            @Override
            public void run() {
                DataTypeURL.this.openLink(link, workbenchPage);
            }
        };
    }

    private List<ContributionItem> getContextMenuActions(String link, IWorkbenchPage workbenchPage) {
        ArrayList<ContributionItem> contributionItems = new ArrayList<ContributionItem>(3);
        contributionItems.add((ContributionItem)new ActionContributionItem((IAction)new OpenLinkAction(link, workbenchPage)));
        contributionItems.add((ContributionItem)new Separator());
        contributionItems.add((ContributionItem)new ActionContributionItem((IAction)new CopyLinkAction(link)));
        return contributionItems;
    }

    @Override
    public DetailsElement getDetailsElement(IAttributeType attributeType, Object attributeValue, Locale locale, Shell shell, IWorkbenchPage workbenchPage) {
        DetailsValueList detailsValue = new DetailsValueList();
        String urlString = this.getValueAsSingleLineString(attributeValue, null, EMPTY_URL_STRING, locale);
        ListEntryParameter parameter = null;
        if (urlString != null && urlString.length() > 0) {
            parameter = new ListEntryParameter(this.getLinkSelectionRunnable(urlString, workbenchPage), this.getContextMenuActions(urlString, workbenchPage), null);
        }
        detailsValue.addListElement(urlString, null, parameter);
        return new DetailsElementList(String.valueOf(attributeType.getCockpitDataTypeID()) + "-" + attributeType.getHumanReadableID(), attributeType.getDisplayName(), detailsValue);
    }

    private void openLink(String p_link, IWorkbenchPage workbenchPage) {
        String wannabeProtocol;
        String HTTP_PFX = "http://";
        int colIndex = p_link.indexOf(58);
        String link = colIndex == -1 ? "http://" + p_link : (COCKPIT_KNOWN_URL_PROTOCOLS.contains(wannabeProtocol = p_link.substring(0, colIndex)) ? p_link : (p_link.indexOf("://") == -1 ? "http://" + p_link : p_link));
        UrlLauncher.launchUrl_noEx((String)link, (IWorkbenchPage)workbenchPage);
    }

    public IValueRangeDefiner getValueRangeHelper() {
        return null;
    }

    private static class CopyLinkAction
    extends Action {
        private final String link;

        public CopyLinkAction(String link) {
            this.link = link;
            this.setText(Messages.getString("DataTypeURL.copy_link"));
        }

        public void run() {
            Clipboard clipboard = new Clipboard(Display.getDefault());
            try {
                clipboard.setContents(new Object[]{this.link}, new Transfer[]{TextTransfer.getInstance()});
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    private class OpenLinkAction
    extends Action {
        private final String link;
        private final IWorkbenchPage workbenchPage;

        public OpenLinkAction(String link, IWorkbenchPage workbenchPage) {
            this.link = link;
            this.workbenchPage = workbenchPage;
            this.setText(Messages.getString("DataTypeURL.open_link"));
        }

        public void run() {
            DataTypeURL.this.openLink(this.link, this.workbenchPage);
        }
    }
}

