/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datamanager;

import com.arcway.cockpit.interFace.IVersionedCockpitProjectData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FrameHistoryDataCache<T extends IVersionedCockpitProjectData> {
    private final Map<String, T> containedData = new HashMap<String, T>();
    private final Map<String, Integer> modCountUpToWhichAllVersionsAreCached = new HashMap<String, Integer>();

    public FrameHistoryDataCache() {
    }

    public FrameHistoryDataCache(Collection<? extends T> dataItems) {
        this.putDataItems(dataItems);
    }

    public void putDataItem(T dataItem) {
        this.containedData.put(this.getHistoricItemKey(dataItem.getUID(), dataItem.getModificationCount()), dataItem);
        this.updateModCountUpToWhichAllVersionsAreCached(dataItem.getUID(), dataItem.getModificationCount());
    }

    public void putDataItems(Collection<? extends T> dataItems) {
        for (IVersionedCockpitProjectData dataItem : dataItems) {
            this.putDataItem(dataItem);
        }
    }

    public Collection<? extends T> getAllDataItems() {
        return this.containedData.values();
    }

    public T getData(String uID, int modCount) {
        return (T)((IVersionedCockpitProjectData)this.containedData.get(this.getHistoricItemKey(uID, modCount)));
    }

    public int getModCountUpToWhichAllVersionsAreCached(String uid) {
        Integer modCount = this.modCountUpToWhichAllVersionsAreCached.get(uid);
        if (modCount != null) {
            return modCount;
        }
        return 0;
    }

    private String getHistoricItemKey(String uid, int modCount) {
        return String.valueOf(uid) + "\n" + Integer.toString(modCount);
    }

    private void updateModCountUpToWhichAllVersionsAreCached(String uid, int newModCount) {
        Integer modCountUpToWhichAllVersionsAreCached_ = this.modCountUpToWhichAllVersionsAreCached.get(uid);
        if (modCountUpToWhichAllVersionsAreCached_ == null && newModCount == 1 || modCountUpToWhichAllVersionsAreCached_ != null && modCountUpToWhichAllVersionsAreCached_ == newModCount - 1) {
            int newModCountUpToWhichAllVersionsAreCached = newModCount;
            while (this.getData(uid, newModCountUpToWhichAllVersionsAreCached + 1) != null) {
                ++newModCountUpToWhichAllVersionsAreCached;
            }
            this.modCountUpToWhichAllVersionsAreCached.put(uid, newModCountUpToWhichAllVersionsAreCached);
        }
    }
}

