/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Date;

public class FrameDataHelper {
    private static final ILogger logger = Logger.getLogger(FrameDataHelper.class);

    public static String getCreator(IFrameData frameData) {
        try {
            return (String)frameData.getAttribute(AbstractAttributeTypesProvider.ATTRID_CREATOR).getAttributeValue();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not get creator", (Throwable)e);
            return null;
        }
    }

    public static Date getCreationDate(IFrameData frameData) {
        try {
            String strDate = (String)frameData.getAttribute(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE).getAttributeValue();
            if (!strDate.equals("")) {
                return new Date(Long.valueOf(strDate));
            }
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not get creation date", (Throwable)e);
        }
        return null;
    }

    public static String getLastEditor(IFrameData frameData) {
        try {
            return (String)frameData.getAttribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR).getAttributeValue();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not get last editor", (Throwable)e);
            return null;
        }
    }

    public static Date getLastEditDate(IFrameData frameData) {
        String strDate = (String)frameData.getAttribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE).getAttributeValue();
        if (!strDate.equals("")) {
            return new Date(Long.valueOf(strDate));
        }
        return null;
    }
}

