/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.project;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.DecoratedImageDescriptor;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.icons.Decorators7x8;
import com.arcway.lib.resource.IStreamResource;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;

public class ProjectViewLabelDecorator
implements ILabelDecorator {
    private final ITreeContentProvider contentProvider;
    private final Map<Image, Image> modifiedDataType_decoratedImage = new HashMap<Image, Image>();
    private final Map<Image, Image> addedDataType_decoratedImage = new HashMap<Image, Image>();

    public ProjectViewLabelDecorator(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public Image decorateImage(Image image, Object element) {
        Image decoratedImage = image;
        if (element instanceof ICockpitProjectData) {
            ICockpitProjectData data = (ICockpitProjectData)element;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(data.getProjectUID());
            if (projectAgent != null && projectAgent.isOpened()) {
                DecoratedImageDescriptor dd;
                if (this.isModified(data, projectAgent) && (decoratedImage = this.modifiedDataType_decoratedImage.get(image)) == null) {
                    dd = new DecoratedImageDescriptor(image);
                    dd.addDecorator(ImageCache.getImageDescriptor((IStreamResource)Decorators7x8.MODIFIED), 3);
                    decoratedImage = dd.createImage();
                    this.modifiedDataType_decoratedImage.put(image, decoratedImage);
                }
                if (this.isAdded(data, projectAgent) && (decoratedImage = this.addedDataType_decoratedImage.get(image)) == null) {
                    dd = new DecoratedImageDescriptor(image);
                    dd.addDecorator(ImageCache.getImageDescriptor((IStreamResource)Decorators7x8.NEW), 3);
                    decoratedImage = dd.createImage();
                    this.addedDataType_decoratedImage.put(image, decoratedImage);
                }
            }
        }
        return decoratedImage;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        for (Image image : this.modifiedDataType_decoratedImage.values()) {
            image.dispose();
        }
        for (Image image : this.addedDataType_decoratedImage.values()) {
            image.dispose();
        }
        this.modifiedDataType_decoratedImage.clear();
        this.addedDataType_decoratedImage.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private boolean isModified(Object object, IFrameProjectAgent projectAgent) {
        ICockpitProjectData data;
        IFrameDataManager dataManager;
        if (object instanceof IFrameProjectAgent && projectAgent.isOpened()) {
            return projectAgent.getCommitMgr().areModificationsPresent();
        }
        if (object instanceof ICockpitProjectData && (dataManager = projectAgent.getDataManager((data = (ICockpitProjectData)object).getTypeID())) != null && dataManager.isLocallyModified(data.getUID())) {
            return true;
        }
        Object[] children = this.contentProvider.getChildren(object);
        if (children != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.isModified(element, projectAgent) || this.isAdded(element, projectAgent)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isAdded(Object object, IFrameProjectAgent projectAgent) {
        ICockpitProjectData data;
        IFrameDataManager dataManager;
        return object instanceof ICockpitProjectData && (dataManager = projectAgent.getDataManager((data = (ICockpitProjectData)object).getTypeID())) != null && dataManager.isLocallyAdded(data.getUID());
    }
}

