/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.filters;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IAttributeFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.filters.ICustomPropertyFiltersModelAccess;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategories;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ClientMessageDataFactory;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IFrameUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import org.eclipse.jface.viewers.Viewer;

public class CustomPropertiesFilter<ContentType>
extends AbstractFilter {
    private static final ILogger logger = Logger.getLogger(CustomPropertiesFilter.class);
    private final IAttributeTypeID attributeTypeID;
    private EOEncodableObject value;
    private final ICustomPropertyFiltersModelAccess<ContentType> modelAccess;
    private final String cockpitTypeID;
    private final IAttributeFilter filter;
    private final Class<ContentType> typeClass;
    private static final XMLDecoder decoder = new XMLDecoder();
    private static final ClientMessageDataFactory messageDataFactory = ClientMessageDataFactory.getInstance();

    public CustomPropertiesFilter(IFrameUserDefinedAttributeTypesManager typesManager, IAttributeTypeID attributeTypeID, String cockpitTypeID, ICustomPropertyFiltersModelAccess<ContentType> modelAccess, Class<ContentType> typeClass) {
        assert (typesManager != null) : "typesManager must not be null";
        assert (attributeTypeID != null) : "attributeTypeID must not be null";
        assert (cockpitTypeID != null) : "dataTypeID must not be null";
        assert (modelAccess != null) : "model must not be null";
        this.attributeTypeID = attributeTypeID;
        this.cockpitTypeID = cockpitTypeID;
        this.modelAccess = modelAccess;
        this.typeClass = typeClass;
        this.filter = typesManager.getUserDefinedAttributeType(attributeTypeID).getDataType().getFilter();
        this.value = this.filter.getStandardFilterValue();
    }

    public String getFilterID() {
        return "customFilter." + this.cockpitTypeID + "." + this.attributeTypeID.getUID();
    }

    protected boolean isValidObjectType(Object element) {
        return this.typeClass.isAssignableFrom(element.getClass()) && this.modelAccess.isAttributeOwner(element) && ((ICockpitProjectData)element).getTypeID().equals(this.cockpitTypeID);
    }

    public boolean doesItemPassFilter(Viewer viewer, Object parentElement, Object element) {
        IAttribute attribute;
        block6: {
            block5: {
                try {
                    IAttributeOwner attributeOwner = this.modelAccess.getAttributeOwner(element);
                    IAttributeType attributeType = attributeOwner.getAttributeType(this.attributeTypeID);
                    if (attributeType == null) break block5;
                    if (ObjectTypeCategories.isUserDefinedAttributeTypeVisibleForItem(attributeOwner, attributeType)) {
                        attribute = attributeOwner.getAttribute(this.attributeTypeID);
                        break block6;
                    }
                    return false;
                }
                catch (ExInvalidAttributeType e) {
                    logger.error((Throwable)e);
                    return false;
                }
            }
            assert (false);
            return false;
        }
        return this.filter.select(this.value, attribute);
    }

    public String getFilterValue() {
        try {
            return this.convertToXMLString(this.value);
        }
        catch (ExInvalidDataType e) {
            logger.error((Throwable)e);
            return null;
        }
        catch (EXEncoderException e) {
            logger.error("Could not set filter Value", (Throwable)e);
            return null;
        }
    }

    private String convertToXMLString(EOEncodableObject value_) throws EXEncoderException {
        return value_.toXMLString(false);
    }

    public void setFilterValue(String valueString) {
        try {
            this.value = this.convertFromXMLString(valueString);
        }
        catch (ExInvalidDataType e) {
            logger.error((Throwable)e);
            this.value = null;
        }
        super.setFilterValue(valueString);
    }

    private EOEncodableObject convertFromXMLString(String valueString) {
        try {
            return (EOEncodableObject)decoder.decodeXML(valueString, (IEncodableObjectFactory)messageDataFactory, true);
        }
        catch (EXDecoderException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public void resetValue() {
        this.value = this.filter.getStandardFilterValue();
    }
}

