/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details.provider;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.views.details.DetailsView;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementList;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.FrameDetailsProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.InfolinkDetailsProviderPlugin;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSeparator;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateRW;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorManager;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputFormat;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;

public class ReportTemplateDetailsProvider2
extends FrameDetailsProvider {
    private final InfolinkDetailsProviderPlugin infolinkDetailsProviderPlugin = new InfolinkDetailsProviderPlugin();

    @Override
    public String getID() {
        return "com.arcway.cockpit.detailsprovider.reporttemplate";
    }

    @Override
    protected void init(IWorkbenchPartSite site_, IMemento memento) {
        super.init(site_, memento);
        this.infolinkDetailsProviderPlugin.setup(site_, false);
    }

    @Override
    protected List<DetailsElement> getTitleDetailsElements(ICockpitProjectData itemToShow) {
        return Collections.singletonList(this.getDetailsElementTitleForAttribute(itemToShow, ReportTemplateAttributeTypesProvider.ATTRID_NAME, this.getTitleImage(itemToShow)));
    }

    @Override
    protected List<DetailsElement> getFixAttributeDetailsElements(ICockpitProjectData itemToShow) {
        IReportTemplateRW reportTemplate = (IReportTemplateRW)itemToShow;
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(reportTemplate.getProjectUID());
        DetailsValueList detailsValueOutputFormats = new DetailsValueList();
        projectAgent.getDocGeneratorManager();
        Collection<IReportType> reportTypes = DocGeneratorManager.getPossibleReportTypes(reportTemplate, false);
        HashSet<String> consideredOutputFormatIDs = new HashSet<String>();
        for (IReportType reportType : reportTypes) {
            String outputFormatID = reportType.getOutputFormat(reportTemplate);
            if (consideredOutputFormatIDs.contains(outputFormatID)) continue;
            projectAgent.getDocGeneratorManager();
            IReportOutputFormat outputFormat = DocGeneratorManager.getReportOutputFormat(outputFormatID);
            detailsValueOutputFormats.addListElement(outputFormat.getDisplayName(), null, null);
            consideredOutputFormatIDs.add(outputFormatID);
        }
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
        detailsElements.add(this.getDetailsElementForAttribute(itemToShow, ReportTemplateAttributeTypesProvider.ATTRID_FILE));
        detailsElements.add(this.getDetailsElementMultiWithoutLabelForAttribute(itemToShow, ReportTemplateAttributeTypesProvider.ATTRID_DESCRIPTION));
        detailsElements.add(new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
        detailsElements.add(new DetailsElementList("outputformats", Messages.getString("ReportTemplateDetailsProvider.OutputFormats.Label"), detailsValueOutputFormats));
        detailsElements.add(new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
        detailsElements.add(this.getDetailsElementForAttribute(itemToShow, ReportTemplateAttributeTypesProvider.ATTRID_FILTER_FRAME));
        detailsElements.add(this.getDetailsElementForAttribute(itemToShow, ReportTemplateAttributeTypesProvider.ATTRID_FILTER_MODULES));
        DetailsView containingDetailsView = this.getContainingDetailsView();
        this.infolinkDetailsProviderPlugin.addInfolinkDetailsElements(itemToShow, containingDetailsView, detailsElements);
        return detailsElements;
    }
}

