/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.validators;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import java.util.Collection;
import org.eclipse.jface.dialogs.IInputValidator;

public class RenameStakeholderRoleValidator
implements IInputValidator {
    private final IFrameProjectAgent projectAgent;
    private String uID;

    public RenameStakeholderRoleValidator(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public void setRole(IStakeholderRole role) {
        this.uID = role == null ? null : role.getUID();
    }

    public String isValid(String newText) {
        if (newText == null || newText.trim().equals("")) {
            return Messages.getString("RenameStakeholderRoleValidator.Please_enter_a_valid_name_for_the_stakeholder_role_!_4");
        }
        if (this.roleExists(newText.trim())) {
            return Messages.getString("RenameStakeholderRoleValidator.There_is_already_a_stakeholder_role_with_this_name._5");
        }
        return null;
    }

    private boolean roleExists(String name) {
        Collection<? extends IStakeholderRole> roles = this.projectAgent.getFrameStakeholderManager().getRoles();
        for (IStakeholderRole iStakeholderRole : roles) {
            if (!iStakeholderRole.getName().equalsIgnoreCase(name) || iStakeholderRole.getUID().equals(this.uID)) continue;
            return true;
        }
        return false;
    }
}

