/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.handlers;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHProjectCommit
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ProjectAgent projectAgent;
        IStructuredSelection sel;
        String projectUID;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell != null && (projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)(sel = CommandHandlerHelper.getRelevantSelection(event)))) != null && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID)) != null && projectAgent.isOpened()) {
            if (!projectAgent.isInMemoryStateConsistent() || projectAgent.getFrameServerProxy().concurrentWorkPossible() && !projectAgent.isDiskStateInSynchWithInMemoryState()) {
                MessageDialog.openError((Shell)shell, (String)Messages.getString("CHCommit.CommitImpossible.InvalidState.Title"), (String)Messages.getString("CHCommit.CommitImpossible.InvalidState.Message"));
                return null;
            }
            try {
                if (projectAgent.isOpened()) {
                    projectAgent.commitProject(null, false, false, shell);
                }
            }
            catch (ServerNotAvailableException e) {
                this.handleException(shell, projectAgent, e);
            }
            catch (EXServerException e) {
                this.handleException(shell, projectAgent, e);
            }
            catch (LoginCanceledException e) {
            }
            catch (UnknownServerException e) {
                this.handleException(shell, projectAgent, e);
            }
            catch (ExPrematureEndOfTransfer e) {
                this.handleException(shell, projectAgent, e);
            }
        }
        return null;
    }

    private void handleException(Shell shell, ProjectAgent projectAgent, Throwable th) {
        Exception userShownEx;
        ProjectAgent selectedProjectAgent = projectAgent;
        String serverID = selectedProjectAgent.getServerID();
        IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
        String descriptionOfConsequence = projectMgrServerProxy.getVersionDependendDescription("commitfailed");
        String genericMessage = Messages.getString("CommitAction.CommitFailed.genericMessage");
        String dialogTitle = projectMgrServerProxy.getVersionDependendDescription("commitlabel");
        Throwable thToHandle = th instanceof ExPrematureEndOfTransfer && th.getCause() != null ? th.getCause() : th;
        if (thToHandle instanceof Exception) {
            userShownEx = (Exception)thToHandle;
        } else {
            userShownEx = new Exception(genericMessage);
            userShownEx.initCause(thToHandle);
        }
        ModificationProblem mProblem = new ModificationProblem(userShownEx, 2, descriptionOfConsequence);
        ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
        mProblems.add(mProblem);
        ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, dialogTitle, shell);
        mpDialog.open();
    }
}

