/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.copypaste;

import com.arcway.cockpit.cockpitlib.client.tempfiles.CockpitTempDirectoryProvider;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.copypaste.ICopyConfiguration;
import com.arcway.cockpit.frame.client.global.gui.copypaste.IPasteConfiguration;
import com.arcway.cockpit.frame.client.global.gui.copypaste.RepositorySnippetClipboardContent;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.frontend.definition.lib.ui.modificationproblems.RepositoryMessageDisplay;
import com.arcway.lib.eclipse.uiframework.editors.EclipseWindow;
import com.arcway.lib.file.tmp.ITempDirectoryProvider;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.ui.window.IShell;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.importexport.ImportExportException;
import com.arcway.repository.interFace.importexport.export.ExportAgent;
import com.arcway.repository.interFace.importexport.imporT.IRepositoryMessageDisplay;
import com.arcway.repository.interFace.importexport.imporT.ImportAgent;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import java.util.List;

public class CopyManager {
    private static final String TEMP_DIRECTORY_FOR_COPIED_CUSTOM_PROPERTY_FILES = "copied_custom_property_files";
    private static final String TEMP_FILE_FOR_COPIED_CUSTOM_PROPERTY_FILES_PREFIX = "file";
    private static final ITempDirectoryProvider tempDirectoryProvider = CockpitTempDirectoryProvider.createInstance((String)"copied_custom_property_files", (String)"file");

    public static final synchronized IRepositorySnippetRO getCopy(List<IRepositoryObjectReference> rootObjects, IRepositoryInterfaceRO repositoryInterface, ICopyConfiguration copyConfiguration) throws ImportExportException {
        ExportAgent exportAgent = new ExportAgent(repositoryInterface, tempDirectoryProvider);
        return exportAgent.compileRepositorySnippet(rootObjects, copyConfiguration.getAllObjectTypesToBeCopied(), copyConfiguration.getCrossRelationTypesToImplicitObjects(), copyConfiguration.getCrossRelationTypesToContextObjects(), copyConfiguration.getOccurrenceTypesOfImplicitObjects(), copyConfiguration.getOccurrenceTypesOfContextObjects(), null);
    }

    public static final synchronized boolean isPastePossible(IRepositoryObjectReference targetObjectReference, ICollection_<IRepositoryObjectTypeID> availableDataHint, IRepositoryInterfaceRO repositoryInterface) {
        boolean containsPasteableContent;
        IRepositoryTypeManagerRO typeManager = repositoryInterface.getTypeManager();
        IRepositoryObjectType targetObjectType = typeManager.findObjectType(targetObjectReference.getObjectTypeID());
        if (targetObjectType != null) {
            if (availableDataHint != null) {
                HashSet_ rootObjectTypeIDs = new HashSet_(availableDataHint, IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
                containsPasteableContent = false;
                for (IRepositoryObjectTypeID repositoryObjectTypeID : rootObjectTypeIDs) {
                    IRepositoryObjectType rootObjectType = typeManager.findObjectType(repositoryObjectTypeID);
                    if (rootObjectType == null || targetObjectType.findParentRelationContributionTypeOfChildObjectType(rootObjectType) == null) continue;
                    containsPasteableContent = true;
                }
            } else {
                containsPasteableContent = false;
            }
        } else {
            containsPasteableContent = false;
        }
        return containsPasteableContent;
    }

    public static final synchronized void paste(IRepositoryObjectReference targetObject, RepositorySnippetClipboardContent clipboardContent, IMessageSet interpretationMessages, IFrameProjectAgent projectAgent, IPasteConfiguration pasteConfiguration, EclipseWindow eclipseWindow) throws ImportExportException {
        IRepositoryInterfaceRO repositoryInterface = projectAgent.getRepositoryInterface();
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryInterface.getTypeManager();
        PresentationContext presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
        String title = Messages.getString("CopyManager.Paste.ProblemsDialogue.Title");
        String message = Messages.getString("CopyManager.Paste.ProblemsDialogue.Message");
        String humanReadableDescriptionOfConsequence = Messages.getString("CopyManager.Paste.ProblemsDialogue.Consequence");
        ImportAgent importAgent = new ImportAgent(repositoryInterface);
        importAgent.importRepositorySnippet(clipboardContent.getRepositorySnippet(), interpretationMessages, pasteConfiguration.getImportJobEditors(targetObject, repositoryInterface, clipboardContent.getSourceWorkspaceID(), clipboardContent.getSourceRepositoryInterface(), eclipseWindow), (IRepositoryMessageDisplay)new RepositoryMessageDisplay((IShell)eclipseWindow, repositoryTypeManager, presentationContext, title, message, humanReadableDescriptionOfConsequence));
    }
}

