/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderManager;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.IFrameUIListener;
import com.arcway.cockpit.frame.client.global.gui.IFrameUIManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class FrameUIManager
implements IFrameUIManager,
ISelectionListener {
    private final Collection<IFrameUIListener> listeners = new ArrayList<IFrameUIListener>();
    private IFrameProjectAgent currentProjectAgent;

    protected FrameUIManager(IWorkbenchWindow window) {
        CockpitSelectionService css = CockpitSelectionManager.getSelectionService(window.getSelectionService());
        css.addSelectionListener(this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.currentProjectAgent = null;
            IStructuredSelection sel = (IStructuredSelection)selection;
            String selectedProjectUID = null;
            for (Object o : sel) {
                if (o instanceof ICockpitProjectData) {
                    ICockpitProjectData data = (ICockpitProjectData)o;
                    if (selectedProjectUID != null && !selectedProjectUID.equals(data.getProjectUID())) {
                        selectedProjectUID = null;
                        break;
                    }
                    selectedProjectUID = data.getProjectUID();
                    continue;
                }
                if (!(o instanceof IStakeholderManager)) continue;
                IStakeholderManager stakeholderManager = (IStakeholderManager)o;
                if (selectedProjectUID != null && !selectedProjectUID.equals(stakeholderManager.getProjectUID())) {
                    selectedProjectUID = null;
                    break;
                }
                selectedProjectUID = stakeholderManager.getProjectUID();
            }
            if (selectedProjectUID != null) {
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(selectedProjectUID);
                this.currentProjectAgent = projectAgent.isOpened() ? projectAgent : null;
            }
            this.projectChanged();
        }
    }

    private void projectChanged() {
        for (IFrameUIListener listener : this.listeners) {
            listener.projectActivated(this.currentProjectAgent);
        }
    }

    @Override
    public void registerUIListener(IFrameUIListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }
}

