/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.consoleui.actions;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.consoleui.CockpitConsoleActionParameterSpecifications;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionParameterBindings;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleAction;
import com.arcway.cockpit.frame.client.global.consoleui.IParameterLog;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ProjectParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ServerParameterSpecification;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import java.util.Arrays;

public class CloseProjectAction
implements ICockpitConsoleAction {
    private static final String COMMAND_NAME = "close";
    private static final CockpitConsoleActionParameterSpecifications parameterSpecifications = new CockpitConsoleActionParameterSpecifications(Arrays.asList(ServerParameterSpecification.getSingleton(), ProjectParameterSpecification.getSingleton()));

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public CockpitConsoleActionParameterSpecifications getParametersSpecifications() {
        return parameterSpecifications;
    }

    @Override
    public void execute(ConsoleActionParameterBindings parameters, IParameterLog parameterLog, ScriptCommandContext uiContext) throws ScriptExecutionException {
        String serverName = parameters.getValue(ServerParameterSpecification.getSingleton());
        String projectName = parameters.getValue(ProjectParameterSpecification.getSingleton());
        IFrameProjectAgent pa = ProjectMgr.getProjectMgr().getProjectAgent(serverName, projectName);
        if (pa != null) {
            if (serverName != null && projectName != null) {
                parameterLog.logParameters(String.valueOf(serverName) + " / " + projectName);
            }
            ProjectMgr.getProjectMgr().closeProject(pa, false);
        }
    }
}

