/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.consoleui;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionParameterBindings;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleFromFileReader;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleActionParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.ParameterizedAction;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.LogDirectoryParameterSpecification;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.date.RFC1123DateFormatter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScriptInterpreter {
    private static final ILogger LOGGER = Logger.getLogger(ScriptInterpreter.class);
    private static final String CRLF = "\r\n";
    private final File scriptfile;
    private final File logDir;
    private final ScriptCommandContext uiContext;
    private File createdLogFile = null;

    public ScriptInterpreter(File scriptfile, File logDir, ScriptCommandContext uiContext) {
        this.scriptfile = scriptfile;
        this.logDir = logDir;
        this.uiContext = uiContext;
    }

    public static ScriptInterpreter createScriptInterpreter(File scriptfile, File p_logDirParentDir, ScriptCommandContext uiContext) {
        File logDirParentDir = p_logDirParentDir != null ? p_logDirParentDir : scriptfile.getParentFile();
        String logDirLogMarker = "-log";
        String scriptfileExtension = FileHelper.getFileExtension((File)scriptfile);
        String scriptfileName = scriptfile.getName();
        String logDirNamePrefix = scriptfileExtension.length() > 0 && scriptfileExtension.length() < scriptfileName.length() + 1 ? String.valueOf(scriptfileName.substring(0, scriptfileName.length() - (scriptfileExtension.length() + 1))) + logDirLogMarker : String.valueOf(scriptfileName) + logDirLogMarker;
        File logDirCandidate = new File(logDirParentDir, logDirNamePrefix);
        while (true) {
            String[] dirListing;
            boolean candidateOk = false;
            if (!logDirCandidate.exists()) {
                candidateOk = true;
            } else if (logDirCandidate.isDirectory() && (dirListing = logDirCandidate.list()) != null && dirListing.length == 0) {
                candidateOk = true;
            }
            if (candidateOk) break;
            logDirCandidate = new File(logDirParentDir, String.valueOf(logDirNamePrefix) + System.currentTimeMillis());
        }
        return new ScriptInterpreter(scriptfile, logDirCandidate, uiContext);
    }

    public void executeScript(boolean doLogging) throws ScriptExecutionException {
        if (doLogging) {
            LOGGER.debug("Starting excecution of scriptfile: " + this.scriptfile);
        }
        try {
            this.executeCommands();
            if (doLogging) {
                LOGGER.debug("Successfully completed script execution.");
            }
        }
        catch (ScriptExecutionException e) {
            if (doLogging) {
                LOGGER.error("Execution of script " + this.scriptfile + " was aborted due to the following problem: " + e.getLocalizedMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public void executeScriptAndLogExecution() {
        try {
            this.executeScript(true);
        }
        catch (ScriptExecutionException scriptExecutionException) {
            // empty catch block
        }
    }

    private static String getCurrentTimeString() {
        return RFC1123DateFormatter.getRFC1123String((Date)new Date());
    }

    public void executeCommands() throws ScriptExecutionException {
        IProgressMonitor progressMonitor = this.uiContext.getProgressMonitor();
        ArrayList<String> errorEntries = new ArrayList<String>();
        try {
            FileHelper.ensureDirectoryExistance((File)this.logDir);
            this.createdLogFile = new File(this.logDir, "consoleCommand.log");
            try (ConsoleLogger consoleLogger = new ConsoleLogger(this.createdLogFile);){
                ConsoleFromFileReader reader = ProjectMgr.getProjectMgr().getConsoleActionsFromFileReader(this.scriptfile);
                List<ParameterizedAction> commandList = reader.parseScriptFile(errorEntries);
                for (ParameterizedAction parameterizedAction : commandList) {
                    ConsoleActionParameterBindings parameterBindings;
                    ICockpitConsoleActionParameterSpecification logDirParameterSpecification = parameterizedAction.getAction().getParametersSpecifications().get(LogDirectoryParameterSpecification.getSingleton().getParameterName());
                    if (logDirParameterSpecification == null || (parameterBindings = parameterizedAction.getParameterBindings()).isParameterBound(logDirParameterSpecification)) continue;
                    parameterBindings.addParameterBinding(logDirParameterSpecification, this.logDir.getAbsolutePath());
                }
                progressMonitor.beginTask("Execute Cockpit Script", commandList.size());
                consoleLogger.info(String.valueOf(ScriptInterpreter.getCurrentTimeString()) + " - Successfully parsed/prepared " + commandList.size() + " actions.");
                int work = 0;
                for (ParameterizedAction command : commandList) {
                    try {
                        progressMonitor.subTask("Executing command " + (work + 1) + "/" + commandList.size() + ": " + command.getAction().getCommandName());
                        try {
                            command.execute(this.uiContext);
                        }
                        catch (ScriptExecutionException e) {
                            throw e;
                        }
                        catch (Throwable th) {
                            throw new ScriptExecutionException(th);
                        }
                        String executionNotice = command.getExecutionNotice();
                        String errorMessage = command.getErrorMessage();
                        if (errorMessage != null) {
                            consoleLogger.error(String.valueOf(ScriptInterpreter.getCurrentTimeString()) + " - Unsuccessfully executed action \"" + command.getAction().getCommandName() + "\"" + (executionNotice == null ? "" : " - " + executionNotice) + ": " + errorMessage);
                        } else {
                            consoleLogger.info(String.valueOf(ScriptInterpreter.getCurrentTimeString()) + " - Successfully executed action \"" + command.getAction().getCommandName() + "\"" + (executionNotice == null ? "" : " - " + executionNotice));
                        }
                        progressMonitor.worked(++work);
                        if (!progressMonitor.isCanceled()) continue;
                        throw new ScriptExecutionException("Script execution cancelled by user");
                    }
                    catch (ScriptExecutionException e) {
                        consoleLogger.error(String.valueOf(ScriptInterpreter.getCurrentTimeString()) + " - Failed to execute action \"" + command.getAction().getCommandName() + "\" Problem: " + e.getLocalizedMessage());
                        throw e;
                    }
                }
                consoleLogger.info(String.valueOf(ScriptInterpreter.getCurrentTimeString()) + " - Successfully completed script execution.");
                progressMonitor.done();
            }
        }
        catch (FileNotFoundException e) {
            throw new ScriptExecutionException(e);
        }
        catch (JvmExternalResourceInteractionException e) {
            throw new ScriptExecutionException(e);
        }
        catch (IOException e) {
            throw new ScriptExecutionException(e);
        }
    }

    public File getCreatedLogFile() {
        return this.createdLogFile;
    }

    private class ConsoleLogger {
        private final FileWriter consoleCommandLogWriter;

        public ConsoleLogger(File createdLogFile) throws IOException {
            this.consoleCommandLogWriter = new FileWriter(createdLogFile);
        }

        public void info(String message) throws IOException {
            LOGGER.info(message);
            this.consoleCommandLogWriter.write(message);
            this.consoleCommandLogWriter.write(ScriptInterpreter.CRLF);
        }

        public void error(String message) throws IOException {
            LOGGER.error(message);
            this.consoleCommandLogWriter.write(message);
            this.consoleCommandLogWriter.write(ScriptInterpreter.CRLF);
        }

        public void close() throws IOException {
            this.consoleCommandLogWriter.flush();
            this.consoleCommandLogWriter.close();
        }
    }
}

