/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.menu.actions;

import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.EditDocumentContainerAdapter;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionNewContainer
extends Action {
    private final Shell activeShell;
    private final IModelController modelCtrl;
    private final Category parent;

    public ActionNewContainer(Shell activeShell, IModelController modelCtrl, Category parent) {
        this.activeShell = activeShell;
        this.modelCtrl = modelCtrl;
        this.parent = parent;
    }

    public void run() {
        assert (this.modelCtrl != null);
        assert (this.parent != null);
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        LockAccess lock = lockMgr.acquireInsertLock((ICockpitProjectData)this.parent);
        if (!lock.hasLock()) {
            lock.releaseLocks();
            return;
        }
        EditDocumentContainerAdapter dialogProvider = new EditDocumentContainerAdapter(this.parent);
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "dcm.documentcontainer", this.modelCtrl, Messages.getString("EditDocumentContainerDialog.EnterDCAttributes"));
        DocumentContainer newItem = new DocumentContainer();
        newItem.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{this.parent});
        if (!creationPossible) {
            lock.releaseLocks();
            return;
        }
        if (new WizardDialog(this.activeShell, (IWizard)wizard).open() != 0) {
            lock.releaseLocks();
        }
    }
}

