/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dialogs;

import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.description.CategoryDescription;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EditCategoryAdapter
extends ModuleDataEditPropertyAdapter
implements ModifyListener {
    private Category item;
    private IModelController model;
    UIETextField nameField;
    private LockAccess editLock;
    private LockAccess idLock;
    private String oldName;
    private Collection existingNames;
    private boolean isExclusiveProjectLockConflicting = false;

    public EditCategoryAdapter() {
        super(true);
    }

    public EditCategoryAdapter(boolean isNew) {
        super(isNew);
    }

    private void internalConstruct() {
        Collection categories = this.model.getAllItems("dcm.category");
        this.existingNames = new HashSet(categories.size());
        for (Category category : categories) {
            this.existingNames.add(category.getName().getDisplayStringRepresentation());
        }
    }

    public String getDataTypeID() {
        return "dcm.category";
    }

    public Class getDataClass() {
        return Category.class;
    }

    public String getPropertyName() {
        return Category.MODULE_DATA_NAME;
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return DocumentModulePlugin.getImageDescriptor("Category.gif");
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return DocumentModulePlugin.getDefault().getImageDescriptorRegistry();
    }

    public Composite createEditPage_internal(Composite parent) {
        Composite editArea = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        editArea.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        editArea.setLayout((Layout)layout);
        this.createCategoryWidget(editArea, 2, (IModuleData)this.item);
        this.nameField = new UIETextField(Category.NAME_NAME, this.item.getName().getValueRangeHelper());
        this.createLabel(String.valueOf(Category.NAME_NAME) + ":", 1, editArea);
        Control control = this.nameField.getControl(editArea);
        gridData = new GridData(4, 0, true, false);
        control.setLayoutData((Object)gridData);
        this.setValues();
        this.setWidgetState();
        this.nameField.addModifyListener((ModifyListener)this);
        this.handleModifications(false);
        return editArea;
    }

    private void setWidgetState() {
        PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
        if (!this.isCreationDialogue()) {
            if (!this.editLock.hasLock()) {
                this.disableAll();
                return;
            }
            if (!permissionMgr.mayEditItemStructurally((IModuleData)this.item, null)) {
                this.disableAll();
                this.setCategoryEditable(false);
            } else {
                this.setCategoryEditable(true);
            }
        }
    }

    private void disableAll() {
        this.nameField.setEditable(false);
        this.setCategoryEditable(false);
    }

    private Set getAllValues() {
        Collection allItems = this.model.getAllItems("dcm.category");
        HashSet<String> allValues = new HashSet<String>(allItems.size());
        for (Category element : allItems) {
            allValues.add(element.getName().getDisplayStringRepresentation());
        }
        allValues.remove(this.item.getName().getDisplayStringRepresentation());
        return allValues;
    }

    private void setValues() {
        this.nameField.setValue();
    }

    protected void doCommitChanges() {
        if (!this.isCreationDialogue() && !this.nameField.getCurrentValue().trim().equals(this.oldName)) {
            AbstractLockManager lockManager = this.model.getLockMgr();
            lockManager.releaseUniqueIdLock("dcm.category", this.oldName);
        }
        this.nameField.getValue();
        this.item.getName().setValueViaDisplayStringRepresentation(this.nameField.getCurrentValue());
        if (this.isCreationDialogue()) {
            this.model.addItem((IModuleData)this.item);
        } else {
            this.model.itemPropertiesModified((IModuleData)this.item, null);
        }
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected IModelController getModelController(IModuleData p_item) {
        return DocumentModulePlugin.getDefault().getProjectManager().getModelController(p_item.getProjectUID());
    }

    protected AbstractModulePlugin getPlugin() {
        return DocumentModulePlugin.getDefault();
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            IModuleData item0 = items[0];
            assert (item0 instanceof Category);
            this.item = (Category)item0;
            this.model = this.getModelController(item0);
            this.oldName = this.item.getName().getDisplayStringRepresentation();
            this.internalConstruct();
            if (!this.isCreationDialogue()) {
                this.editLock = this.model.getLockMgr().acquireEditLock((ICockpitProjectData)item0, false);
                if (this.editLock.hasLock()) {
                    this.item = (Category)this.model.getItem("dcm.category", item0.getUID());
                    if (this.item == null) {
                        return this.getModificationProblemItemDeleted();
                    }
                }
            }
        }
        return null;
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return CategoryDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    public void cancelChanges1() {
    }

    public Collection<IModificationProblem> requestCommit() {
        AbstractLockManager lockManager = this.model.getLockMgr();
        this.idLock = lockManager.acquireUniqueNameLock(this.nameField.getCurrentValue().trim(), "dcm.category", null);
        if (!this.idLock.hasLock()) {
            this.isExclusiveProjectLockConflicting = this.idLock.isExclusiveProjectLockConflicting();
            if (!this.isExclusiveProjectLockConflicting) {
                this.getCallback().setCommitable(false);
                return Arrays.asList(new ModificationProblem(Messages.getString("EditCategoryAdapter.ModProbMsgNoLock"), Messages.getString("EditCategoryAdapter.ModProbTitleNoLock")));
            }
            this.getCallback().setCommitable(true);
            return Arrays.asList(new ModificationProblem(com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Message"), com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Title")));
        }
        this.getCallback().setCommitable(true);
        return Collections.EMPTY_SET;
    }

    public void rollbackCommitRequest() {
        this.idLock.releaseLocks();
        if (this.editLock != null) {
            this.editLock.releaseLocks();
        }
    }

    public void modifyText(ModifyEvent e) {
        this.handleModifications(true);
    }

    private void handleModifications(boolean notAtInitialisation) {
        String check = this.nameField.checkCurrentValue();
        if (!this.nameField.getCurrentValue().equals(this.oldName) && this.existingNames.contains(this.nameField.getCurrentValue().trim())) {
            check = Messages.getString("EditCategoryAdapter.ErrMsgNoLock");
        }
        if (this.isExclusiveProjectLockConflicting) {
            if (notAtInitialisation) {
                this.getCallback().setErrMsg(com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Message"));
                this.getCallback().setChangedStatus(true);
            } else {
                this.getCallback().setChangedStatus(false);
            }
        } else if (notAtInitialisation) {
            this.getCallback().setErrMsg(check);
            this.getCallback().setChangedStatus(true);
        } else {
            this.getCallback().setChangedStatus(false);
        }
        this.getCallback().setCommitable(check == null);
    }
}

