/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui;

import com.arcway.cockpit.documentmodule.client.gui.DataViewColumnConstants;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.AbstractDataViewColumnComparator;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewColumnComparator;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IFixColumnDescriptionProvider;
import java.util.Arrays;
import java.util.Collection;

public class DCMFixColumnDescriptionProvider
implements IFixColumnDescriptionProvider {
    private static final IDataViewColumnComparator treeColumnComparator = new AbstractDataViewColumnComparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof DocumentContainer && o2 instanceof DocumentContainer) {
                return ((DocumentContainer)o1).getName().getValue().compareToIgnoreCase(((DocumentContainer)o2).getName().getValue());
            }
            if (o1 instanceof Category && o2 instanceof Category) {
                return ((Category)((Object)o1)).getName().getValue().compareToIgnoreCase(((Category)((Object)o2)).getName().getValue());
            }
            return 0;
        }
    };
    private static final IDataViewColumnComparator urlColumnComparator = new AbstractDataViewColumnComparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ResourceLocator && o2 instanceof ResourceLocator) {
                String url1 = o1 instanceof RLFileSystemLink ? ((RLFileSystemLink)((Object)o1)).getLocalURL() : ((ResourceLocator)((Object)o1)).getURL().getValue();
                String url2 = o2 instanceof RLFileSystemLink ? ((RLFileSystemLink)((Object)o2)).getLocalURL() : ((ResourceLocator)((Object)o2)).getURL().getValue();
                return url1.compareToIgnoreCase(url2);
            }
            return 0;
        }
    };
    private static final IDataViewColumnComparator serverurlColumnComparator = new AbstractDataViewColumnComparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ResourceLocator && o2 instanceof ResourceLocator) {
                return ((ResourceLocator)((Object)o1)).getURL().getValue().compareToIgnoreCase(((ResourceLocator)((Object)o2)).getURL().getValue());
            }
            return 0;
        }
    };
    private static final IDataViewColumnComparator statusColumnComparator = new AbstractDataViewColumnComparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof DocumentContainer && o2 instanceof DocumentContainer) {
                return ((DocumentContainer)o1).getState().getValue() - ((DocumentContainer)o2).getState().getValue();
            }
            return 0;
        }
    };
    private static final IDataViewColumnComparator filelinkstateColumnComparator = new AbstractDataViewColumnComparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof RLFileSystemLink && o2 instanceof RLFileSystemLink) {
                return ((RLFileSystemLink)((Object)o1)).getLinkState().getValue() - ((RLFileSystemLink)((Object)o2)).getLinkState().getValue();
            }
            return 0;
        }
    };

    public Collection<IColumnDescription> getColumnDescriptions() {
        return Arrays.asList(new ColumnDescription("tree", DataViewColumnConstants.COLUMN_NAME_TREE, 160, 0, true, 1, 0, treeColumnComparator), new ColumnDescription("url", DataViewColumnConstants.COLUMN_NAME_URL, 240, 10, true, 1, 10, urlColumnComparator), new ColumnDescription("serverurl", DataViewColumnConstants.COLUMN_NAME_SERVERURL, 240, 20, false, 1, 20, serverurlColumnComparator), new ColumnDescription("status", DataViewColumnConstants.COLUMN_NAME_STATUS, 80, 30, true, 1, 30, statusColumnComparator), new ColumnDescription("keywords", DataViewColumnConstants.COLUMN_NAME_KEYWORDS, 200, 40, true, 1, 40, null), new ColumnDescription("link state", DataViewColumnConstants.COLUMN_NAME_LINK_STATE, 80, 50, true, 1, 50, filelinkstateColumnComparator));
    }
}

