/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.DocGenColor;
import com.arcway.cockpit.docgen.provider.DocGenTextStyle;
import com.arcway.cockpit.docgen.provider.IReportRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IReportRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.interfaces.IColor;
import com.arcway.cockpit.docgen.provider.interfaces.IProjectionFactory;
import com.arcway.cockpit.docgen.provider.interfaces.ITextStyle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.planagent.controllinginterface.lib.projections.BubbleContainerProjection;
import com.arcway.planagent.controllinginterface.lib.projections.CounterProjection;
import com.arcway.planagent.controllinginterface.lib.projections.DimensionedProgressBarProjection;
import com.arcway.planagent.controllinginterface.lib.projections.ProgressBarProjection;
import com.arcway.planagent.controllinginterface.lib.projections.TextArrayProjection;
import com.arcway.planagent.controllinginterface.lib.projections.TextLabelProjection;
import com.arcway.planagent.controllinginterface.lib.projections.TextProjection;
import com.arcway.planagent.controllinginterface.lib.projections.WarningSignProjection;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;
import java.util.List;

public class ProjectionFactory
implements IReportRelatedReportProvider,
IProjectionFactory {
    @Override
    public void setup(IReportRelatedReportContext reportContext) {
    }

    @Override
    public IProjection createWarningSignProjection() {
        return new WarningSignProjection();
    }

    @Override
    public IProjection createTextProjection(String text, IColor textColor, double textWidth, ITextStyle textStyle, double textHeight, int hAlignment, int vAlignment) {
        TextProjection projection = new TextProjection(text, DocGenColor.toColor(textColor), textWidth, DocGenTextStyle.toTextStyle(textStyle), textHeight, new Alignment(hAlignment, vAlignment));
        return projection;
    }

    @Override
    public IProjection createTextArrayProjection(List<String> texts, IColor textColor, double textArrayWidthHint, int textArrayWidthMode, ITextStyle textStyle, double textHeight, int hAlignment, int vAlignment) {
        TextArrayProjection projection = new TextArrayProjection(texts.toArray(new String[texts.size()]), DocGenColor.toColor(textColor), textArrayWidthHint, textArrayWidthMode, DocGenTextStyle.toTextStyle(textStyle), textHeight, new Alignment(hAlignment, vAlignment));
        return projection;
    }

    @Override
    public IProjection createTextLabelProjection(String text) {
        return new TextLabelProjection(text);
    }

    @Override
    public IProjection createCounterProjection(int count) {
        return new CounterProjection(count);
    }

    @Override
    public IProjection createCounterProjection(int count, IColor color) {
        return new CounterProjection(count, DocGenColor.toColor(color));
    }

    @Override
    public IProjection createCounterProjection(String text, IColor color) {
        return new CounterProjection(text, DocGenColor.toColor(color));
    }

    @Override
    public IProjection createProgressBarProjection(int progress) {
        return new ProgressBarProjection(progress);
    }

    @Override
    public IProjection createBubbleContainerProjection(List<IProjection> projections) {
        return new BubbleContainerProjection(projections.toArray(new IProjection[projections.size()]));
    }

    @Override
    public IProjection createDimensionedProgressBarProjection(double barAreaWidth, double textAreaMinWidth, double barAreaHeight, double axisAreaHeight, IColor axisColor, double axisLength, IColor axisBorderColor, IColor axisLabelColor, ITextStyle axisLabelTextStyle, String axisLabelText, IColor barPartLeftFillColor, IColor barPartLeftTextColor, ITextStyle barPartLeftTextStyle, String barPartLeftText, double barPartLeftLength, IColor barPartRightFillColor, IColor barPartRightTextColor, ITextStyle barPartRightTextStyle, String barPartRightText, double barPartRigthLength, IColor barBorderColor, IColor barLabelColor, ITextStyle barLabelTextStyle, String barLabelText) {
        return new DimensionedProgressBarProjection(barAreaWidth, textAreaMinWidth, barAreaHeight, axisAreaHeight, DocGenColor.toColor(axisColor), axisLength, DocGenColor.toColor(axisBorderColor), DocGenColor.toColor(axisLabelColor), DocGenTextStyle.toTextStyle(axisLabelTextStyle), axisLabelText, DocGenColor.toFillColor(barPartLeftFillColor), DocGenColor.toColor(barPartLeftTextColor), DocGenTextStyle.toTextStyle(barPartLeftTextStyle), barPartLeftText, barPartLeftLength, DocGenColor.toFillColor(barPartRightFillColor), DocGenColor.toColor(barPartRightTextColor), DocGenTextStyle.toTextStyle(barPartRightTextStyle), barPartRightText, barPartRigthLength, DocGenColor.toColor(barBorderColor), DocGenColor.toColor(barLabelColor), DocGenTextStyle.toTextStyle(barLabelTextStyle), barLabelText);
    }

    @Override
    public IColor createColor(int red, int green, int blue) {
        return new DocGenColor(red, green, blue);
    }

    @Override
    public ITextStyle createTextStyle(String fontName, boolean isBold, boolean isItalic) {
        return new DocGenTextStyle(fontName, isBold, isItalic);
    }
}

