/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.DocGenRectangle;
import com.arcway.cockpit.docgen.provider.interfaces.IPlanElementInfo;
import com.arcway.cockpit.docgen.provider.interfaces.IPlanInfo;
import com.arcway.cockpit.docgen.provider.interfaces.IRectangle;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.controllinginterface.planagent.FlowType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class PlanInfo
implements IPlanInfo {
    private final IRectangle outerBoundsInMM;
    private final List<IPlanElementInfo> planElementInfos;
    private final boolean isYPrimaryCoordinate;
    private static final double EXCEPTION_THRESHOLD_IN_MM = 7.0;

    private static boolean isYPrimaryCoordinate(List<IPlanElementInfo> planElementInfos) {
        double deltaX = 0.0;
        double deltaY = 0.0;
        for (IPlanElementInfo element : planElementInfos) {
            IRectangle elementBoundary = element.getPointUnionInMM();
            if (elementBoundary == null) continue;
            double elementX = elementBoundary.getX() + elementBoundary.getW() / 2.0;
            double elementY = elementBoundary.getY() + elementBoundary.getH() / 2.0;
            boolean withContainments = false;
            Set<IPlanElementInfo> directSuccessors = PlanInfo.getDirectSuccessors(element, withContainments);
            for (IPlanElementInfo successor : directSuccessors) {
                IRectangle successorBoundary = successor.getPointUnionInMM();
                if (successorBoundary == null) continue;
                double successorX = successorBoundary.getX() + successorBoundary.getW() / 2.0;
                double successorY = successorBoundary.getY() + successorBoundary.getH() / 2.0;
                deltaX += successorX - elementX;
                deltaY += successorY - elementY;
            }
        }
        return deltaY > deltaX;
    }

    public PlanInfo(Rectangle outerBoundsInMM, List<IPlanElementInfo> planElementInfos, FlowType flowType) {
        this.planElementInfos = planElementInfos;
        this.outerBoundsInMM = new DocGenRectangle(outerBoundsInMM);
        this.isYPrimaryCoordinate = flowType == FlowType.UNKNOWN ? PlanInfo.isYPrimaryCoordinate(planElementInfos) : flowType == FlowType.VERTICAL;
    }

    @Override
    public IRectangle getOuterBoundsInMM() {
        return this.outerBoundsInMM;
    }

    @Override
    public double getWinMM() {
        return this.outerBoundsInMM.getW();
    }

    @Override
    public double getHinMM() {
        return this.outerBoundsInMM.getH();
    }

    @Override
    public List<? extends IPlanElementInfo> getPlanElementInfos() {
        return this.planElementInfos;
    }

    @Override
    public List<IPlanElementInfo> getPlanElementInfosSortedByStructure() {
        ArrayList<IPlanElementInfo> sortedElements = new ArrayList<IPlanElementInfo>();
        HashSet<IPlanElementInfo> unsortedElements = new HashSet<IPlanElementInfo>(this.planElementInfos);
        HashSet<IPlanElementInfo> elementsToAppend = new HashSet<IPlanElementInfo>(this.planElementInfos);
        this.appendElementsInCausalOrder(elementsToAppend, sortedElements, unsortedElements);
        return sortedElements;
    }

    private void appendElementsInCausalOrder(Set<IPlanElementInfo> elementsToAppend, List<IPlanElementInfo> sortedElements, Set<IPlanElementInfo> unsortedElements) {
        Set<IPlanElementInfo> elementsToAppendRemaining = PlanInfo.getElementsToAppendRemaining(elementsToAppend, unsortedElements);
        while (!elementsToAppendRemaining.isEmpty()) {
            boolean primaryCoordinateHasHigherPriority = true;
            IPlanElementInfo elementToAppend = this.chooseFirstElement(elementsToAppendRemaining, primaryCoordinateHasHigherPriority, sortedElements, unsortedElements);
            this.appendElement(elementToAppend, elementsToAppend, sortedElements, unsortedElements);
            elementsToAppendRemaining = PlanInfo.getElementsToAppendRemaining(elementsToAppend, unsortedElements);
        }
    }

    private static Set<IPlanElementInfo> getElementsToAppendRemaining(Set<IPlanElementInfo> elementsToAppend, Set<IPlanElementInfo> unsortedElements) {
        HashSet<IPlanElementInfo> remainingElements = new HashSet<IPlanElementInfo>(elementsToAppend);
        remainingElements.retainAll(unsortedElements);
        return remainingElements;
    }

    private IPlanElementInfo chooseFirstElement(Set<IPlanElementInfo> elements, boolean primaryCoordinateHasHigherPriority, List<IPlanElementInfo> sortedElements, Set<IPlanElementInfo> unsortedElements) {
        TreeSet<WeightedElementForFirstElement> weightedElements = new TreeSet<WeightedElementForFirstElement>(new ComparatorForWeightedElementForFirstElement(primaryCoordinateHasHigherPriority));
        for (IPlanElementInfo element : elements) {
            int indexOfElement = this.planElementInfos.indexOf(element);
            weightedElements.add(new WeightedElementForFirstElement(element, indexOfElement, this.isYPrimaryCoordinate, sortedElements, unsortedElements));
        }
        return ((WeightedElementForFirstElement)weightedElements.iterator().next()).getElement();
    }

    private void appendElement(IPlanElementInfo elementToAppend, Set<IPlanElementInfo> elementsToAppend, List<IPlanElementInfo> sortedElements, Set<IPlanElementInfo> unsortedElements) {
        Set<IPlanElementInfo> relevantPredessors = PlanInfo.getAllRelevantPredessors(elementToAppend, elementsToAppend, unsortedElements);
        this.appendElementsInCausalOrder(relevantPredessors, sortedElements, unsortedElements);
        sortedElements.add(elementToAppend);
        unsortedElements.remove(elementToAppend);
        this.appendSuccessors(elementToAppend, elementsToAppend, sortedElements, unsortedElements);
    }

    private void appendSuccessors(IPlanElementInfo element, Set<IPlanElementInfo> elementsToAppend, List<IPlanElementInfo> sortedElements, Set<IPlanElementInfo> unsortedElements) {
        Set<IPlanElementInfo> relevantDirectSuccessors = this.getRelevantDirectSuccessors(element, elementsToAppend, unsortedElements);
        while (!relevantDirectSuccessors.isEmpty()) {
            IPlanElementInfo successorToAppend;
            Set<IPlanElementInfo> relevantDirectSuccessorsPrioritized = PlanInfo.getRelevantDirectSuccessorsPrioritized(element, elementsToAppend, unsortedElements);
            if (!relevantDirectSuccessorsPrioritized.isEmpty()) {
                boolean primaryCoordinateHasHigherPriority = true;
                successorToAppend = this.chooseFirstElement(relevantDirectSuccessorsPrioritized, primaryCoordinateHasHigherPriority, sortedElements, unsortedElements);
            } else {
                boolean primaryCoordinateHasHigherPriority;
                Set<IPlanElementInfo> relevantDirectSuccessorsInCylces = PlanInfo.getRelevantDirectSuccessorsInCylces(element, relevantDirectSuccessors);
                if (!relevantDirectSuccessorsInCylces.isEmpty()) {
                    primaryCoordinateHasHigherPriority = false;
                    successorToAppend = this.chooseFirstElement(relevantDirectSuccessorsInCylces, primaryCoordinateHasHigherPriority, sortedElements, unsortedElements);
                } else {
                    primaryCoordinateHasHigherPriority = false;
                    successorToAppend = this.chooseFirstElement(relevantDirectSuccessors, primaryCoordinateHasHigherPriority, sortedElements, unsortedElements);
                }
            }
            relevantDirectSuccessors.remove(successorToAppend);
            this.appendElement(successorToAppend, elementsToAppend, sortedElements, unsortedElements);
            relevantDirectSuccessors = this.getRelevantDirectSuccessors(element, elementsToAppend, unsortedElements);
        }
    }

    private static Set<IPlanElementInfo> getRelevantDirectSuccessorsInCylces(IPlanElementInfo element, Set<IPlanElementInfo> relevantDirectSuccessors) {
        HashSet<IPlanElementInfo> relevantDirectSuccessorsInCylces = new HashSet<IPlanElementInfo>();
        for (IPlanElementInfo directSuccessor : relevantDirectSuccessors) {
            Set<IPlanElementInfo> allSuccSuccessors = PlanInfo.getAllSuccessors(directSuccessor);
            boolean cycle = allSuccSuccessors.contains(element);
            if (!cycle) continue;
            relevantDirectSuccessorsInCylces.add(directSuccessor);
        }
        return relevantDirectSuccessorsInCylces;
    }

    private static Set<IPlanElementInfo> getRelevantDirectSuccessorsPrioritized(IPlanElementInfo element, Set<IPlanElementInfo> elementsToAppend, Set<IPlanElementInfo> unsortedElements) {
        HashSet<IPlanElementInfo> relevantDirectSuccessorsPrioritized = new HashSet<IPlanElementInfo>();
        for (IPlanElementInfo directSuccessor : PlanInfo.getDirectSuccessorsPrioritized(element)) {
            if (!PlanInfo.isRelevant(directSuccessor, elementsToAppend, unsortedElements)) continue;
            relevantDirectSuccessorsPrioritized.add(directSuccessor);
        }
        return relevantDirectSuccessorsPrioritized;
    }

    private Set<IPlanElementInfo> getRelevantDirectSuccessors(IPlanElementInfo element, Set<IPlanElementInfo> elementsToAppend, Set<IPlanElementInfo> unsortedElements) {
        HashSet<IPlanElementInfo> relevantDirectSuccessors = new HashSet<IPlanElementInfo>();
        boolean withContainments = true;
        for (IPlanElementInfo directSuccessor : PlanInfo.getDirectSuccessors(element, withContainments)) {
            boolean isException;
            if (!PlanInfo.isRelevant(directSuccessor, elementsToAppend, unsortedElements) || (isException = this.isException(directSuccessor))) continue;
            relevantDirectSuccessors.add(directSuccessor);
        }
        return relevantDirectSuccessors;
    }

    private boolean isException(IPlanElementInfo element) {
        boolean isException;
        IRectangle boundsInMM = element.getOuterBoundsInMM();
        if (boundsInMM != null) {
            double w = boundsInMM.getW();
            double h = boundsInMM.getH();
            double primarySize = this.isYPrimaryCoordinate ? h : w;
            double secondarySize = this.isYPrimaryCoordinate ? w : h;
            isException = primarySize < Math.min(secondarySize, 7.0);
        } else {
            isException = false;
        }
        return isException;
    }

    private static Set<IPlanElementInfo> getAllRelevantPredessors(IPlanElementInfo element, Set<IPlanElementInfo> elementsToAppend, Set<IPlanElementInfo> unsortedElements) {
        HashSet<IPlanElementInfo> allRelevantPredessors = new HashSet<IPlanElementInfo>();
        PlanInfo.addAllRelevantPredessors(element, element, elementsToAppend, unsortedElements, allRelevantPredessors);
        allRelevantPredessors.remove(element);
        return allRelevantPredessors;
    }

    private static void addAllRelevantPredessors(IPlanElementInfo initialElement, IPlanElementInfo currentElement, Set<IPlanElementInfo> elementsToAppend, Set<IPlanElementInfo> unsortedElements, Set<IPlanElementInfo> allRelevantPredessors) {
        for (IPlanElementInfo directPredessor : PlanInfo.getDirectPredessors(currentElement)) {
            Set<IPlanElementInfo> allPrePredessors;
            boolean cycle;
            boolean isDirectPredessorToAdd;
            if (!PlanInfo.isRelevant(directPredessor, elementsToAppend, unsortedElements) || allRelevantPredessors.contains(directPredessor) || !(isDirectPredessorToAdd = currentElement.equals(initialElement) ? !(cycle = (allPrePredessors = PlanInfo.getAllPredessors(directPredessor)).contains(currentElement)) : true)) continue;
            allRelevantPredessors.add(directPredessor);
            PlanInfo.addAllRelevantPredessors(initialElement, directPredessor, elementsToAppend, unsortedElements, allRelevantPredessors);
        }
    }

    private static boolean isRelevant(IPlanElementInfo element, Set<IPlanElementInfo> elementsToAppend, Set<IPlanElementInfo> unsortedElements) {
        return elementsToAppend.contains(element) && unsortedElements.contains(element);
    }

    private static Set<IPlanElementInfo> getAllPredessors(IPlanElementInfo element) {
        HashSet<IPlanElementInfo> allPredessors = new HashSet<IPlanElementInfo>();
        PlanInfo.addAllPredessors(element, allPredessors);
        return allPredessors;
    }

    private static void addAllPredessors(IPlanElementInfo element, Set<IPlanElementInfo> allPredessors) {
        for (IPlanElementInfo predessor : PlanInfo.getDirectPredessors(element)) {
            boolean isNew = allPredessors.add(predessor);
            if (!isNew) continue;
            PlanInfo.addAllPredessors(predessor, allPredessors);
        }
    }

    private static Set<IPlanElementInfo> getAllSuccessors(IPlanElementInfo element) {
        HashSet<IPlanElementInfo> allSuccessors = new HashSet<IPlanElementInfo>();
        PlanInfo.addAllSuccessors(element, allSuccessors);
        return allSuccessors;
    }

    private static void addAllSuccessors(IPlanElementInfo element, Set<IPlanElementInfo> allSuccessors) {
        boolean withContainments = true;
        for (IPlanElementInfo successor : PlanInfo.getDirectSuccessors(element, withContainments)) {
            boolean isNew = allSuccessors.add(successor);
            if (!isNew) continue;
            PlanInfo.addAllSuccessors(successor, allSuccessors);
        }
    }

    private static Set<IPlanElementInfo> getDirectPredessors(IPlanElementInfo element) {
        Set<IPlanElementInfo> directPredessors;
        int topologyType = element.getTopologyType();
        if (topologyType == 0) {
            directPredessors = PlanInfo.getDirectPredessorsFlat(element);
        } else if (topologyType == 2) {
            directPredessors = PlanInfo.getDirectPredessorsDeep(element);
        } else {
            throw new IllegalArgumentException();
        }
        return directPredessors;
    }

    private static Set<IPlanElementInfo> getDirectPredessorsFlat(IPlanElementInfo element) {
        HashSet<IPlanElementInfo> directPredessors = new HashSet<IPlanElementInfo>();
        directPredessors.addAll(element.getContainers());
        return directPredessors;
    }

    private static Set<IPlanElementInfo> getDirectPredessorsDeep(IPlanElementInfo element) {
        HashSet<IPlanElementInfo> directPredessors = new HashSet<IPlanElementInfo>();
        directPredessors.addAll(element.getContainers());
        directPredessors.addAll(element.getPredecessors());
        directPredessors.addAll(element.getWriters());
        return directPredessors;
    }

    private static Set<IPlanElementInfo> getDirectSuccessors(IPlanElementInfo element, boolean withContainments) {
        Set<IPlanElementInfo> directSuccessors;
        int topologyType = element.getTopologyType();
        if (topologyType == 0) {
            directSuccessors = PlanInfo.getDirectSuccessorsFlat(element, withContainments);
        } else if (topologyType == 2) {
            directSuccessors = PlanInfo.getDirectSuccessorsDeep(element, withContainments);
        } else {
            throw new IllegalArgumentException();
        }
        return directSuccessors;
    }

    private static Set<IPlanElementInfo> getDirectSuccessorsFlat(IPlanElementInfo element, boolean withContainments) {
        HashSet<IPlanElementInfo> directSuccessors = new HashSet<IPlanElementInfo>();
        if (withContainments) {
            directSuccessors.addAll(element.getContainedPlanElements());
        }
        return directSuccessors;
    }

    private static Set<IPlanElementInfo> getDirectSuccessorsPrioritized(IPlanElementInfo element) {
        HashSet<IPlanElementInfo> directSuccessors = new HashSet<IPlanElementInfo>();
        directSuccessors.addAll(element.getContainedPlanElements());
        directSuccessors.addAll(element.getReaders());
        return directSuccessors;
    }

    private static Set<IPlanElementInfo> getDirectSuccessorsDeep(IPlanElementInfo element, boolean withContainments) {
        HashSet<IPlanElementInfo> directSuccessors = new HashSet<IPlanElementInfo>();
        if (withContainments) {
            directSuccessors.addAll(element.getContainedPlanElements());
        }
        directSuccessors.addAll(element.getSuccessors());
        directSuccessors.addAll(element.getReaders());
        return directSuccessors;
    }

    private static class ComparatorForWeightedElementForFirstElement
    implements Comparator<WeightedElementForFirstElement> {
        private final boolean primaryCoordinateHasHigherPriority;

        public ComparatorForWeightedElementForFirstElement(boolean primaryCoordinateHasHigherPriority) {
            this.primaryCoordinateHasHigherPriority = primaryCoordinateHasHigherPriority;
        }

        @Override
        public int compare(WeightedElementForFirstElement o1, WeightedElementForFirstElement o2) {
            int diff;
            if (o1.element.equals(o2.element)) {
                return 0;
            }
            int lastSortedPredessorDiff = ComparatorForWeightedElementForFirstElement.getIndexWeight(o2.indexOfLastSortedPredecessor) - ComparatorForWeightedElementForFirstElement.getIndexWeight(o1.indexOfLastSortedPredecessor);
            if (lastSortedPredessorDiff != 0) {
                diff = lastSortedPredessorDiff;
            } else {
                int containtmentDiff = o1.nrOfUnsortedContainers - o2.nrOfUnsortedContainers;
                if (containtmentDiff != 0) {
                    diff = containtmentDiff;
                } else {
                    int causalityDiff = o1.nrOfUnsortedPredecessors - o2.nrOfUnsortedPredecessors;
                    if (causalityDiff != 0) {
                        diff = causalityDiff;
                    } else {
                        int accessDiff = o1.nrOfUnsortedWriters - o2.nrOfUnsortedWriters;
                        if (accessDiff != 0) {
                            diff = accessDiff;
                        } else {
                            double o2CoordinateWithLowerPriority;
                            double o1CoordinateWithHigherPriority = this.primaryCoordinateHasHigherPriority ? o1.primaryCoordinate : o1.secondaryCoordinate;
                            double o2CoordinateWithHigherPriority = this.primaryCoordinateHasHigherPriority ? o2.primaryCoordinate : o2.secondaryCoordinate;
                            double o1CoordinateWithLowerPriority = this.primaryCoordinateHasHigherPriority ? o1.secondaryCoordinate : o1.primaryCoordinate;
                            double d = o2CoordinateWithLowerPriority = this.primaryCoordinateHasHigherPriority ? o2.secondaryCoordinate : o2.primaryCoordinate;
                            diff = !Geo.equals((double)o1CoordinateWithHigherPriority, (double)o2CoordinateWithHigherPriority) ? Double.compare(o1CoordinateWithHigherPriority, o2CoordinateWithHigherPriority) : (!Geo.equals((double)o1CoordinateWithLowerPriority, (double)o2CoordinateWithLowerPriority) ? Double.compare(o1CoordinateWithLowerPriority, o2CoordinateWithLowerPriority) : o1.index - o2.index);
                        }
                    }
                }
            }
            return diff;
        }

        private static int getIndexWeight(int index) {
            if (index < 0) {
                return -1;
            }
            if (index == 0) {
                return 0;
            }
            return 1;
        }
    }

    private static class WeightedElementForFirstElement {
        private final IPlanElementInfo element;
        private final int index;
        private final int indexOfLastSortedPredecessor;
        private final int nrOfUnsortedContainers;
        private final int nrOfUnsortedPredecessors;
        private final int nrOfUnsortedWriters;
        private final double primaryCoordinate;
        private final double secondaryCoordinate;

        private static int getIndexOfLastSortedPredecessor(IPlanElementInfo element, List<IPlanElementInfo> sortedElements) {
            return Math.max(WeightedElementForFirstElement.getLastIndex(element.getContainers(), sortedElements), Math.max(WeightedElementForFirstElement.getLastIndex(element.getPredecessors(), sortedElements), WeightedElementForFirstElement.getLastIndex(element.getWriters(), sortedElements)));
        }

        private static int getLastIndex(Collection<? extends IPlanElementInfo> elementsToFind, List<IPlanElementInfo> baseElements) {
            int lastIndex = -1;
            for (IPlanElementInfo iPlanElementInfo : elementsToFind) {
                lastIndex = Math.max(lastIndex, baseElements.lastIndexOf(iPlanElementInfo));
            }
            return lastIndex;
        }

        private static int countContainedElements(Collection<? extends IPlanElementInfo> elements, Set<IPlanElementInfo> baseElements) {
            int nrOfContainedElements = 0;
            for (IPlanElementInfo iPlanElementInfo : elements) {
                if (!baseElements.contains(iPlanElementInfo)) continue;
                ++nrOfContainedElements;
            }
            return nrOfContainedElements;
        }

        private WeightedElementForFirstElement(IPlanElementInfo element, int index, boolean yIsPrimaryCoordinate, List<IPlanElementInfo> sortedElements, Set<IPlanElementInfo> unsortedElements) {
            this.element = element;
            this.index = index;
            this.indexOfLastSortedPredecessor = WeightedElementForFirstElement.getIndexOfLastSortedPredecessor(element, sortedElements);
            this.nrOfUnsortedContainers = WeightedElementForFirstElement.countContainedElements(element.getContainers(), unsortedElements);
            this.nrOfUnsortedPredecessors = WeightedElementForFirstElement.countContainedElements(element.getPredecessors(), unsortedElements);
            this.nrOfUnsortedWriters = WeightedElementForFirstElement.countContainedElements(element.getWriters(), unsortedElements);
            IRectangle pointUnionInMM = element.getPointUnionInMM();
            if (pointUnionInMM != null) {
                if (yIsPrimaryCoordinate) {
                    this.primaryCoordinate = pointUnionInMM.getY();
                    this.secondaryCoordinate = pointUnionInMM.getX() + pointUnionInMM.getW() / 2.0;
                } else {
                    this.primaryCoordinate = pointUnionInMM.getX();
                    this.secondaryCoordinate = pointUnionInMM.getY() + pointUnionInMM.getH() / 2.0;
                }
            } else {
                this.primaryCoordinate = 2.147483647E9;
                this.secondaryCoordinate = 2.147483647E9;
            }
        }

        public IPlanElementInfo getElement() {
            return this.element;
        }
    }
}

