/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import au.com.swz.swttocom.swt.types.IManagedAutomationObject;
import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.word.docbook2word.IWordDocumentationWriterTask;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.preferences.WordReportsPreferences;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Hyperlink;
import com.arcway.lib.eclipse.ole.word.Hyperlinks;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.eclipse.ole.word.util.WordXPCompatibility;
import java.util.Locale;

public class LinkWriter {
    private static LinkWriter writer;

    private LinkWriter() {
    }

    public static LinkWriter getInstance() {
        if (writer == null) {
            writer = new LinkWriter();
        }
        return writer;
    }

    public void construct() {
    }

    public void write(EOLink link, Range range, Document document, ProcessingContext processingContext) {
        String linkText = link.getContentAsString();
        boolean withPageNumber = WordReportsPreferences.getShowPageNumbersForReferences();
        int startIndexOfText = range.get_End();
        range.InsertAfter(linkText);
        int endIndexOfText = range.get_End();
        range.InsertAfter(" ");
        final String bookmarkName = "ID" + link.getLinkend();
        Range hyperlinkRange = range.get_Duplicate();
        hyperlinkRange.SetRange(startIndexOfText, endIndexOfText);
        Hyperlinks hyperlinks = hyperlinkRange.get_Hyperlinks();
        Hyperlink hyperlink = hyperlinks.Add((IManagedAutomationObject)hyperlinkRange, (Object)"", (Object)bookmarkName, (Object)"");
        hyperlink.dispose();
        hyperlinks.dispose();
        hyperlinkRange.dispose();
        if (withPageNumber) {
            range.InsertAfter("(");
            range.InsertAfter(String.valueOf(Messages.getString((String)"PageRef", (Locale)processingContext.getProjectLocale())) + " ");
            int startIndexOfPageNum = range.get_End();
            int endIndexOfPageNum = range.get_End();
            range.InsertAfter(")");
            final Range pageNumRange = range.get_Duplicate();
            pageNumRange.SetRange(startIndexOfPageNum, endIndexOfPageNum);
            processingContext.addPostProcessingTask(new IWordDocumentationWriterTask(){

                @Override
                public void run() {
                    try {
                        try {
                            WordXPCompatibility.Range_InsertCrossReference((Range)pageNumRange, (Object)2, (int)7, (Object)bookmarkName, (Object)Boolean.TRUE);
                        }
                        catch (Exception e) {
                            pageNumRange.set_Text("!!link target does not exist!!");
                            pageNumRange.get_Font().set_Color(255);
                            pageNumRange.dispose();
                        }
                    }
                    finally {
                        pageNumRange.dispose();
                    }
                }
            });
        }
    }
}

