/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import com.arcway.cockpit.docgen.writer.odt.dom.LengthParser;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleInfo;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleSrcFile;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PageLayoutStyleInfo
extends StyleInfo {
    public PageLayoutStyleInfo(String name, StyleSrcFile src_file, StyleType type, Element xmlDomElement) {
        super(name, src_file, type, xmlDomElement);
    }

    public static PageLayoutStyleInfo createPageStyleInfo(StyleSrcFile styleSrcFile, StyleType styleType, Element styleElement) {
        assert ("style:page-layout".equals(styleElement.getNodeName()));
        String style_name = styleElement.getAttribute("style:name");
        return new PageLayoutStyleInfo(style_name, styleSrcFile, styleType, styleElement);
    }

    public PageDimensions getPageDimensions() throws LengthParser.LengthParseException {
        NodeList layoutPropertiesElements = this.getXmlDomElement().getElementsByTagName("style:page-layout-properties");
        assert (layoutPropertiesElements.getLength() == 1);
        Element layoutPropertiesElement = (Element)layoutPropertiesElements.item(0);
        return new PageDimensions(LengthParser.parseLength(layoutPropertiesElement.getAttribute("fo:page-width")).getLengthInUnit(LengthParser.LengthUnit.MM), LengthParser.parseLength(layoutPropertiesElement.getAttribute("fo:page-height")).getLengthInUnit(LengthParser.LengthUnit.MM), LengthParser.parseLength(layoutPropertiesElement.getAttribute("fo:margin-top")).getLengthInUnit(LengthParser.LengthUnit.MM), LengthParser.parseLength(layoutPropertiesElement.getAttribute("fo:margin-bottom")).getLengthInUnit(LengthParser.LengthUnit.MM), LengthParser.parseLength(layoutPropertiesElement.getAttribute("fo:margin-left")).getLengthInUnit(LengthParser.LengthUnit.MM), LengthParser.parseLength(layoutPropertiesElement.getAttribute("fo:margin-right")).getLengthInUnit(LengthParser.LengthUnit.MM));
    }

    public static class PageDimensions {
        public final double pageWidth;
        public final double pageHeigth;
        public final double marginTop;
        public final double marginBottom;
        public final double marginLeft;
        public final double marginRight;

        private PageDimensions(double pageWidth, double pageHeigth, double marginTop, double marginBottom, double marginLeft, double marginRight) {
            this.pageWidth = pageWidth;
            this.pageHeigth = pageHeigth;
            this.marginTop = marginTop;
            this.marginBottom = marginBottom;
            this.marginLeft = marginLeft;
            this.marginRight = marginRight;
        }

        public double getPageWidthWithoutMargins() {
            return this.pageWidth - (this.marginLeft + this.marginRight);
        }

        public double getPageHeightWithoutMargins() {
            return this.pageHeigth - (this.marginBottom + this.marginTop);
        }
    }
}

