/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.TableRowType;
import com.arcway.cockpit.docgen.writer.odt.dom.MultiPurposeStyleInfo;
import com.arcway.cockpit.docgen.writer.odt.dom.StyleFamily;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MasterTableStyleInfo {
    private final String tableName;
    private final MultiPurposeStyleInfo table_styleInfo;
    private final MultiPurposeStyleInfo column_styleInfo;
    private final MultiPurposeStyleInfo headingRow_styleInfo;
    private final MultiPurposeStyleInfo bodyRow_styleInfo;
    private final MultiPurposeStyleInfo headingRowCell_styleInfo;
    private final MultiPurposeStyleInfo bodyRowCell_styleInfo;

    public MasterTableStyleInfo(Element tableElement, StyleMap styleMap) {
        this.tableName = tableElement.getAttribute("table:name");
        String table_styleName = tableElement.getAttribute("table:style-name");
        this.table_styleInfo = styleMap.findStyleByName(table_styleName, StyleFamily.TABLE);
        NodeList tableColumnElements = tableElement.getElementsByTagName("table:table-column");
        assert (tableColumnElements.getLength() == 2);
        Element column_Element = (Element)tableColumnElements.item(0);
        String column_styleName = column_Element.getAttribute("table:style-name");
        this.column_styleInfo = styleMap.findStyleByName(column_styleName, StyleFamily.TABLE_COLUMN);
        NodeList tableRowElements = tableElement.getElementsByTagName("table:table-row");
        assert (tableRowElements.getLength() == 2);
        Element headingRow_Element = (Element)tableRowElements.item(0);
        String headingRow_styleName = headingRow_Element.getAttribute("table:style-name");
        this.headingRow_styleInfo = styleMap.findStyleByName(headingRow_styleName, StyleFamily.TABLE_ROW);
        Element bodyRow_Element = (Element)tableRowElements.item(1);
        String bodyRow_styleName = bodyRow_Element.getAttribute("table:style-name");
        this.bodyRow_styleInfo = styleMap.findStyleByName(bodyRow_styleName, StyleFamily.TABLE_ROW);
        NodeList headingRowCellElements = headingRow_Element.getElementsByTagName("table:table-cell");
        assert (headingRowCellElements.getLength() > 0);
        Element headingRowCell_Element = (Element)headingRowCellElements.item(0);
        String headingRowCell_styleName = headingRowCell_Element.getAttribute("table:style-name");
        this.headingRowCell_styleInfo = styleMap.findStyleByName(headingRowCell_styleName, StyleFamily.TABLE_CELL);
        NodeList bodyRowCellElements = bodyRow_Element.getElementsByTagName("table:table-cell");
        assert (bodyRowCellElements.getLength() > 0);
        Element bodyRowCell_Element = (Element)bodyRowCellElements.item(0);
        String bodyRowCell_styleName = bodyRowCell_Element.getAttribute("table:style-name");
        this.bodyRowCell_styleInfo = styleMap.findStyleByName(bodyRowCell_styleName, StyleFamily.TABLE_CELL);
    }

    public String getTableName() {
        return this.tableName;
    }

    public MultiPurposeStyleInfo getTable_styleInfo() {
        return this.table_styleInfo;
    }

    public MultiPurposeStyleInfo getColumn_styleInfo() {
        return this.column_styleInfo;
    }

    public MultiPurposeStyleInfo getRow_styleInfo(TableRowType rowType) {
        switch (rowType) {
            case HEADER_ROW: {
                return this.headingRow_styleInfo;
            }
            case BODY_ROW: {
                return this.bodyRow_styleInfo;
            }
        }
        assert (false);
        return null;
    }

    public MultiPurposeStyleInfo getCell_styleInfo(TableRowType rowType) {
        switch (rowType) {
            case HEADER_ROW: {
                return this.headingRowCell_styleInfo;
            }
            case BODY_ROW: {
                return this.bodyRowCell_styleInfo;
            }
        }
        assert (false);
        return null;
    }
}

