/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import com.arcway.cockpit.docgen.writer.odt.StyleMap;
import com.arcway.cockpit.docgen.writer.odt.dom.ChapterWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.IParagraphParent;
import com.arcway.cockpit.docgen.writer.odt.dom.OXTReader;
import com.arcway.cockpit.docgen.writer.odt.dom.ParagraphWrapper;
import com.arcway.cockpit.docgen.writer.odt.dom.TemplateContent;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BodyNodeWrapper
implements IParagraphParent {
    private final String STYLE_NAME_StyleTemplatesSeparator = "StyleTemplatesSeparator";
    private OXTReader reader = null;
    private final StyleMap styleMap;
    private Element bodyText = null;

    public BodyNodeWrapper(OXTReader reader, StyleMap styleMap) {
        assert (reader != null) : "OXTReader reader must not be null";
        this.reader = reader;
        this.styleMap = styleMap;
        Document doc = reader.getDocument();
        NodeList nl = doc.getElementsByTagName("office:body");
        assert (nl.getLength() == 1);
        Node body = nl.item(0);
        NodeList bodyChilds = body.getChildNodes();
        assert (bodyChilds.getLength() == 1);
        this.bodyText = (Element)bodyChilds.item(0);
    }

    public TemplateContent getTemplateContent() {
        ArrayList<Node> documentNucleus = new ArrayList<Node>();
        ArrayList<Element> templateMasterTables = new ArrayList<Element>();
        NodeList potentialContent = this.bodyText.getChildNodes();
        while (potentialContent.getLength() > 0) {
            Node potentialContentItem = potentialContent.item(0);
            if (potentialContent instanceof Element && "StyleTemplatesSeparator".equals(((Element)potentialContentItem).getAttribute("text:style-name"))) break;
            documentNucleus.add(potentialContentItem.cloneNode(true));
            this.bodyText.removeChild(potentialContentItem);
        }
        NodeList tableElements = this.bodyText.getElementsByTagName("table:table");
        int i = 0;
        while (i < tableElements.getLength()) {
            templateMasterTables.add((Element)tableElements.item(i));
            ++i;
        }
        potentialContent = this.bodyText.getChildNodes();
        while (potentialContent.getLength() > 0) {
            this.bodyText.removeChild(potentialContent.item(0));
        }
        return new TemplateContent(documentNucleus, templateMasterTables);
    }

    public void appendTemplateContent(Collection<Node> additionalContent) {
        for (Node node : additionalContent) {
            this.bodyText.appendChild(node);
        }
    }

    public ChapterWrapper addChapter() {
        if (this.bodyText != null) {
            return new ChapterWrapper(this.reader.getDocument(), this.bodyText, this.reader.getProjectLocale(), this.styleMap);
        }
        return null;
    }

    @Override
    public ParagraphWrapper addParagraph() {
        ParagraphWrapper p = new ParagraphWrapper(this.reader.getDocument(), this.bodyText, this.reader.getProjectLocale(), this.styleMap);
        return p;
    }

    @Override
    public ParagraphWrapper addParagraph(String style) {
        ParagraphWrapper p = new ParagraphWrapper(this.reader.getDocument(), this.bodyText, style, this.styleMap, this.reader.getProjectLocale());
        return p;
    }
}

