/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.gui;

import com.arcway.cockpit.cockpitlib.client.gui.IRefreshableDisplay;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Iterator;
import java.util.LinkedList;

public class DeferredRefresher
extends Thread {
    private static final ILogger logger = Logger.getLogger(DeferredRefresher.class);
    private final long refreshDelayTime;
    private boolean mustRefresh = false;
    private boolean haltRequestQueued = false;
    private IRefreshableDisplay refreshable = null;
    private final LinkedList<InputEvent> eventQueue = new LinkedList();
    private final RefreshOrder refreshOrder = new RefreshOrder();
    private final NoOP noOP = new NoOP();
    private final QueueRefreshOrder queueRefreshOrder = new QueueRefreshOrder();
    private final CancelQueuedRefreshOrder cancelQueuedRefreshOrder = new CancelQueuedRefreshOrder();

    public DeferredRefresher(IRefreshableDisplay refreshable) {
        this(refreshable, 100L);
    }

    public DeferredRefresher(IRefreshableDisplay refreshable, long refreshTime) {
        this(refreshable, refreshTime, "Refresher for " + refreshable.getClass().getName());
    }

    public DeferredRefresher(IRefreshableDisplay refreshable, long refreshTime, String name) {
        assert (refreshable != null);
        assert (refreshTime > 0L);
        this.setDaemon(true);
        this.setName(name);
        this.refreshable = refreshable;
        this.refreshDelayTime = refreshTime;
    }

    private boolean synchronousRefreshNotificationQueued() {
        for (InputEvent inputEvent : this.eventQueue) {
            if (!(inputEvent instanceof SynchronousRefreshExecuted)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AsynchronousRefreshRequest lastReceivedAsynchronousRefreshRequest = null;
        while (true) {
            Runnable nextStep = null;
            DeferredRefresher deferredRefresher = this;
            synchronized (deferredRefresher) {
                if (this.eventQueue.isEmpty()) {
                    if (this.mustRefresh) {
                        assert (lastReceivedAsynchronousRefreshRequest != null);
                        long remainingWaitTime = lastReceivedAsynchronousRefreshRequest.timestamp + this.refreshDelayTime - System.currentTimeMillis();
                        if (remainingWaitTime > 0L) {
                            try {
                                this.wait(remainingWaitTime);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            nextStep = this.noOP;
                        } else {
                            this.mustRefresh = false;
                            nextStep = this.queueRefreshOrder;
                        }
                    } else {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException remainingWaitTime) {
                            // empty catch block
                        }
                        nextStep = this.noOP;
                    }
                } else {
                    if (this.haltRequestQueued) {
                        this.eventQueue.clear();
                        break;
                    }
                    if (this.synchronousRefreshNotificationQueued()) {
                        while (this.synchronousRefreshNotificationQueued()) {
                            boolean firstSynchronousRefreshNotificationDeleted = false;
                            Iterator eventQueueIt = this.eventQueue.iterator();
                            while (eventQueueIt.hasNext() && !firstSynchronousRefreshNotificationDeleted) {
                                if (eventQueueIt.next() instanceof SynchronousRefreshExecuted) {
                                    firstSynchronousRefreshNotificationDeleted = true;
                                }
                                eventQueueIt.remove();
                            }
                        }
                        nextStep = this.cancelQueuedRefreshOrder;
                    } else {
                        lastReceivedAsynchronousRefreshRequest = (AsynchronousRefreshRequest)this.eventQueue.getLast();
                        this.mustRefresh = true;
                        this.eventQueue.clear();
                        nextStep = this.cancelQueuedRefreshOrder;
                    }
                }
            }
            nextStep.run();
        }
    }

    public synchronized void scheduleDeferredRefresh() {
        this.mustRefresh = true;
        if (!this.haltRequestQueued) {
            this.eventQueue.add(new AsynchronousRefreshRequest());
            this.notify();
        }
    }

    public synchronized void executePendingRefreshNow() {
        if (this.mustRefresh) {
            this.refreshable.refresh();
            this.mustRefresh = false;
            if (!this.haltRequestQueued) {
                this.eventQueue.add(new SynchronousRefreshExecuted());
                this.notify();
            }
        }
    }

    public synchronized void halt() {
        if (!this.haltRequestQueued) {
            this.haltRequestQueued = true;
            this.eventQueue.add(new Halt());
            this.notify();
        }
    }

    private static class AsynchronousRefreshRequest
    implements InputEvent {
        public long timestamp = System.currentTimeMillis();

        private AsynchronousRefreshRequest() {
        }
    }

    private class CancelQueuedRefreshOrder
    implements Runnable {
        private CancelQueuedRefreshOrder() {
        }

        @Override
        public void run() {
            DeferredRefresher.this.refreshOrder.cancelQueuedRefreshOrder();
        }
    }

    private static class Halt
    implements InputEvent {
        private Halt() {
        }
    }

    private static interface InputEvent {
    }

    private static class NoOP
    implements Runnable {
        private NoOP() {
        }

        @Override
        public void run() {
        }
    }

    private class QueueRefreshOrder
    implements Runnable {
        private QueueRefreshOrder() {
        }

        @Override
        public void run() {
            DeferredRefresher.this.refreshOrder.queueRefreshOrder();
        }
    }

    private class RefreshOrder
    implements Runnable {
        private boolean isQueuedInEventLoop = false;
        private boolean isCanceled = false;

        private RefreshOrder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueRefreshOrder() {
            boolean newEnqueueNeeded = false;
            RefreshOrder refreshOrder = this;
            synchronized (refreshOrder) {
                this.isCanceled = false;
                if (!this.isQueuedInEventLoop && !DeferredRefresher.this.refreshable.isDisposed()) {
                    newEnqueueNeeded = true;
                    this.isQueuedInEventLoop = true;
                }
            }
            if (newEnqueueNeeded) {
                DeferredRefresher.this.refreshable.getDisplay().asyncExec((Runnable)this);
            }
        }

        public synchronized void cancelQueuedRefreshOrder() {
            this.isCanceled = true;
        }

        @Override
        public synchronized void run() {
            this.isQueuedInEventLoop = false;
            if (!this.isCanceled && !DeferredRefresher.this.refreshable.isDisposed()) {
                try {
                    DeferredRefresher.this.refreshable.refresh();
                }
                catch (Throwable t) {
                    logger.error("Exception occured while performing GUI-refresh actions in the eventloop/main tread.", t);
                }
            }
        }
    }

    private static class SynchronousRefreshExecuted
    implements InputEvent {
        private SynchronousRefreshExecuted() {
        }
    }
}

