/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractDurationFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.LongWrapper;
import com.arcway.cockpit.cockpitlib.client.filter.gui.Messages;
import de.plans.lib.util.LongVerifyListener;
import de.plans.lib.util.NumberVerifyListener;
import de.plans.lib.util.valueranges.ILong;
import de.plans.lib.util.valueranges.ValueRangeHelperDuration;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DurationFilterItem
extends AbstractFilterItem {
    private final AbstractDurationFilter filter;
    private final LongWrapper firstDuration = new LongWrapper(new Long(0L));
    private final LongWrapper secondDuration = new LongWrapper(new Long(0L));
    private String filterMethod = FILTER_METHOD_ORDER[0];
    private final int unit;
    private final ValueRangeHelperDuration valueRangeHelperFirstDuration;
    private final ValueRangeHelperDuration valueRangeHelperSecondDuration;
    private Combo filterMethodCombo;
    private Text duration1Text;
    private Text duration2Text;
    private Label duration2Label;
    private static final String[] FILTER_METHOD_ORDER = new String[]{"filtermethod-greater", "filtermethod-less", "filtermethod-between", "filtermethod-equal"};
    private static final String METHOD_NAME_GREATER = ">=";
    private static final String METHOD_NAME_LESS = "<=";
    private static final String METHOD_NAME_BETWEEN = Messages.getString("DurationFilterItem.FilterMethodBetween");
    private static final String METHOD_NAME_EQUALS = "=";
    private static final String[] FILTER_METHOD_NAMES = new String[]{">=", "<=", METHOD_NAME_BETWEEN, "="};

    public DurationFilterItem(String name, AbstractDurationFilter filter, int unit) {
        super(name, filter);
        this.filter = filter;
        filter.setUnit(unit);
        this.unit = unit;
        this.valueRangeHelperFirstDuration = new ValueRangeHelperDuration(unit, (ILong)this.firstDuration);
        this.valueRangeHelperSecondDuration = new ValueRangeHelperDuration(unit, (ILong)this.secondDuration);
        this.readSettingsFromFilter();
    }

    @Override
    public void doConfirmSelection() {
        this.writeSettingsToFilter();
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.readSettingsFromFilter();
    }

    @Override
    public void refresh() {
        this.filterMethodCombo.select(this.getFilterMethodIndex(this.filterMethod));
        this.duration1Text.setText(this.valueRangeHelperFirstDuration.getDisplayFormat());
        this.duration2Text.setText(this.valueRangeHelperSecondDuration.getDisplayFormat());
        this.updateSecondValueTextFieldVisibility();
    }

    @Override
    public void filterHasChanged() {
        this.readSettingsFromFilter();
    }

    @Override
    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        String filterMethodName = FILTER_METHOD_NAMES[this.getFilterMethodIndex(this.filterMethod)];
        String filterInfo = String.valueOf(filterMethodName) + " " + this.valueRangeHelperFirstDuration.getDisplayFormatWithUnit();
        if (this.filterMethod.equals("filtermethod-between")) {
            filterInfo = String.valueOf(filterInfo) + " " + Messages.getString("DurationFilterItem.AND") + " " + this.valueRangeHelperSecondDuration.getDisplayFormatWithUnit();
        }
        return filterInfo;
    }

    @Override
    public Control createContent(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(4, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        groupGD.widthHint = 200;
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        this.filterMethodCombo = new Combo((Composite)group, 12);
        GridData filterMethodComboGD = new GridData();
        filterMethodComboGD.widthHint = 50;
        this.filterMethodCombo.setLayoutData((Object)filterMethodComboGD);
        String[] stringArray = FILTER_METHOD_NAMES;
        int n = FILTER_METHOD_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.filterMethodCombo.add(element);
            ++n2;
        }
        this.filterMethodCombo.select(0);
        this.filterMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DurationFilterItem.this.updateSecondValueTextFieldVisibility();
                DurationFilterItem.this.updateFilter();
                DurationFilterItem.this.fireValueChanged();
            }
        });
        this.duration1Text = new Text((Composite)group, 2052);
        GridData firstDateTextGD = new GridData();
        firstDateTextGD.widthHint = 75;
        this.duration1Text.setLayoutData((Object)firstDateTextGD);
        this.duration1Text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DurationFilterItem.this.duration1Text.selectAll();
            }

            public void focusLost(FocusEvent e) {
                DurationFilterItem.this.updateFilter();
                DurationFilterItem.this.fireValueChanged();
            }
        });
        this.duration1Text.addVerifyListener((VerifyListener)this.createVerifyListener(this.duration1Text));
        Label duration1Label = new Label((Composite)group, 0);
        GridData firstDurationLabelGD = new GridData();
        firstDurationLabelGD.widthHint = 20;
        duration1Label.setLayoutData((Object)firstDurationLabelGD);
        duration1Label.setText(ValueRangeHelperDuration.getDisplayFormatForUnit((int)this.unit));
        this.duration2Text = new Text((Composite)group, 2052);
        GridData secondDateTextGD = new GridData();
        secondDateTextGD.widthHint = 75;
        secondDateTextGD.horizontalSpan = 2;
        secondDateTextGD.horizontalAlignment = 3;
        this.duration2Text.setLayoutData((Object)secondDateTextGD);
        this.duration2Text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DurationFilterItem.this.duration2Text.selectAll();
            }

            public void focusLost(FocusEvent e) {
                DurationFilterItem.this.updateFilter();
                DurationFilterItem.this.fireValueChanged();
            }
        });
        this.duration2Text.addVerifyListener((VerifyListener)this.createVerifyListener(this.duration2Text));
        this.duration2Label = new Label((Composite)group, 0);
        GridData secondDurationLabelGD = new GridData();
        secondDurationLabelGD.widthHint = 20;
        this.duration2Label.setLayoutData((Object)secondDurationLabelGD);
        this.duration2Label.setText(ValueRangeHelperDuration.getDisplayFormatForUnit((int)this.unit));
        this.refresh();
        return group;
    }

    private void updateFilter() {
        this.setSelected(this.isAllFilterValuesSet());
        try {
            this.valueRangeHelperFirstDuration.setPersistentValue(this.duration1Text.getText());
            if (this.duration2Text.isVisible()) {
                this.valueRangeHelperSecondDuration.setPersistentValue(this.duration2Text.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.filterMethod = FILTER_METHOD_ORDER[this.filterMethodCombo.getSelectionIndex()];
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public boolean isAllFilterValuesSet() {
        return !this.isNoFilterValuesSet();
    }

    @Override
    public boolean isNoFilterValuesSet() {
        return this.duration1Text.getText().length() == 0 || this.filterMethodCombo.getText().equals(METHOD_NAME_BETWEEN) && this.duration2Text.getText().length() == 0;
    }

    private void updateSecondValueTextFieldVisibility() {
        boolean shallBeVisible = this.filterMethodCombo.getText().equals(METHOD_NAME_BETWEEN);
        this.duration2Text.setVisible(shallBeVisible);
        this.duration2Label.setVisible(shallBeVisible);
    }

    private void readSettingsFromFilter() {
        this.firstDuration.setValue(new Long(this.filter.getFirstDuration()));
        this.secondDuration.setValue(new Long(this.filter.getSecondDuration()));
        this.filterMethod = this.filter.getFilterMethod();
    }

    private void writeSettingsToFilter() {
        this.filter.setFirstDuration(this.firstDuration.getValue());
        this.filter.setSecondDuration(this.secondDuration.getValue());
        this.filter.setFilterMethod(this.filterMethod);
        this.filter.setUnit(this.unit);
    }

    private NumberVerifyListener createVerifyListener(Text textField) {
        return new LongVerifyListener(textField, true);
    }

    private int getFilterMethodIndex(String filterMethod_) {
        int c = 0;
        while (c < FILTER_METHOD_ORDER.length) {
            if (FILTER_METHOD_ORDER[c].equals(filterMethod_)) {
                return c;
            }
            ++c;
        }
        return -1;
    }
}

