/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractIntegerValuesFilter
extends AbstractFilter {
    private final Set<Integer> passValues = new HashSet<Integer>();
    private static final char SEMICOLON = ';';

    @Override
    public boolean doesItemPassFilter(Viewer viewer, Object parentElement, Object element) {
        return this.doesItemPassFilter(element);
    }

    public boolean doesItemPassFilter(Object element) {
        Integer value = new Integer(this.getIntegerAttribute(element));
        return this.passesFilter(value);
    }

    protected boolean passesFilter(Integer value) {
        return this.passValues.contains(value);
    }

    public void initWithSemicolonSeparatedString(String valueString) {
        if (valueString != null && valueString.length() > 0) {
            ArrayList values = StringUtil.split((String)valueString, (char)';');
            this.passValues.clear();
            for (String element : values) {
                this.passValues.add(Integer.valueOf(element));
            }
        } else {
            this.passValues.clear();
        }
    }

    public String getValuesAsSemicolonSeparatedString() {
        if (this.passValues.isEmpty()) {
            return "";
        }
        StringBuilder valueString = new StringBuilder();
        for (Integer value : this.passValues) {
            if (valueString.length() > 0) {
                valueString.append(';');
            }
            valueString.append(String.valueOf(value));
        }
        return valueString.toString();
    }

    public void setPassValues(Collection<Integer> values) {
        this.passValues.clear();
        if (values != null) {
            this.passValues.addAll(values);
        }
    }

    public List<Integer> getPassValues() {
        return new ArrayList<Integer>(this.passValues);
    }

    protected abstract int getIntegerAttribute(Object var1);

    @Override
    public String getFilterValue() {
        return this.getValuesAsSemicolonSeparatedString();
    }

    @Override
    public void setFilterValue(String value) {
        this.initWithSemicolonSeparatedString(value);
        super.setFilterValue(value);
    }

    @Override
    public void resetValue() {
        this.setFilterValue("");
    }
}

