/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.LongWrapper;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.valueranges.ILong;
import de.plans.lib.util.valueranges.ValueRangeHelperDuration;
import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractDurationFilter
extends AbstractFilter {
    public static final String FILTER_METHOD_GREATER = "filtermethod-greater";
    public static final String FILTER_METHOD_LESS = "filtermethod-less";
    public static final String FILTER_METHOD_BETWEEN = "filtermethod-between";
    public static final String FILTER_METHOD_EQUALS = "filtermethod-equal";
    private static final char SEPARATOR = ':';
    private LongWrapper firstDuration;
    private LongWrapper secondDuration;
    private int unit;
    private String filterMethod;

    public AbstractDurationFilter() {
        this.resetValue();
    }

    @Override
    public String getFilterValue() {
        return String.valueOf(this.filterMethod) + ':' + this.unit + ':' + this.firstDuration.getValue() + ':' + this.secondDuration.getValue();
    }

    @Override
    public void setFilterValue(String value) {
        try {
            ArrayList parts = StringUtil.split((String)value, (char)':', (int)-1);
            this.filterMethod = (String)parts.get(0);
            this.unit = Integer.parseInt((String)parts.get(1));
            this.firstDuration.setValue(new Long(Long.parseLong((String)parts.get(1))));
            this.secondDuration.setValue(new Long(Long.parseLong((String)parts.get(2))));
        }
        catch (NumberFormatException nfE) {
            this.resetValue();
        }
        catch (ArrayIndexOutOfBoundsException aioobE) {
            this.resetValue();
        }
        super.setFilterValue(value);
    }

    @Override
    public void resetValue() {
        this.filterMethod = FILTER_METHOD_GREATER;
        this.firstDuration = new LongWrapper(new Long(0L));
        this.secondDuration = new LongWrapper(new Long(0L));
    }

    @Override
    public boolean doesItemPassFilter(Viewer viewer, Object parentElement, Object element) {
        long objectsValue = this.getDurationAttribute(element);
        ValueRangeHelperDuration valueRangeHelperObjectsDuration = new ValueRangeHelperDuration(this.unit, (ILong)new LongWrapper(new Long(objectsValue)));
        long objectsDurationValue = valueRangeHelperObjectsDuration.getDurationAsValue();
        ValueRangeHelperDuration valueRangeHelperFirstDuration = new ValueRangeHelperDuration(this.unit, (ILong)this.firstDuration);
        long firstDurationValue = valueRangeHelperFirstDuration.getDurationAsValue();
        ValueRangeHelperDuration valueRangeHelperSecondDuration = new ValueRangeHelperDuration(this.unit, (ILong)this.secondDuration);
        long secondDurationValue = valueRangeHelperSecondDuration.getDurationAsValue();
        if (this.filterMethod.equals(FILTER_METHOD_GREATER)) {
            return objectsDurationValue >= firstDurationValue;
        }
        if (this.filterMethod.equals(FILTER_METHOD_LESS)) {
            return objectsDurationValue <= firstDurationValue;
        }
        if (this.filterMethod.equals(FILTER_METHOD_BETWEEN)) {
            return objectsDurationValue >= firstDurationValue && objectsDurationValue <= secondDurationValue;
        }
        if (this.filterMethod.equals(FILTER_METHOD_EQUALS)) {
            return objectsDurationValue == firstDurationValue;
        }
        return true;
    }

    public long getFirstDuration() {
        return this.firstDuration.getValue();
    }

    public long getSecondDuration() {
        return this.secondDuration.getValue();
    }

    public int getUnit() {
        return this.unit;
    }

    public String getFilterMethod() {
        return this.filterMethod;
    }

    public void setFirstDuration(long value) {
        this.firstDuration.setValue(new Long(value));
    }

    public void setSecondDuration(long value) {
        this.secondDuration.setValue(new Long(value));
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public void setFilterMethod(String method) {
        this.filterMethod = method;
    }

    protected abstract long getDurationAttribute(Object var1);
}

