/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.client.base.interfaces.frame.datamanagement;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.frame.shared.message.EOObjectTypeCategoryID;
import com.arcway.lib.UUIDGenerator;
import java.util.HashMap;

public class ObjectTypeCategoryID {
    private static final HashMap<String, ObjectTypeCategoryID> objectTypeCategoryIDCache = new HashMap(50, 0.5f);
    private final String uID;
    private final int cachedHashcode;

    public static ObjectTypeCategoryID createObjectTypeCategoryID() {
        return ObjectTypeCategoryID.getObjectTypeCategoryID(UUIDGenerator.getUniqueID());
    }

    public static ObjectTypeCategoryID getObjectTypeCategoryID(EOObjectTypeCategoryID eoObjectTypeCategoryID) {
        if (eoObjectTypeCategoryID != null) {
            return ObjectTypeCategoryID.getObjectTypeCategoryID(eoObjectTypeCategoryID.getObjectTypeCategoryID());
        }
        return null;
    }

    public static synchronized ObjectTypeCategoryID getObjectTypeCategoryID(String uID) {
        ObjectTypeCategoryID objectTypeCategoryID = objectTypeCategoryIDCache.get(uID);
        if (objectTypeCategoryID == null) {
            objectTypeCategoryID = new ObjectTypeCategoryID(uID);
            objectTypeCategoryIDCache.put(uID, objectTypeCategoryID);
        }
        return objectTypeCategoryID;
    }

    private ObjectTypeCategoryID(String uID) {
        this.uID = uID;
        this.cachedHashcode = this.uID.hashCode();
    }

    public String getUID() {
        return this.uID;
    }

    public EOObjectTypeCategoryID createEncodableObject() {
        return new EOObjectTypeCategoryID(this.uID);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            if (obj instanceof IAttributeTypeID) {
                IAttributeTypeID attributeTypeID = (IAttributeTypeID)obj;
                return attributeTypeID.getUID().equals(this.getUID());
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.cachedHashcode;
    }
}

