/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.lock;

import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryIDLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;

public class RepositoryIDLockSample
extends AbstractRepositoryIDLockSample {
    private final IRepositoryObjectTypeID objectTypeID;
    private final IRepositoryPropertyTypeID propertyTypeID;
    private final IRepositoryPropertySample sampleID;
    private final IRepositoryObjectTypeID contextObjectTypeID;
    private final IRepositoryPropertySetSample contextObjectID;
    private final IRepositoryPropertySetSample snapshotID;

    public RepositoryIDLockSample(IRepositoryObjectTypeID objectTypeID, IRepositoryPropertyTypeID propertyTypeID, IRepositoryPropertySample sampleID, IRepositoryObjectTypeID contextObjectTypeID, IRepositoryPropertySetSample contextObjectID, IRepositoryPropertySetSample snapshotID) {
        this.objectTypeID = objectTypeID;
        this.propertyTypeID = propertyTypeID;
        this.sampleID = sampleID;
        this.contextObjectTypeID = contextObjectTypeID;
        this.contextObjectID = contextObjectID;
        this.snapshotID = snapshotID;
    }

    private RepositoryIDLockSample(IRepositoryProperty property) throws EXNotReproducibleSnapshot {
        IRepositoryObject contextObject;
        assert (property != null);
        assert (property.getPropertyType().getIDType().isID() || property.getPropertyType().getIDType().isName());
        IRepositoryObject containingObject = property.getAttributeSet().getObject();
        IRepositoryObjectType containingObjectType = containingObject.getObjectType();
        this.objectTypeID = containingObjectType.getRepositoryObjectTypeID();
        IRepositoryPropertyType propertyType = property.getPropertyType();
        IRepositorySnapshotRO snapshot = property.getSnapshot();
        if (propertyType.getIDType().isID()) {
            contextObject = snapshot.getRepositoryRootObject();
        } else {
            assert (propertyType.getIDType().isName());
            IRepositoryAttributeSet parentAS = containingObject.getParentAttributeSet();
            contextObject = parentAS == null ? containingObject : parentAS.getObject();
        }
        IRepositoryObjectType contextObjectType = contextObject.getObjectType();
        this.contextObjectID = contextObject.getAttributeSet(contextObjectType.getIDAttributeSetType()).sample();
        this.contextObjectTypeID = contextObjectType.getRepositoryObjectTypeID();
        this.sampleID = property.sample();
        this.propertyTypeID = propertyType.getRepositoryPropertyTypeID();
        this.snapshotID = containingObject.getSnapshotIDOfLastIDModification(propertyType, this.sampleID);
        assert (this.objectTypeID != null && this.contextObjectID != null && this.contextObjectTypeID != null && this.sampleID != null && this.propertyTypeID != null);
    }

    public IRepositoryPropertySetSample getContextObjectID() {
        return this.contextObjectID;
    }

    public IRepositoryObjectTypeID getContextObjectTypeID() {
        return this.contextObjectTypeID;
    }

    public IRepositoryPropertySample getID() {
        return this.sampleID;
    }

    public IRepositoryObjectTypeID getObjectTypeID() {
        return this.objectTypeID;
    }

    public IRepositoryPropertyTypeID getPropertyTypeID() {
        return this.propertyTypeID;
    }

    public IRepositoryPropertySetSample getBasedSnapshotID() {
        return this.snapshotID;
    }

    public static AbstractRepositoryIDLockSample createLock(IRepositoryProperty propertyToLock) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)propertyToLock);
        Assert.checkArgument((!propertyToLock.getPropertyType().getIDType().isNotAnID() ? 1 : 0) != 0);
        return new RepositoryIDLockSample(propertyToLock);
    }
}

