/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.stringtools.StringUtil;

public class UserReference {
    public static final String DIRECTORYTYPE_STANDALONE = "Standalone";
    public static final String DIRECTORYTYPE_LDAP = "LDAP";
    public static final String DIRECTORYTYPE_PSCSERVER = "PSC-Server";
    private final String directoryType;
    private final String directoryNameOrURL;
    private final String distinguishedName;
    private final String loginID;
    private final String realName;
    private final String compareString;
    private final int hashCodeOfCompareString;

    public static final UserReference createStandaloneUser(String realName) {
        String allowedCharachters = "abcdefghijklmnopqrstuvwxyz0123456789.-_";
        char replaceChar = '.';
        String distinguishedName = StringUtil.reduceToAllowedCharacters((String)realName, (String)allowedCharachters, (String)allowedCharachters, (char)replaceChar);
        return new UserReference(DIRECTORYTYPE_STANDALONE, null, distinguishedName, null, realName);
    }

    public static final UserReference createLDAPUser(String ldapDirectoryNameOrURL, String distinguishedName, String loginID, String realName) {
        return new UserReference(DIRECTORYTYPE_LDAP, ldapDirectoryNameOrURL, distinguishedName, loginID, realName);
    }

    public static final UserReference createPSCUser(String pscServerURL, String loginID, String realName) {
        return new UserReference(DIRECTORYTYPE_PSCSERVER, pscServerURL, loginID, loginID, realName);
    }

    public UserReference(String directoryType, String directoryNameOrURL, String distinguishedName, String loginID, String realName) {
        Assert.checkArgumentBeeingNotNull((Object)directoryType);
        Assert.checkArgumentBeeingNotNull((Object)distinguishedName);
        this.directoryType = directoryType;
        this.directoryNameOrURL = directoryNameOrURL;
        this.distinguishedName = distinguishedName;
        this.loginID = loginID;
        this.realName = realName;
        this.compareString = StringUtil.createCanonicalStringConcatenation((String[])new String[]{directoryType, directoryNameOrURL, distinguishedName});
        this.hashCodeOfCompareString = this.compareString.hashCode();
    }

    public String getDirectoryType() {
        return this.directoryType;
    }

    public String getDirectoryNameOrURL() {
        return this.directoryNameOrURL;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    public String getLoginID() {
        return this.loginID;
    }

    public String getRealName() {
        return this.realName;
    }

    String getCompareString() {
        return this.compareString;
    }

    int getHashCodeOfCompareString() {
        return this.hashCodeOfCompareString;
    }

    public String toString() {
        return To.makeNotNull((Object)this.distinguishedName) + "@" + To.makeNotNull((Object)this.directoryType) + ":" + To.makeNotNull((Object)this.directoryNameOrURL);
    }
}

