/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.java.To;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.prefixidformat.DTPrefixIDFormat;
import com.arcway.repository.interFace.prefixidformat.PrefixIDFormat;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.lib.high.declaration.type.IARCWAYPlatformNameSpace;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeID;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;

public class RDTPrefixIDFormat
extends AbstractRepositoryDataType
implements IARCWAYPlatformNameSpace {
    public static final RepositoryDataTypeID DATA_TYPE_ID = new RepositoryDataTypeID(ARCWAY_PLATFORM_NAMESPACE, new KeySegment("idprefix"));
    private static RDTPrefixIDFormat singleton;
    private final Comparator comparator = new Comparator();

    private RDTPrefixIDFormat() {
    }

    public static RDTPrefixIDFormat getInstance() {
        if (singleton == null) {
            singleton = new RDTPrefixIDFormat();
        }
        return singleton;
    }

    @Override
    public IRepositoryDataTypeID getRepositoryDataTypeID() {
        return DATA_TYPE_ID;
    }

    @Override
    public IRepositoryDataEqualComparator getEqualComparator() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataHasher getHasher() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataOrderComparator getOrderComparator() {
        return this.comparator;
    }

    @Override
    public Class<? extends IRepositoryDataTypeParameters> getRepositoryDataTypeParemtersType() {
        return PrefixIDFormatParameters.class;
    }

    public PrefixIDFormat dataToValue(IRepositoryData repositoryData) {
        Data typedData = (Data)repositoryData;
        assert (typedData.getDataType() == this);
        return typedData.getValue();
    }

    @Override
    public IRepositoryData createDefaultValue(IRepositoryDataTypeParameters parameters) {
        return this.createData(null);
    }

    public IRepositoryData createData(PrefixIDFormat value) {
        return new Data(value);
    }

    @Override
    public void snapData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) {
    }

    @Override
    public void snapAndCheckData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        PrefixIDFormatParameters typedParameters = (PrefixIDFormatParameters)parameters;
        typedData.checkData(typedParameters);
    }

    @Override
    public void checkData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        PrefixIDFormatParameters typedParameters = (PrefixIDFormatParameters)parameters;
        typedData.checkData(typedParameters);
    }

    @Override
    public IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        return new DataType(dataTypeParameters, withPortableLoading);
    }

    private class Comparator
    extends AbstractRepositoryDataType.AbstractHasher
    implements IRepositoryDataOrderComparator {
        private Comparator() {
        }

        @Override
        public int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            assert (minuent != null && subtrahent != null);
            Data typedMinuent = (Data)minuent;
            Data typedSubtrahent = (Data)subtrahent;
            String stringMinuent = typedMinuent.getCanonicalString();
            String stringSubtrahent = typedSubtrahent.getCanonicalString();
            int sgn = stringMinuent.compareTo(stringSubtrahent);
            return sgn;
        }
    }

    private class Data
    extends AbstractRepositoryDataType.AbstractHashableData {
        private final PrefixIDFormat value;

        private Data(PrefixIDFormat value) {
            this.value = value;
        }

        private void checkData(PrefixIDFormatParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet {
            if (parameters.isSetAlways() && this.value == null) {
                throw new AbstractRepositoryDataType.EXValueNotSet();
            }
        }

        @Override
        protected String createCanonicalString() {
            String compareString = this.value == null ? null : this.value.getCompareString();
            return StringUtil.createCanonicalStringConcatenation((String)compareString);
        }

        public PrefixIDFormat getValue() {
            return this.value;
        }

        @Override
        public IRepositoryDataType getDataType() {
            return RDTPrefixIDFormat.this;
        }

        public String toString() {
            return To.makeNotNull((Object)this.value) + " (RDTIDPrefix)";
        }
    }

    private class DataType
    extends DTPrefixIDFormat {
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final boolean withPortableLoading;

        private DataType(IRepositoryDataTypeParameters repositoryDataTypeParameters, boolean withPortableLoading) {
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.withPortableLoading = withPortableLoading;
        }

        @Override
        protected PrefixIDFormat convertDataToTypedData(Object data) {
            IRepositoryData repositoryData = (IRepositoryData)data;
            return RDTPrefixIDFormat.this.dataToValue(repositoryData);
        }

        @Override
        protected Object convertTypedDataToData(PrefixIDFormat typedData) throws EXDataCreationFailed {
            IRepositoryData repositoryData;
            try {
                repositoryData = RDTPrefixIDFormat.this.createData(typedData);
                if (!this.withPortableLoading) {
                    RDTPrefixIDFormat.this.snapAndCheckData(repositoryData, this.repositoryDataTypeParameters);
                }
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            catch (EXValueInvalid e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            return repositoryData;
        }
    }

    public static final class PrefixIDFormatParameters
    extends RepositoryDataTypeParameters {
        public static final boolean IS_SET__POTENTIALLY = false;
        public static final boolean IS_SET__ALWAYS = true;
        private final boolean isSetAlways;
        private final IRepositoryObjectTypeID childObjectTypeID;
        private final String defaultPrefix;

        public PrefixIDFormatParameters(boolean isSetAlways, IRepositoryObjectTypeID childObjectTypeID, String defaultPrefix) {
            this.isSetAlways = isSetAlways;
            this.childObjectTypeID = childObjectTypeID;
            this.defaultPrefix = defaultPrefix;
        }

        public boolean isSetAlways() {
            return this.isSetAlways;
        }

        public IRepositoryObjectTypeID getChildObjectTypeID() {
            return this.childObjectTypeID;
        }

        public String getDefaultPrefix() {
            return this.defaultPrefix;
        }
    }

    public static class RepositoryDataTypeRegistration
    implements IRepositoryDataTypeRegistration {
        @Override
        public IRepositoryDataType getRepositoryDataType() {
            return RDTPrefixIDFormat.getInstance();
        }
    }
}

