/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.lib.DTFlags;
import com.arcway.lib.java.To;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.interFace.registration.type.data.IRepositoryValueRangeSample;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeID;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryDataTypeEnumeration;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RDTMultipleChoice
extends AbstractRepositoryDataTypeEnumeration {
    public static final RepositoryDataTypeID DATA_TYPE_ID = new RepositoryDataTypeID(ARCWAY_PLATFORM_NAMESPACE, new KeySegment("multiplechoice"));
    private static RDTMultipleChoice singleton;
    private final Comparator comparator = new Comparator();

    public static RDTMultipleChoice getInstance() {
        if (singleton == null) {
            singleton = new RDTMultipleChoice();
        }
        return singleton;
    }

    private RDTMultipleChoice() {
    }

    @Override
    public IRepositoryDataTypeID getRepositoryDataTypeID() {
        return DATA_TYPE_ID;
    }

    @Override
    public IRepositoryData createDefaultValue(IRepositoryDataTypeParameters parameters) {
        AbstractRepositoryDataTypeEnumeration.EnumerationParameters typedParameters = (AbstractRepositoryDataTypeEnumeration.EnumerationParameters)parameters;
        Set<String> selectedValues = typedParameters.isSetAlways() ? Collections.emptySet() : null;
        return this.createData(selectedValues);
    }

    public IRepositoryData createData(Set<String> selectedValues) {
        return new Data(selectedValues);
    }

    @Override
    public void snapData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) {
    }

    @Override
    public void snapAndCheckData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        AbstractRepositoryDataTypeEnumeration.EnumerationParameters typedParameters = (AbstractRepositoryDataTypeEnumeration.EnumerationParameters)parameters;
        typedData.checkData(typedParameters);
    }

    @Override
    public void checkData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        AbstractRepositoryDataTypeEnumeration.EnumerationParameters typedParameters = (AbstractRepositoryDataTypeEnumeration.EnumerationParameters)parameters;
        typedData.checkData(typedParameters);
    }

    public Set<String> dataToValue(IRepositoryData data) {
        Data typedData = (Data)data;
        assert (typedData.getDataType() == this);
        return typedData.getValues();
    }

    @Override
    public IRepositoryDataEqualComparator getEqualComparator() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataHasher getHasher() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataOrderComparator getOrderComparator() {
        return this.comparator;
    }

    @Override
    public IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        AbstractRepositoryDataTypeEnumeration.EnumerationParameters typedParameters = (AbstractRepositoryDataTypeEnumeration.EnumerationParameters)dataTypeParameters;
        return new DataType(typedParameters, withPortableLoading);
    }

    @Override
    public IDataType getDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, IRepositoryValueRangeSample sourceValueRangeSample) {
        return new DataType(AbstractRepositoryDataTypeEnumeration.getEnumerationDataTypeParameter((AbstractRepositoryDataTypeEnumeration.EnumerationParameters)dataTypeParameters, (AbstractRepositoryDataTypeEnumeration.ValueRangeSampleEnumeration)sourceValueRangeSample));
    }

    private class Comparator
    extends AbstractRepositoryDataType.AbstractHasher
    implements IRepositoryDataOrderComparator {
        private Comparator() {
        }

        @Override
        public int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            int sgn;
            List<AbstractRepositoryDataTypeEnumeration.Element> typedSubtrahent;
            List<AbstractRepositoryDataTypeEnumeration.Element> typedMinuent;
            AbstractRepositoryDataTypeEnumeration.EnumerationParameters enumerationParameters = (AbstractRepositoryDataTypeEnumeration.EnumerationParameters)parameters;
            Set<String> valuesMinuent = ((Data)minuent).getValues();
            Set<String> valuesSubtrahent = ((Data)subtrahent).getValues();
            try {
                typedMinuent = enumerationParameters.getElements(valuesMinuent);
            }
            catch (AbstractRepositoryDataTypeEnumeration.EXInvalidElements e) {
                typedMinuent = null;
            }
            try {
                typedSubtrahent = enumerationParameters.getElements(valuesSubtrahent);
            }
            catch (AbstractRepositoryDataTypeEnumeration.EXInvalidElements e) {
                typedSubtrahent = null;
            }
            if (typedMinuent != null && typedSubtrahent != null) {
                Iterator<AbstractRepositoryDataTypeEnumeration.Element> elements1Iterator = typedMinuent.iterator();
                Iterator<AbstractRepositoryDataTypeEnumeration.Element> elements2Iterator = typedSubtrahent.iterator();
                sgn = -2;
                while (sgn == -2) {
                    boolean hasNext1 = elements1Iterator.hasNext();
                    boolean hasNext2 = elements2Iterator.hasNext();
                    if (hasNext1 && hasNext2) {
                        AbstractRepositoryDataTypeEnumeration.Element element2;
                        AbstractRepositoryDataTypeEnumeration.Element element1 = elements1Iterator.next();
                        int currentSgn = AbstractRepositoryDataTypeEnumeration.sgn(element1, element2 = elements2Iterator.next());
                        if (currentSgn == 0) continue;
                        sgn = currentSgn;
                        continue;
                    }
                    sgn = hasNext1 ? 1 : (hasNext2 ? -1 : 0);
                }
            } else {
                sgn = typedMinuent != null && typedSubtrahent == null ? 1 : (typedMinuent == null && typedSubtrahent != null ? -1 : 0);
            }
            return sgn;
        }
    }

    private class Data
    extends AbstractRepositoryDataType.AbstractHashableData {
        private final Set<String> values;

        private Data(Set<String> values) {
            this.values = values;
        }

        private void checkData(AbstractRepositoryDataTypeEnumeration.EnumerationParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, AbstractRepositoryDataTypeEnumeration.EXInvalidElements {
            if (parameters.isSetAlways() && this.values == null) {
                throw new AbstractRepositoryDataType.EXValueNotSet();
            }
            parameters.getElements(this.values);
        }

        @Override
        protected String createCanonicalString() {
            String compareString = this.values == null ? null : StringUtil.createCanonicalStringConcatenation(this.values);
            return StringUtil.createCanonicalStringConcatenation((String)compareString);
        }

        public Set<String> getValues() {
            return this.values;
        }

        @Override
        public IRepositoryDataType getDataType() {
            return RDTMultipleChoice.this;
        }

        public String toString() {
            return "\"" + To.makeNotNull(this.values) + "\" (RDTMultipleChoice)";
        }
    }

    private class DataType
    extends DTFlags {
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final boolean withPortableLoading;
        private final IMap_<String, String> map_sourceValue_value;

        private DataType(AbstractRepositoryDataTypeEnumeration.EnumerationParameters repositoryDataTypeParameters, boolean withPortableLoading) {
            super(repositoryDataTypeParameters.getValues(), withPortableLoading);
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.withPortableLoading = withPortableLoading;
            this.map_sourceValue_value = null;
        }

        private DataType(AbstractRepositoryDataTypeEnumeration.EnumerationDataTypeParameter parameter) {
            super(parameter.getValuesThatMayBeDeserialised(), true);
            this.repositoryDataTypeParameters = parameter.getRepositoryDataTypeParameters();
            this.withPortableLoading = true;
            this.map_sourceValue_value = parameter.getMap_SourceValue_Value();
        }

        protected ISet_<String> convertDataToTypedData(Object data) {
            IRepositoryData repositoryData = (IRepositoryData)data;
            Set<String> elements = RDTMultipleChoice.this.dataToValue(repositoryData);
            return new HashSet_(elements, IHasher_.EQUALS_HASHER);
        }

        protected Object convertTypedDataToData(ISet_<String> typedData) throws EXDataCreationFailed {
            IRepositoryData repositoryData;
            try {
                HashSet<String> data = new HashSet<String>();
                for (String value : typedData) {
                    if (this.map_sourceValue_value != null) {
                        value = (String)this.map_sourceValue_value.getByKey((Object)value);
                        assert (value != null);
                    }
                    data.add(value);
                }
                repositoryData = RDTMultipleChoice.this.createData(data);
                if (!this.withPortableLoading) {
                    RDTMultipleChoice.this.snapAndCheckData(repositoryData, this.repositoryDataTypeParameters);
                }
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            catch (EXValueInvalid e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            return repositoryData;
        }

        protected Object convertNullToData() throws EXDataCreationFailed {
            throw new UnsupportedOperationException();
        }
    }

    public static final class MultipleChoiceParameters {
        public static final AbstractRepositoryDataTypeEnumeration.EnumerationParameters DEFAULTS(IList_<Tuple<String, String>> values) {
            return new AbstractRepositoryDataTypeEnumeration.EnumerationParameters(true, values);
        }
    }

    public static class RepositoryDataTypeRegistration
    implements IRepositoryDataTypeRegistration {
        @Override
        public IRepositoryDataType getRepositoryDataType() {
            return RDTMultipleChoice.getInstance();
        }
    }
}

