/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.lib.DTInteger32Bit;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.lib.high.declaration.type.IARCWAYPlatformNameSpace;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeID;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryDataTypeNumber;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;

public class RDTInteger32Bit
extends AbstractRepositoryDataTypeNumber
implements IARCWAYPlatformNameSpace {
    public static final RepositoryDataTypeID DATA_TYPE_ID = new RepositoryDataTypeID(ARCWAY_PLATFORM_NAMESPACE, new KeySegment("integer32bit"));
    private static RDTInteger32Bit singleton;
    private final Comparator comparator = new Comparator();

    public static RDTInteger32Bit getInstance() {
        if (singleton == null) {
            singleton = new RDTInteger32Bit();
        }
        return singleton;
    }

    private RDTInteger32Bit() {
    }

    @Override
    public IRepositoryDataTypeID getRepositoryDataTypeID() {
        return DATA_TYPE_ID;
    }

    @Override
    public Class<? extends IRepositoryDataTypeParameters> getRepositoryDataTypeParemtersType() {
        return Parameters.class;
    }

    public boolean isSetAlways(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isSetAlways();
    }

    public int getMinValue(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.getMinValue();
    }

    public int getMaxValue(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.getMaxValue();
    }

    @Override
    public IRepositoryData createDefaultValue(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        Integer selectedValue = typedParameters.isSetAlways() ? Integer.valueOf(0) : null;
        return this.createData(selectedValue);
    }

    public IRepositoryData createData(Integer value) {
        return new Data(value);
    }

    @Override
    public void snapData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) {
    }

    @Override
    public void snapAndCheckData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    @Override
    public void checkData(IRepositoryData data, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)data;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    public Integer dataToValue(IRepositoryData data) {
        Data typedData = (Data)data;
        assert (typedData.getDataType() == this);
        return typedData.getValue();
    }

    @Override
    public IRepositoryDataEqualComparator getEqualComparator() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataHasher getHasher() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataOrderComparator getOrderComparator() {
        return this.comparator;
    }

    @Override
    public IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        return new DataType(dataTypeParameters, withPortableLoading);
    }

    private class Comparator
    extends AbstractRepositoryDataType.AbstractHasher
    implements IRepositoryDataOrderComparator {
        private Comparator() {
        }

        @Override
        public int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            return this.getSgn(minuent, subtrahent);
        }

        private int getSgn(IRepositoryData minuent, IRepositoryData subtrahent) {
            Integer typedMinuent = RDTInteger32Bit.this.dataToValue(minuent);
            Integer typedSubtrahent = RDTInteger32Bit.this.dataToValue(subtrahent);
            int sgn = typedMinuent != null && typedSubtrahent != null ? typedMinuent.compareTo(typedSubtrahent) : (typedMinuent != null && typedSubtrahent == null ? 1 : (typedMinuent == null && typedSubtrahent != null ? -1 : 0));
            return sgn;
        }

        @Override
        public boolean isEqual(IRepositoryData data1, IRepositoryData data2) {
            return this.getSgn(data1, data2) == 0;
        }

        @Override
        public int getHashCode(IRepositoryData data) {
            Integer typedData = RDTInteger32Bit.this.dataToValue(data);
            int hashCode = typedData != null ? typedData.hashCode() : 0;
            return hashCode;
        }
    }

    private class Data
    extends AbstractRepositoryDataType.AbstractHashableData {
        private final Integer value;

        private Data(Integer value) {
            this.value = value;
        }

        private void checkData(Parameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, AbstractRepositoryDataTypeNumber.EXNumberValueInvalid {
            int valueDiagnostics;
            if (parameters.isSetAlways() && this.value == null) {
                throw new AbstractRepositoryDataType.EXValueNotSet();
            }
            if (this.value != null && (valueDiagnostics = this.value < parameters.getMinValue() ? 2 : (this.value > parameters.getMaxValue() ? 3 : 1)) != 1) {
                throw new AbstractRepositoryDataTypeNumber.EXNumberValueInvalid(valueDiagnostics);
            }
        }

        @Override
        protected String createCanonicalString() {
            String compareString = this.value == null ? null : this.value.toString();
            return StringUtil.createCanonicalStringConcatenation((String)compareString);
        }

        public Integer getValue() {
            return this.value;
        }

        @Override
        public IRepositoryDataType getDataType() {
            return RDTInteger32Bit.this;
        }

        public String toString() {
            return "\"" + To.makeNotNull((Object)this.value) + "\" (RDTInteger32Bit)";
        }
    }

    private class DataType
    extends DTInteger32Bit {
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final boolean withPortableLoading;

        private DataType(IRepositoryDataTypeParameters repositoryDataTypeParameters, boolean withPortableLoading) {
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.withPortableLoading = withPortableLoading;
        }

        protected Integer convertDataToTypedData(Object data) {
            IRepositoryData repositoryData = (IRepositoryData)data;
            return RDTInteger32Bit.this.dataToValue(repositoryData);
        }

        protected Object convertTypedDataToData(Integer typedData) throws EXDataCreationFailed {
            IRepositoryData repositoryData;
            try {
                repositoryData = RDTInteger32Bit.this.createData(typedData);
                if (!this.withPortableLoading) {
                    RDTInteger32Bit.this.snapAndCheckData(repositoryData, this.repositoryDataTypeParameters);
                }
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            catch (EXValueInvalid e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            return repositoryData;
        }
    }

    public static final class Parameters
    extends RepositoryDataTypeParameters {
        public static final boolean IS_SET__POTENTIALLY = false;
        public static final boolean IS_SET__ALWAYS = true;
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE = new Parameters(false, Integer.MIN_VALUE, Integer.MAX_VALUE);
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__NULL_AND_POSITIVE = new Parameters(false, 0, Integer.MAX_VALUE);
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__POSITIVE = new Parameters(false, 1, Integer.MAX_VALUE);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__FULL_RANGE = new Parameters(true, Integer.MIN_VALUE, Integer.MAX_VALUE);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__NULL_AND_POSITIVE = new Parameters(true, 0, Integer.MAX_VALUE);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__POSITIVE = new Parameters(true, 1, Integer.MAX_VALUE);
        private final boolean isSetAlways;
        private final int minValue;
        private final int maxValue;

        public Parameters(boolean isSetAlways, int minValue, int maxValue) {
            this.isSetAlways = isSetAlways;
            this.minValue = minValue;
            Assert.checkArgument((maxValue > minValue ? 1 : 0) != 0);
            this.maxValue = maxValue;
        }

        public boolean isSetAlways() {
            return this.isSetAlways;
        }

        private int getMinValue() {
            return this.minValue;
        }

        private int getMaxValue() {
            return this.maxValue;
        }
    }

    public static class RepositoryDataTypeRegistration
    implements IRepositoryDataTypeRegistration {
        @Override
        public IRepositoryDataType getRepositoryDataType() {
            return RDTInteger32Bit.getInstance();
        }
    }
}

