/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.lib.DTFloat64BitIEEE745;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.java.math.Sgn;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.lib.high.declaration.type.IARCWAYPlatformNameSpace;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeID;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryDataTypeNumber;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;

public class RDTFloat64BitIEEE754
extends AbstractRepositoryDataTypeNumber
implements IARCWAYPlatformNameSpace {
    private static final long MAX_ULPS = 10L;
    public static final RepositoryDataTypeID DATA_TYPE_ID = new RepositoryDataTypeID(ARCWAY_PLATFORM_NAMESPACE, new KeySegment("float64bitieee754"));
    private static RDTFloat64BitIEEE754 singleton;
    private final Comparator comparator = new Comparator();

    public static RDTFloat64BitIEEE754 getInstance() {
        if (singleton == null) {
            singleton = new RDTFloat64BitIEEE754();
        }
        return singleton;
    }

    private RDTFloat64BitIEEE754() {
    }

    @Override
    public IRepositoryDataTypeID getRepositoryDataTypeID() {
        return DATA_TYPE_ID;
    }

    @Override
    public Class<? extends IRepositoryDataTypeParameters> getRepositoryDataTypeParemtersType() {
        return Parameters.class;
    }

    public boolean isSetAlways(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isSetAlways();
    }

    public double getMinValue(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.getMinValue();
    }

    public double getMaxValue(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.getMaxValue();
    }

    @Override
    public IRepositoryData createDefaultValue(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        Double selectedValue = typedParameters.isSetAlways() ? Double.valueOf(0.0) : null;
        return this.createData(selectedValue);
    }

    public IRepositoryData createData(Double value) {
        return new Data(value);
    }

    @Override
    public void snapData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.snapData(typedParameters);
    }

    @Override
    public void snapAndCheckData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkAndSnapData(typedParameters);
    }

    @Override
    public void checkData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    public Double dataToValue(IRepositoryData data) {
        Data typedData = (Data)data;
        assert (typedData.getDataType() == this);
        return typedData.getValue();
    }

    @Override
    public IRepositoryDataEqualComparator getEqualComparator() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataHasher getHasher() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataOrderComparator getOrderComparator() {
        return this.comparator;
    }

    @Override
    public IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        return new DataType(dataTypeParameters, withPortableLoading);
    }

    private class Comparator
    extends AbstractRepositoryDataType.AbstractHasher
    implements IRepositoryDataOrderComparator {
        private Comparator() {
        }

        @Override
        public int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            return this.getSgn(minuent, subtrahent);
        }

        private int getSgn(IRepositoryData minuent, IRepositoryData subtrahent) {
            int sgn;
            Double typedMinuent = RDTFloat64BitIEEE754.this.dataToValue(minuent);
            Double typedSubtrahent = RDTFloat64BitIEEE754.this.dataToValue(subtrahent);
            if (typedMinuent != null && typedSubtrahent != null) {
                double minuentAsDouble = typedMinuent;
                double subtrahentAsDouble = typedSubtrahent;
                sgn = Sgn.sgn((double)minuentAsDouble, (double)subtrahentAsDouble, (long)10L);
            } else {
                sgn = typedMinuent != null && typedSubtrahent == null ? 1 : (typedMinuent == null && typedSubtrahent != null ? -1 : 0);
            }
            return sgn;
        }

        @Override
        public boolean isEqual(IRepositoryData data1, IRepositoryData data2) {
            return this.getSgn(data1, data2) == 0;
        }

        @Override
        public int getHashCode(IRepositoryData data) {
            Double typedData = RDTFloat64BitIEEE754.this.dataToValue(data);
            int hashCode = typedData != null ? typedData.hashCode() : 0;
            return hashCode;
        }
    }

    private class Data
    implements IRepositoryData {
        private Double value;

        private Data(Double value) {
            this.value = value;
        }

        private void snapData(Parameters parameters) {
            Double snappedValue;
            this.value = snappedValue = this.getSnappedValue(parameters);
        }

        private void checkAndSnapData(Parameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, AbstractRepositoryDataTypeNumber.EXNumberValueInvalid {
            Double snappedValue = this.getSnappedValue(parameters);
            this.checkValue(snappedValue, parameters);
            this.value = snappedValue;
        }

        private void checkData(Parameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, AbstractRepositoryDataTypeNumber.EXNumberValueInvalid {
            this.checkValue(this.value, parameters);
        }

        private Double getSnappedValue(Parameters parameters) {
            Double snappedValue = this.value == null ? null : (this.value < parameters.getMinValue() ? parameters.getMinValueAsDoubleObject() : (this.value > parameters.getMaxValue() ? parameters.getMaxValueAsDoubleObject() : this.value));
            return snappedValue;
        }

        private void checkValue(Double valueToCheck, Parameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, AbstractRepositoryDataTypeNumber.EXNumberValueInvalid {
            int valueDiagnostics;
            if (parameters.isSetAlways() && valueToCheck == null) {
                throw new AbstractRepositoryDataType.EXValueNotSet();
            }
            if (valueToCheck != null && (valueDiagnostics = Sgn.sgn((double)valueToCheck, (double)parameters.getMinValue(), (long)10L) < 0 ? 2 : (Sgn.sgn((double)parameters.getMaxValue(), (double)valueToCheck, (long)10L) < 0 ? 3 : 1)) != 1) {
                throw new AbstractRepositoryDataTypeNumber.EXNumberValueInvalid(valueDiagnostics);
            }
        }

        public Double getValue() {
            return this.value;
        }

        @Override
        public IRepositoryDataType getDataType() {
            return RDTFloat64BitIEEE754.this;
        }

        public String toString() {
            return "\"" + To.makeNotNull((Object)this.value) + "\" (RDTFloat64BitIEEE754)";
        }
    }

    private class DataType
    extends DTFloat64BitIEEE745 {
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final boolean withPortableLoading;

        private DataType(IRepositoryDataTypeParameters repositoryDataTypeParameters, boolean withPortableLoading) {
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.withPortableLoading = withPortableLoading;
        }

        protected Double convertDataToTypedData(Object data) {
            IRepositoryData repositoryData = (IRepositoryData)data;
            return RDTFloat64BitIEEE754.this.dataToValue(repositoryData);
        }

        protected Object convertTypedDataToData(Double typedData) throws EXDataCreationFailed {
            IRepositoryData repositoryData;
            try {
                repositoryData = RDTFloat64BitIEEE754.this.createData(typedData);
                if (!this.withPortableLoading) {
                    RDTFloat64BitIEEE754.this.snapAndCheckData(repositoryData, this.repositoryDataTypeParameters);
                }
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            catch (EXValueInvalid e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            return repositoryData;
        }
    }

    public static final class Parameters
    extends RepositoryDataTypeParameters {
        public static final boolean IS_SET__POTENTIALLY = false;
        public static final boolean IS_SET__ALWAYS = true;
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE = new Parameters(false, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__NULL_AND_POSITIVE = new Parameters(false, 0.0, Double.POSITIVE_INFINITY);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__FULL_RANGE = new Parameters(true, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__NULL_AND_POSITIVE = new Parameters(true, 0.0, Double.POSITIVE_INFINITY);
        private final boolean isSetAlways;
        private final Double minValue;
        private final Double maxValue;

        public Parameters(boolean isSetAlways, double minValue, double maxValue) {
            double maxValueSorted;
            double minValueSorted;
            this.isSetAlways = isSetAlways;
            if (maxValue >= minValue || Sgn.sgn((double)maxValue, (double)minValue, (long)10L) != 0) {
                minValueSorted = minValue;
                maxValueSorted = maxValue;
            } else {
                minValueSorted = maxValue;
                maxValueSorted = minValue;
            }
            this.minValue = new Double(minValueSorted);
            Assert.checkArgument((maxValueSorted >= minValueSorted ? 1 : 0) != 0);
            this.maxValue = new Double(maxValueSorted);
        }

        public boolean isSetAlways() {
            return this.isSetAlways;
        }

        private double getMinValue() {
            return this.minValue;
        }

        private double getMaxValue() {
            return this.maxValue;
        }

        private Double getMinValueAsDoubleObject() {
            return this.minValue;
        }

        private Double getMaxValueAsDoubleObject() {
            return this.maxValue;
        }
    }

    public static class RepositoryDataTypeRegistration
    implements IRepositoryDataTypeRegistration {
        @Override
        public IRepositoryDataType getRepositoryDataType() {
            return RDTFloat64BitIEEE754.getInstance();
        }
    }
}

