/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.lib.DTString;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.collections.formatters.ArcwayCollectionFormatter;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryFile;
import com.arcway.repository.interFace.dataaccess.IRepositoryFileArchive;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeFile;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.lib.high.declaration.type.IARCWAYPlatformNameSpace;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeID;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;
import java.util.WeakHashMap;

public class RDTFile
extends AbstractRepositoryDataType
implements IRepositoryDataTypeFile,
IARCWAYPlatformNameSpace {
    private static WeakHashMap<String, IRepositoryFileID> weakHashMap = new WeakHashMap();
    public static final RepositoryDataTypeID DATA_TYPE_ID = new RepositoryDataTypeID(ARCWAY_PLATFORM_NAMESPACE, new KeySegment("file"));
    private static RDTFile singleton;
    private final Comparator comparator = new Comparator();

    public static RDTFile getInstance() {
        if (singleton == null) {
            singleton = new RDTFile();
        }
        return singleton;
    }

    private RDTFile() {
    }

    @Override
    public IRepositoryDataTypeID getRepositoryDataTypeID() {
        return DATA_TYPE_ID;
    }

    @Override
    public Class<? extends IRepositoryDataTypeParameters> getRepositoryDataTypeParemtersType() {
        return Parameters.class;
    }

    public boolean isSetAlways(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isSetAlways();
    }

    public IRepositoryData loadFileIntoTemporaryStorage(IStreamResource value, IRepositoryFileArchive fileArchive) throws JvmExternalResourceInteractionException {
        IRepositoryFileID repositoryFileID = value != null ? fileArchive.loadFileIntoTemporaryStorage(value) : null;
        Data data = new Data(repositoryFileID);
        return data;
    }

    public boolean loadFileIntoTemporaryStorage(IStreamResource value, IRepositoryData originalFileReference, IRepositoryObjectSample sourceCreationSnapshotInformation, long sourceCreationDate, IRepositoryFileArchive fileArchive) throws JvmExternalResourceInteractionException {
        Assert.checkObjectArgumentToBeInstanceOf((Object)originalFileReference, Data.class);
        Assert.checkArgumentBeeingNotNull((Object)value);
        return fileArchive.loadFileIntoTemporaryStorage(value, ((Data)originalFileReference).getValue(), sourceCreationSnapshotInformation, sourceCreationDate);
    }

    public void removeFileFromTemporaryStorage(IRepositoryData data, IRepositoryFileArchive fileArchive) {
        IRepositoryFileID repositoryFileID = this.dataToFileID(data);
        if (repositoryFileID != null) {
            fileArchive.removeFileFromTemporaryStorage(repositoryFileID);
        }
    }

    @Override
    public IRepositoryData createDefaultValue(IRepositoryDataTypeParameters parameters) {
        return this.createData(null);
    }

    public IRepositoryData createData(IRepositoryFileID value) {
        return new Data(value);
    }

    @Override
    public void snapData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) {
    }

    @Override
    public void snapAndCheckData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    @Override
    public void checkData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    public IRepositoryFile dataToRepositoryFile(IRepositoryData data, IRepositoryFileArchive fileArchive) throws EXNotReproducibleSnapshot {
        IRepositoryFileID repositoryFileID = this.dataToFileID(data);
        IRepositoryFile repositoryFile = repositoryFileID != null ? fileArchive.getRepositoryFile(repositoryFileID) : null;
        return repositoryFile;
    }

    @Override
    public IRepositoryFileID dataToFileID(IRepositoryData data) {
        Data typedData = (Data)data;
        assert (typedData.getDataType() == this);
        return typedData.getValue();
    }

    @Override
    public IRepositoryDataEqualComparator getEqualComparator() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataHasher getHasher() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataOrderComparator getOrderComparator() {
        return this.comparator;
    }

    @Override
    public IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        return new DataType(dataTypeParameters, withPortableLoading);
    }

    private class Comparator
    extends AbstractRepositoryDataType.AbstractHasher
    implements IRepositoryDataOrderComparator {
        private Comparator() {
        }

        @Override
        public int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            Data typedMinuent = (Data)minuent;
            Data typedSubtrahent = (Data)subtrahent;
            String stringMinuent = typedMinuent.getCanonicalString();
            String stringSubtrahent = typedSubtrahent.getCanonicalString();
            int sgn = stringMinuent.compareTo(stringSubtrahent);
            return sgn;
        }
    }

    private class Data
    extends AbstractRepositoryDataType.AbstractHashableData {
        private final IRepositoryFileID value;

        private Data(IRepositoryFileID value) {
            this.value = value;
        }

        private void checkData(Parameters parameters) throws AbstractRepositoryDataType.EXValueNotSet {
            if (parameters.isSetAlways() && this.value == null) {
                throw new AbstractRepositoryDataType.EXValueNotSet();
            }
        }

        @Override
        protected String createCanonicalString() {
            String compareString = this.value == null ? null : this.value.toCanonicalString();
            return StringUtil.createCanonicalStringConcatenation((String)compareString);
        }

        private IRepositoryFileID getValue() {
            return this.value;
        }

        @Override
        public IRepositoryDataType getDataType() {
            return RDTFile.this;
        }

        public String toString() {
            String string = this.value == null ? To.makeNotNull((Object)this.value).toString() : this.value.toCanonicalString();
            return "\"" + string + "\" (RDTFile)";
        }
    }

    private class DataType
    extends DTString {
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final boolean withPortableLoading;

        private DataType(IRepositoryDataTypeParameters repositoryDataTypeParameters, boolean withPortableLoading) {
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.withPortableLoading = withPortableLoading;
        }

        protected String convertDataToTypedData(Object data) {
            IRepositoryData repositoryData = (IRepositoryData)data;
            IRepositoryFileID fileID = RDTFile.this.dataToFileID(repositoryData);
            String fileIDAsString = fileID == null ? null : fileID.toCanonicalString();
            return fileIDAsString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object convertTypedDataToData(final String typedData) throws EXDataCreationFailed {
            IRepositoryData repositoryData;
            IRepositoryFileID repositoryFileID;
            if (typedData == null) {
                repositoryFileID = null;
            } else {
                Object fileID;
                WeakHashMap weakHashMap = weakHashMap;
                synchronized (weakHashMap) {
                    fileID = weakHashMap.get(typedData);
                }
                repositoryFileID = fileID != null ? (IRepositoryFileID)fileID : new IRepositoryFileID(){

                    public String toCanonicalString() {
                        return typedData;
                    }
                };
            }
            try {
                repositoryData = RDTFile.this.createData(repositoryFileID);
                if (!this.withPortableLoading) {
                    RDTFile.this.snapAndCheckData(repositoryData, this.repositoryDataTypeParameters);
                }
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            catch (EXValueInvalid e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            return repositoryData;
        }
    }

    public class EXFilenamePostifxInvalid
    extends EXValueInvalid {
        private final ISet_<String> allowedNamePostfixes;
        private final String invalidFileName;

        public EXFilenamePostifxInvalid(String invalidFileName, ISet_<String> allowedNamePostfixes) {
            Assert.checkArgument((!allowedNamePostfixes.isEmpty() ? 1 : 0) != 0);
            this.invalidFileName = invalidFileName;
            this.allowedNamePostfixes = allowedNamePostfixes;
        }

        public String getInvalidFileName() {
            return this.invalidFileName;
        }

        public ISet_<String> getAllowedNamePostfixes() {
            return this.allowedNamePostfixes;
        }

        @Override
        public String getMessage() {
            return new StringBuffer().append("Invalid Filename: ").append(this.invalidFileName).append("/ Allowed Name Postfixes: ").append(ArcwayCollectionFormatter.toString(this.allowedNamePostfixes)).toString();
        }
    }

    public static final class Parameters
    extends RepositoryDataTypeParameters {
        public static final boolean IS_SET__POTENTIALLY = false;
        public static final boolean IS_SET__ALWAYS = true;
        private static final String[] FILENAME_POSTFIXES_ALL = new String[0];
        private static final String[] FILENAME_POSTFIXES_IMAGES = new String[]{".png", ".jpg", ".jpeg", ".gif"};
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__ALLOW_ALL_FILENAME_POSTFIXES = new Parameters(false, FILENAME_POSTFIXES_ALL);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__ALLOW_ALL_FILENAME_POSTFIXES = new Parameters(true, FILENAME_POSTFIXES_ALL);
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__ALLOW_IMAGE_FILENAME_POSTFIXES = new Parameters(false, FILENAME_POSTFIXES_IMAGES);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__ALLOW_IMAGE_FILENAME_POSTFIXES = new Parameters(true, FILENAME_POSTFIXES_IMAGES);
        private final boolean isSetAlways;
        private final ISet_<String> allowedNamePostfixes;

        public Parameters(boolean isSetAlways, String[] allowedNamePostfixes) {
            this.isSetAlways = isSetAlways;
            HashSet_ allowedNamePostfixesRW = new HashSet_(IHasher_.EQUALS_HASHER);
            String[] stringArray = allowedNamePostfixes;
            int n = allowedNamePostfixes.length;
            int n2 = 0;
            while (n2 < n) {
                String currentPostfix = stringArray[n2];
                Assert.checkStringToBeNotEmpty((String)currentPostfix);
                allowedNamePostfixesRW.add((Object)currentPostfix);
                ++n2;
            }
            this.allowedNamePostfixes = allowedNamePostfixesRW;
        }

        public boolean isSetAlways() {
            return this.isSetAlways;
        }

        public ISet_<String> getAllowedFilenamePostfixes() {
            return this.allowedNamePostfixes;
        }
    }

    public static class RepositoryDataTypeRegistration
    implements IRepositoryDataTypeRegistration {
        @Override
        public IRepositoryDataType getRepositoryDataType() {
            return RDTFile.getInstance();
        }
    }
}

