/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.lib.DTDateUTC64Bitmsec;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.lib.high.declaration.type.IARCWAYPlatformNameSpace;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeID;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;
import java.util.Calendar;
import java.util.Date;

public class RDTDateUTC64Bitmsec
extends AbstractRepositoryDataType
implements IARCWAYPlatformNameSpace {
    public static final RepositoryDataTypeID DATA_TYPE_ID = new RepositoryDataTypeID(ARCWAY_PLATFORM_NAMESPACE, new KeySegment("dateUTC64bitmsec"));
    private static RDTDateUTC64Bitmsec singleton;
    private final Comparator comparator = new Comparator();

    public static RDTDateUTC64Bitmsec getInstance() {
        if (singleton == null) {
            singleton = new RDTDateUTC64Bitmsec();
        }
        return singleton;
    }

    private RDTDateUTC64Bitmsec() {
    }

    @Override
    public IRepositoryDataTypeID getRepositoryDataTypeID() {
        return DATA_TYPE_ID;
    }

    @Override
    public Class<? extends IRepositoryDataTypeParameters> getRepositoryDataTypeParemtersType() {
        return Parameters.class;
    }

    public IRepositoryData getNow() {
        IRepositoryData data;
        Date now = new Date();
        try {
            data = this.createData(now);
            this.snapAndCheckData(data, Parameters.PARAMETERS__IS_SET_ALWAYS__FULL_RANGE__DATE_AND_TIME__IN_MS);
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            throw new RuntimeException(e);
        }
        catch (EXValueInvalid e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    public boolean isSetAlways(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isSetAlways();
    }

    public long getMinValue(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.getMinValue();
    }

    public long getMaxValue(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.getMaxValue();
    }

    public long getResolution(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.getResolution();
    }

    public boolean isWithTimeComponent(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isWithTimeComponent();
    }

    @Override
    public IRepositoryData createDefaultValue(IRepositoryDataTypeParameters parameters) {
        return this.createData(null);
    }

    public IRepositoryData createData(Date value) {
        return new Data(value);
    }

    @Override
    public void snapData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) {
    }

    @Override
    public void snapAndCheckData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    @Override
    public void checkData(IRepositoryData data, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)data;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    public Date dataToValue(IRepositoryData data) {
        Data typedData = (Data)data;
        assert (typedData.getDataType() == this);
        return typedData.getValue();
    }

    @Override
    public IRepositoryDataEqualComparator getEqualComparator() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataHasher getHasher() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataOrderComparator getOrderComparator() {
        return this.comparator;
    }

    @Override
    public IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        return new DataType(dataTypeParameters, withPortableLoading);
    }

    private class Comparator
    extends AbstractRepositoryDataType.AbstractHasher
    implements IRepositoryDataOrderComparator {
        private Comparator() {
        }

        @Override
        public int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            return this.getSgn_internal(minuent, subtrahent, parameters);
        }

        private int getSgn_internal(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            int sgn;
            boolean withTimeComponent = true;
            if (parameters instanceof Parameters) {
                Parameters dateParameters = (Parameters)parameters;
                withTimeComponent = dateParameters.isWithTimeComponent;
            }
            Date typedMinuent = RDTDateUTC64Bitmsec.this.dataToValue(minuent);
            Date typedSubtrahent = RDTDateUTC64Bitmsec.this.dataToValue(subtrahent);
            if (typedMinuent != null && typedSubtrahent != null) {
                if (withTimeComponent) {
                    sgn = typedMinuent.compareTo(typedSubtrahent);
                } else {
                    Calendar c1 = Calendar.getInstance();
                    c1.setTime(typedMinuent);
                    Calendar c2 = Calendar.getInstance();
                    c2.setTime(typedSubtrahent);
                    int compareValue = c1.get(1) != c2.get(1) ? c1.get(1) - c2.get(1) : (c1.get(2) != c2.get(2) ? c1.get(2) - c2.get(2) : c1.get(5) - c2.get(5));
                    sgn = (int)Math.signum(compareValue);
                }
            } else {
                sgn = typedMinuent != null && typedSubtrahent == null ? 1 : (typedMinuent == null && typedSubtrahent != null ? -1 : 0);
            }
            return sgn;
        }

        @Override
        public boolean isEqual(IRepositoryData data1, IRepositoryData data2) {
            return this.getSgn(data1, data2, null) == 0;
        }

        @Override
        public int getHashCode(IRepositoryData data) {
            Date typedData = RDTDateUTC64Bitmsec.this.dataToValue(data);
            int hashCode = typedData != null ? typedData.hashCode() : 0;
            return hashCode;
        }
    }

    private class Data
    extends AbstractRepositoryDataType.AbstractHashableData {
        private final Date value;

        private Data(Date value) {
            this.value = value;
        }

        private void checkData(Parameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXDateUTCValueInvalid {
            if (parameters.isSetAlways() && this.value == null) {
                throw new AbstractRepositoryDataType.EXValueNotSet();
            }
            if (this.value != null) {
                boolean isDateNotInResolution;
                int dateDiagnostics = this.value.getTime() < parameters.getMinValue() ? 2 : (this.value.getTime() > parameters.getMaxValue() ? 3 : 1);
                boolean bl = isDateNotInResolution = this.value.getTime() % parameters.getResolution() != 0L;
                if (dateDiagnostics != 1 || isDateNotInResolution) {
                    throw new EXDateUTCValueInvalid(dateDiagnostics, isDateNotInResolution);
                }
            }
        }

        @Override
        protected String createCanonicalString() {
            String compareString = this.value == null ? null : Long.toString(this.value.getTime());
            return StringUtil.createCanonicalStringConcatenation(compareString);
        }

        public Date getValue() {
            return this.value;
        }

        @Override
        public IRepositoryDataType getDataType() {
            return RDTDateUTC64Bitmsec.this;
        }

        public String toString() {
            return "\"" + To.makeNotNull((Object)this.value) + "\" (RDTDateUTC64Bitmsec)";
        }
    }

    private class DataType
    extends DTDateUTC64Bitmsec {
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final boolean withPortableLoading;

        private DataType(IRepositoryDataTypeParameters repositoryDataTypeParameters, boolean withPortableLoading) {
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.withPortableLoading = withPortableLoading;
        }

        protected Date convertDataToTypedData(Object data) {
            IRepositoryData repositoryData = (IRepositoryData)data;
            return RDTDateUTC64Bitmsec.this.dataToValue(repositoryData);
        }

        protected Object convertTypedDataToData(Date typedData) throws EXDataCreationFailed {
            IRepositoryData repositoryData;
            try {
                repositoryData = RDTDateUTC64Bitmsec.this.createData(typedData);
                if (!this.withPortableLoading) {
                    RDTDateUTC64Bitmsec.this.snapAndCheckData(repositoryData, this.repositoryDataTypeParameters);
                }
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            catch (EXValueInvalid e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            return repositoryData;
        }
    }

    public class EXDateUTCValueInvalid
    extends EXValueInvalid {
        public static final int DATE_IS_OK = 1;
        public static final int DATE_IS_TOO_EARLY = 2;
        public static final int DATE_IS_TOO_LATE = 3;
        private final int dateDiagnostics;
        private final boolean isDateNotInResolution;

        public EXDateUTCValueInvalid(int dateDiagnostics, boolean isDateNotInResolution) {
            this.dateDiagnostics = dateDiagnostics;
            this.isDateNotInResolution = isDateNotInResolution;
        }

        public int getLengthDiagnostics() {
            return this.dateDiagnostics;
        }

        public boolean isDateNotInResolution() {
            return this.isDateNotInResolution;
        }

        @Override
        public String getMessage() {
            return new StringBuffer().append("Date Diagnostics: ").append(this.dateDiagnostics).append("/ Is Date Not In Resolution: ").append(this.isDateNotInResolution).toString();
        }
    }

    public static final class Parameters
    extends RepositoryDataTypeParameters {
        public static final boolean IS_SET__POTENTIALLY = false;
        public static final boolean IS_SET__ALWAYS = true;
        public static final boolean IS_WITH_TIME_COMPONENT = true;
        public static final boolean IS_WITHOUT_TIME_COMPONENT = false;
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_ONLY = new Parameters(false, Long.MIN_VALUE, Long.MAX_VALUE, 1L, false);
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_AND_TIME__IN_MS = new Parameters(false, Long.MIN_VALUE, Long.MAX_VALUE, 1L, true);
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_AND_TIME__IN_S = new Parameters(false, Long.MIN_VALUE, Long.MAX_VALUE, 1000L, true);
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_AND_TIME__IN_MIN = new Parameters(false, Long.MIN_VALUE, Long.MAX_VALUE, 60000L, true);
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_AND_TIME__IN_H = new Parameters(false, Long.MIN_VALUE, Long.MAX_VALUE, 3600000L, true);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__FULL_RANGE__DATE_ONLY = new Parameters(true, Long.MIN_VALUE, Long.MAX_VALUE, 1L, false);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__FULL_RANGE__DATE_AND_TIME__IN_MS = new Parameters(true, Long.MIN_VALUE, Long.MAX_VALUE, 1L, true);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__FULL_RANGE__DATE_AND_TIME__IN_S = new Parameters(true, Long.MIN_VALUE, Long.MAX_VALUE, 1000L, true);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__FULL_RANGE__DATE_AND_TIME__IN_MIN = new Parameters(true, Long.MIN_VALUE, Long.MAX_VALUE, 60000L, true);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__FULL_RANGE__DATE_AND_TIME__IN_H = new Parameters(true, Long.MIN_VALUE, Long.MAX_VALUE, 3600000L, true);
        private final boolean isSetAlways;
        private final long minValue;
        private final long maxValue;
        private final long resolution;
        private final boolean isWithTimeComponent;

        public Parameters(boolean isSetAlways, long minValue, long maxValue, long resolution, boolean isWithTimeComponent) {
            this.isSetAlways = isSetAlways;
            this.minValue = minValue;
            Assert.checkArgument((maxValue >= minValue ? 1 : 0) != 0);
            this.maxValue = maxValue;
            Assert.checkArgument((resolution > 0L ? 1 : 0) != 0);
            this.resolution = resolution;
            this.isWithTimeComponent = isWithTimeComponent;
        }

        public boolean isSetAlways() {
            return this.isSetAlways;
        }

        private long getMinValue() {
            return this.minValue;
        }

        private long getMaxValue() {
            return this.maxValue;
        }

        private long getResolution() {
            return this.resolution;
        }

        public boolean isWithTimeComponent() {
            return this.isWithTimeComponent;
        }
    }

    public static class RepositoryDataTypeRegistration
    implements IRepositoryDataTypeRegistration {
        @Override
        public IRepositoryDataType getRepositoryDataType() {
            return RDTDateUTC64Bitmsec.getInstance();
        }
    }
}

