/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.lib.DTBoolean;
import com.arcway.lib.java.To;
import com.arcway.lib.java.math.Sgn;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.lib.high.declaration.type.IARCWAYPlatformNameSpace;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeID;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;

public class RDTBoolean
extends AbstractRepositoryDataType
implements IARCWAYPlatformNameSpace {
    public static final RepositoryDataTypeID DATA_TYPE_ID = new RepositoryDataTypeID(ARCWAY_PLATFORM_NAMESPACE, new KeySegment("boolean"));
    private static RDTBoolean singleton;
    private final Data NULL;
    private final Data FALSE;
    private final Data TRUE;
    private final Data[] values;
    private final Comparator comparator = new Comparator();

    public static synchronized RDTBoolean getInstance() {
        if (singleton == null) {
            singleton = new RDTBoolean();
        }
        return singleton;
    }

    private RDTBoolean() {
        this.NULL = new Data(null);
        this.FALSE = new Data(Boolean.FALSE);
        this.TRUE = new Data(Boolean.TRUE);
        this.values = new Data[]{this.NULL, this.FALSE, this.TRUE};
    }

    @Override
    public IRepositoryDataTypeID getRepositoryDataTypeID() {
        return DATA_TYPE_ID;
    }

    @Override
    public Class<? extends IRepositoryDataTypeParameters> getRepositoryDataTypeParemtersType() {
        return Parameters.class;
    }

    public boolean isSetAlways(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isSetAlways();
    }

    public Data[] getValues() {
        return this.values;
    }

    @Override
    public IRepositoryData createDefaultValue(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        Boolean selectedValues = typedParameters.isSetAlways() ? Boolean.FALSE : null;
        return this.createData(selectedValues);
    }

    public IRepositoryData createData(Boolean value) {
        Data data = value == null ? this.NULL : (value != false ? this.TRUE : this.FALSE);
        return data;
    }

    @Override
    public void snapData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) {
    }

    @Override
    public void snapAndCheckData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    @Override
    public void checkData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    public Boolean dataToValue(IRepositoryData data) {
        Data typedData = (Data)data;
        assert (typedData.getDataType() == this);
        return typedData.getValue();
    }

    @Override
    public IRepositoryDataEqualComparator getEqualComparator() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataHasher getHasher() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataOrderComparator getOrderComparator() {
        return this.comparator;
    }

    @Override
    public IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        return new DataType(dataTypeParameters, withPortableLoading);
    }

    private class Comparator
    extends AbstractRepositoryDataType.AbstractHasher
    implements IRepositoryDataOrderComparator {
        private Comparator() {
        }

        @Override
        public int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            return this.getSgn(minuent, subtrahent);
        }

        private int getSgn(IRepositoryData minuent, IRepositoryData subtrahent) {
            Boolean typedMinuent = RDTBoolean.this.dataToValue(minuent);
            Boolean typedSubtrahent = RDTBoolean.this.dataToValue(subtrahent);
            int sgn = typedMinuent != null && typedSubtrahent != null ? Sgn.sgn((boolean)typedMinuent, (boolean)typedSubtrahent) : (typedMinuent != null && typedSubtrahent == null ? 1 : (typedMinuent == null && typedSubtrahent != null ? -1 : 0));
            return sgn;
        }

        @Override
        public boolean isEqual(IRepositoryData data1, IRepositoryData data2) {
            return this.getSgn(data1, data2) == 0;
        }

        @Override
        public int getHashCode(IRepositoryData data) {
            Boolean typedData = RDTBoolean.this.dataToValue(data);
            int hashCode = typedData != null ? typedData.hashCode() : 0;
            return hashCode;
        }
    }

    private class Data
    extends AbstractRepositoryDataType.AbstractHashableData {
        private final Boolean value;

        private Data(Boolean value) {
            this.value = value;
        }

        private void checkData(Parameters parameters) throws AbstractRepositoryDataType.EXValueNotSet {
            if (this.value == null && RDTBoolean.this.isSetAlways(parameters)) {
                throw new AbstractRepositoryDataType.EXValueNotSet();
            }
        }

        @Override
        protected String createCanonicalString() {
            String compareString = this.value == null ? null : this.value.toString();
            return StringUtil.createCanonicalStringConcatenation((String)compareString);
        }

        public Boolean getValue() {
            return this.value;
        }

        @Override
        public IRepositoryDataType getDataType() {
            return RDTBoolean.this;
        }

        public String toString() {
            return "\"" + To.makeNotNull((Object)this.value) + "\" (RDBoolean)";
        }
    }

    private class DataType
    extends DTBoolean {
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final boolean withPortableLoading;

        private DataType(IRepositoryDataTypeParameters repositoryDataTypeParameters, boolean withPortableLoading) {
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.withPortableLoading = withPortableLoading;
        }

        protected Boolean convertDataToTypedData(Object data) {
            IRepositoryData repositoryData = (IRepositoryData)data;
            return RDTBoolean.this.dataToValue(repositoryData);
        }

        protected Object convertTypedDataToData(Boolean typedData) throws EXDataCreationFailed {
            IRepositoryData repositoryData;
            try {
                repositoryData = RDTBoolean.this.createData(typedData);
                if (!this.withPortableLoading) {
                    RDTBoolean.this.snapAndCheckData(repositoryData, this.repositoryDataTypeParameters);
                }
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            catch (EXValueInvalid e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            return repositoryData;
        }
    }

    public static final class Parameters
    extends RepositoryDataTypeParameters {
        public static final boolean IS_SET__POTENTIALLY = false;
        public static final boolean IS_SET__ALWAYS = true;
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE = new Parameters(false);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__FULL_RANGE = new Parameters(true);
        private final boolean isSetAlways;

        public Parameters(boolean isSetAlways) {
            this.isSetAlways = isSetAlways;
        }

        public boolean isSetAlways() {
            return this.isSetAlways;
        }
    }

    public static class RepositoryDataTypeRegistration
    implements IRepositoryDataTypeRegistration {
        @Override
        public IRepositoryDataType getRepositoryDataType() {
            return RDTBoolean.getInstance();
        }
    }
}

