/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.lib.DTString;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.java.math.Sgn;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;

public abstract class AbstractRepositoryStringDataType
extends AbstractRepositoryDataType {
    protected static final int COMPARE_MODE_NOT_COMPARABLE = 1;
    protected static final int COMPARE_MODE_EQUAL_COMPARABLE = 2;
    protected static final int COMPARE_MODE_HASHABLE = 3;
    protected static final int COMPARE_MODE_COMPARABLE = 4;
    private final Comparator STRING_DATA_COMPERATOR = new Comparator();
    private final int compareMode;

    public AbstractRepositoryStringDataType(int compareMode) {
        Assert.checkArgument((compareMode >= 1 && compareMode <= 4 ? 1 : 0) != 0);
        this.compareMode = compareMode;
    }

    public boolean isSetAlways(IRepositoryDataTypeParameters parameters) {
        AbstractStringParameters typedParameters = (AbstractStringParameters)parameters;
        return typedParameters.isSetAlways();
    }

    public long getMinLength(IRepositoryDataTypeParameters parameters) {
        AbstractStringParameters typedParameters = (AbstractStringParameters)parameters;
        return typedParameters.getMinLength();
    }

    public long getMaxLength(IRepositoryDataTypeParameters parameters) {
        AbstractStringParameters typedParameters = (AbstractStringParameters)parameters;
        return typedParameters.getMaxLength();
    }

    public boolean isAllowedCharactersBlackList(IRepositoryDataTypeParameters parameters) {
        AbstractStringParameters typedParameters = (AbstractStringParameters)parameters;
        return typedParameters.isAllowedCharactersBlackList();
    }

    public String getAllowedCharacters(IRepositoryDataTypeParameters parameters) {
        AbstractStringParameters typedParameters = (AbstractStringParameters)parameters;
        return typedParameters.getAllowedCharacters();
    }

    @Override
    public IRepositoryData createDefaultValue(IRepositoryDataTypeParameters parameters) {
        AbstractStringParameters typedParameters = (AbstractStringParameters)parameters;
        String defaultValue = typedParameters.isSetAlways() ? "" : null;
        return this.createData(defaultValue);
    }

    public IRepositoryData createData(String value) {
        String value_ = this instanceof RDTFreeText ? StringUtil.replaceLineBreaksWithWindowsLineBreaks((String)value) : value;
        return new RepositoryStringData(this, value_);
    }

    @Override
    public void snapData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) {
        RepositoryStringData typedData = (RepositoryStringData)repositoryData;
        AbstractStringParameters typedParameters = (AbstractStringParameters)parameters;
        typedData.snapData(typedParameters);
    }

    @Override
    public void snapAndCheckData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        RepositoryStringData typedData = (RepositoryStringData)repositoryData;
        AbstractStringParameters typedParameters = (AbstractStringParameters)parameters;
        typedData.checkAndSnapData(typedParameters);
    }

    @Override
    public void checkData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        RepositoryStringData typedData = (RepositoryStringData)repositoryData;
        AbstractStringParameters typedParameters = (AbstractStringParameters)parameters;
        typedData.checkData(typedParameters);
    }

    public String dataToValue(IRepositoryData data) {
        RepositoryStringData typedData = (RepositoryStringData)data;
        assert (typedData.getDataType() == this);
        return typedData.getValue();
    }

    @Override
    public IRepositoryDataEqualComparator getEqualComparator() {
        return this.getComparator(2);
    }

    @Override
    public IRepositoryDataHasher getHasher() {
        return this.getComparator(3);
    }

    @Override
    public IRepositoryDataOrderComparator getOrderComparator() {
        return this.getComparator(4);
    }

    private Comparator getComparator(int level) {
        Comparator comparator = level <= this.compareMode ? this.STRING_DATA_COMPERATOR : null;
        return comparator;
    }

    @Override
    public IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        return new DataType(dataTypeParameters, withPortableLoading);
    }

    public static class AbstractStringParameters
    extends RepositoryDataTypeParameters {
        public static final boolean IS_SET__POTENTIALLY = false;
        public static final boolean IS_SET__ALWAYS = true;
        public static final boolean IS_TRIMMED__NO = false;
        public static final boolean IS_TRIMMED__YES = true;
        public static final long MIN_LENGTH__POTENTIALLY_EMPTY = 0L;
        public static final long MIN_LENGTH__NOT_EMPTY = 1L;
        public static final long MAX_LENGTH__INFINITE = -1L;
        public static final boolean ALLOWED_CHARACTERS__IS_WHITE_LIST = false;
        public static final boolean ALLOWED_CHARACTERS__IS_BLACK_LIST = true;
        private final boolean isSetAlways;
        private final boolean isTrimmed;
        private final long minLength;
        private final long maxLength;
        private final boolean isAllowedCharactersBlackList;
        private final String allowedCharacters;

        public AbstractStringParameters(boolean isSetAlways, boolean isTrimmed, long minLength, long maxLength) {
            this.isSetAlways = isSetAlways;
            this.isTrimmed = isTrimmed;
            Assert.checkArgument((minLength >= 0L ? 1 : 0) != 0);
            this.minLength = minLength;
            Assert.checkArgument((maxLength == -1L || maxLength >= minLength ? 1 : 0) != 0);
            this.maxLength = maxLength;
            this.isAllowedCharactersBlackList = true;
            this.allowedCharacters = "";
        }

        public AbstractStringParameters(boolean isSetAlways, boolean isTrimmed, long minLength, long maxLength, boolean isAllowedCharactersBlackList, String allowedCharacters) {
            this.isSetAlways = isSetAlways;
            this.isTrimmed = isTrimmed;
            Assert.checkArgument((minLength >= 0L ? 1 : 0) != 0);
            this.minLength = minLength;
            Assert.checkArgument((maxLength == -1L || maxLength >= minLength ? 1 : 0) != 0);
            this.maxLength = maxLength;
            this.isAllowedCharactersBlackList = isAllowedCharactersBlackList;
            Assert.checkArgumentBeeingNotNull((Object)allowedCharacters);
            this.allowedCharacters = allowedCharacters;
        }

        public boolean isSetAlways() {
            return this.isSetAlways;
        }

        public boolean isTrimmed() {
            return this.isTrimmed;
        }

        public long getMinLength() {
            return this.minLength;
        }

        public long getMaxLength() {
            return this.maxLength;
        }

        public boolean isAllowedCharactersBlackList() {
            return this.isAllowedCharactersBlackList;
        }

        public String getAllowedCharacters() {
            return this.allowedCharacters;
        }
    }

    private class Comparator
    extends AbstractRepositoryDataType.AbstractHasher
    implements IRepositoryDataOrderComparator {
        @Override
        public int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            return this.getSgn(minuent, subtrahent, false);
        }

        private int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, boolean equalityOnly) {
            int sgn;
            String typedMinuent = AbstractRepositoryStringDataType.this.dataToValue(minuent);
            String typedSubtrahent = AbstractRepositoryStringDataType.this.dataToValue(subtrahent);
            if (typedMinuent != null && typedSubtrahent != null) {
                if (typedMinuent.equals(typedSubtrahent)) {
                    sgn = 0;
                } else if (equalityOnly) {
                    sgn = 1;
                } else {
                    int diff = typedMinuent.compareToIgnoreCase(typedSubtrahent);
                    if (diff == 0) {
                        diff = typedMinuent.compareTo(typedSubtrahent);
                    }
                    sgn = Sgn.sgn((int)diff);
                }
            } else {
                sgn = typedMinuent != null && typedSubtrahent == null ? 1 : (typedMinuent == null && typedSubtrahent != null ? -1 : 0);
            }
            return sgn;
        }

        @Override
        public boolean isEqual(IRepositoryData data1, IRepositoryData data2) {
            return this.getSgn(data1, data2, true) == 0;
        }
    }

    private class DataType
    extends DTString {
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final boolean withPortableLoading;

        private DataType(IRepositoryDataTypeParameters repositoryDataTypeParameters, boolean withPortableLoading) {
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.withPortableLoading = withPortableLoading;
        }

        protected String convertDataToTypedData(Object data) {
            IRepositoryData repositoryData = (IRepositoryData)data;
            return AbstractRepositoryStringDataType.this.dataToValue(repositoryData);
        }

        protected Object convertTypedDataToData(String typedData) throws EXDataCreationFailed {
            IRepositoryData repositoryData;
            try {
                repositoryData = AbstractRepositoryStringDataType.this.createData(typedData);
                if (!this.withPortableLoading) {
                    AbstractRepositoryStringDataType.this.snapAndCheckData(repositoryData, this.repositoryDataTypeParameters);
                }
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            catch (EXValueInvalid e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            return repositoryData;
        }
    }

    public static class EXStringValueInvalid
    extends EXValueInvalid {
        public static final int LENGTH_IS_OK = 1;
        public static final int NOT_TRIMMED = 2;
        public static final int LENGTH_IS_TOO_SHORT = 3;
        public static final int LENGTH_IS_TOO_LONG = 4;
        private final int lengthDiagnostics;
        private final Character firstInvalidCharacter;
        private final String invalidString;

        public EXStringValueInvalid(int lengthDiagnostics, Character firstInvalidCharacter, String invalidString) {
            this.lengthDiagnostics = lengthDiagnostics;
            this.firstInvalidCharacter = firstInvalidCharacter;
            this.invalidString = invalidString;
        }

        public int getLengthDiagnostics() {
            return this.lengthDiagnostics;
        }

        public Character getFirstInvalidCharacter() {
            return this.firstInvalidCharacter;
        }

        public String getInvalidString() {
            return this.invalidString;
        }

        @Override
        public String getMessage() {
            return new StringBuffer().append("Length Diagnostics: ").append(this.lengthDiagnostics).append("/ First Invalid Character: ").append(this.firstInvalidCharacter != null ? Byte.valueOf((byte)this.firstInvalidCharacter.charValue()).toString() : "(none)").append("\nInvalid String:\n").append(this.invalidString).toString();
        }
    }

    private class RepositoryStringData
    extends AbstractRepositoryDataType.AbstractHashableData {
        private final IRepositoryDataType dataType;
        private String value;

        private RepositoryStringData(IRepositoryDataType dataType, String value) {
            assert (dataType != null);
            this.dataType = dataType;
            this.value = value;
        }

        private void snapData(AbstractStringParameters parameters) {
            String snappedValue;
            this.value = snappedValue = this.getSnappedValue(parameters);
        }

        private void checkAndSnapData(AbstractStringParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXStringValueInvalid {
            String snappedValue = this.getSnappedValue(parameters);
            this.checkValue(snappedValue, parameters);
            this.value = snappedValue;
        }

        private void checkData(AbstractStringParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXStringValueInvalid {
            this.checkValue(this.value, parameters);
        }

        private String getSnappedValue(AbstractStringParameters parameters) {
            String snappedValue = this.value == null ? null : (parameters.isTrimmed() ? this.value.trim() : this.value);
            return snappedValue;
        }

        private void checkValue(String valueToCheck, AbstractStringParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXStringValueInvalid {
            if (parameters.isSetAlways() && valueToCheck == null) {
                throw new AbstractRepositoryDataType.EXValueNotSet();
            }
            if (valueToCheck != null) {
                int lengthDiagnostigs = parameters.isTrimmed() && !valueToCheck.trim().equals(valueToCheck) ? 2 : ((long)valueToCheck.length() < parameters.getMinLength() ? 3 : (parameters.getMaxLength() != -1L && (long)valueToCheck.length() > parameters.getMaxLength() ? 4 : 1));
                Character firstInvalidCharacter = parameters.isAllowedCharactersBlackList() ? StringUtil.checkStringToContainNoInvalidCharacters((String)valueToCheck, (String)parameters.getAllowedCharacters()) : StringUtil.checkStringToContainOnlyAllowedCharacters((String)valueToCheck, (String)parameters.getAllowedCharacters());
                if (lengthDiagnostigs != 1 || firstInvalidCharacter != null) {
                    throw new EXStringValueInvalid(lengthDiagnostigs, firstInvalidCharacter, valueToCheck);
                }
            }
        }

        @Override
        protected String createCanonicalString() {
            return StringUtil.createCanonicalStringConcatenation((String)this.value);
        }

        @Override
        public IRepositoryDataType getDataType() {
            return this.dataType;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "\"" + To.makeNotNull((Object)AbstractRepositoryStringDataType.this.dataToValue(this)).toString() + "\" (" + To.string((Object)this.getDataType()) + ")";
        }
    }
}

