/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.implementation.access;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;

public class RepositoryPropertySetSample
implements IRepositoryPropertySetSample {
    private final IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample> propertySamples;

    public RepositoryPropertySetSample(IRepositoryAttributeSet attributeSet) throws EXNotReproducibleSnapshot {
        assert (attributeSet != null);
        IRepositoryAttributeSetType attributeSetType = attributeSet.getAttributeSetType();
        HashMap_ createdPropertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        for (IRepositoryPropertyType propertyType : attributeSetType.getPropertyTypes()) {
            IRepositoryProperty property = attributeSet.getProperty(propertyType);
            IRepositoryPropertyTypeID propertyTypeID = propertyType.getRepositoryPropertyTypeID();
            IRepositoryPropertySample propertySample = property.sample();
            createdPropertySamples.put((Object)propertyTypeID, (Object)propertySample);
        }
        this.propertySamples = createdPropertySamples;
    }

    public RepositoryPropertySetSample(IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample> properties) {
        Assert.checkArgumentBeeingNotNull(properties);
        this.propertySamples = properties;
    }

    @Override
    public IRepositoryPropertySample getPropertySample(IRepositoryPropertyTypeID repositoryPropertyTypeID) {
        return (IRepositoryPropertySample)this.propertySamples.getByKey((Object)repositoryPropertyTypeID);
    }

    @Override
    public ICollection_<IRepositoryPropertySample> getPropertySamples() {
        return this.propertySamples.values();
    }

    @Override
    public ISet_<IRepositoryPropertyTypeID> getPropertyTypeIDs() {
        return this.propertySamples.keySet();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append('{');
        IIterator_ propertyIter = this.propertySamples.iterator();
        while (propertyIter.hasNext()) {
            IEntry_ property = (IEntry_)propertyIter.next();
            str.append(property.getKey());
            str.append('=');
            str.append(property.getValue());
            if (!propertyIter.hasNext()) continue;
            str.append(", ");
        }
        str.append('}');
        return str.toString();
    }
}

