/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.implementation.access;

import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;

public class CrossLinkRepositoryRelationSample
implements ICrossLinkRepositoryRelationSample {
    private final IRepositoryRelationTypeID relationTypeID;
    private final IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample> roleID2ObjectID;

    public CrossLinkRepositoryRelationSample(ICrossLinkRepositoryRelation relation) throws EXNotReproducibleSnapshot {
        this.relationTypeID = relation.getRelationType().getRepositoryRelationTypeID();
        HashMap_ relationContributionsRW = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        ICollection_<? extends ICrossLinkRepositoryRelationContributionType> rcTypes = relation.getRelationType().getAllRelationContributionTypes();
        for (ICrossLinkRepositoryRelationContributionType rcType : rcTypes) {
            IRepositoryRelationContributionRoleID roleID = rcType.getRepositoryRelationContributionRoleID();
            IRepositoryObject relatedObject = relation.getRelationContribution(rcType).getAttributeSet().getObject();
            IRepositoryAttributeSetType idASType = relatedObject.getObjectType().getIDAttributeSetType();
            IRepositoryPropertySetSample objectID = relatedObject.getAttributeSet(idASType).sample();
            relationContributionsRW.put((Object)roleID, (Object)objectID);
        }
        this.roleID2ObjectID = relationContributionsRW;
    }

    public CrossLinkRepositoryRelationSample(IRepositoryRelationTypeID relationTypeID, IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample> roleID2ObjectID) {
        this.relationTypeID = relationTypeID;
        this.roleID2ObjectID = roleID2ObjectID;
    }

    public CrossLinkRepositoryRelationSample(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID role1, IRepositoryPropertySetSample objectID1, IRepositoryRelationContributionRoleID role2, IRepositoryPropertySetSample objectID2) {
        HashMap_ roleID2ObjectIDRW = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        roleID2ObjectIDRW.put((Object)role1, (Object)objectID1);
        roleID2ObjectIDRW.put((Object)role2, (Object)objectID2);
        this.relationTypeID = relationTypeID;
        this.roleID2ObjectID = roleID2ObjectIDRW;
    }

    public CrossLinkRepositoryRelationSample(ICrossLinkRepositoryRelationType relationType, IRepositoryRelationContributionRoleID role1, IRepositoryPropertySetSample objectID1, IRepositoryPropertySetSample objectID2) {
        IIterator_ i = relationType.getAllRelationContributionTypes().iterator();
        IRepositoryRelationContributionRoleID role2 = ((ICrossLinkRepositoryRelationContributionType)i.next()).getRepositoryRelationContributionRoleID();
        if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)role1, (Object)role2)) {
            role2 = ((ICrossLinkRepositoryRelationContributionType)i.next()).getRepositoryRelationContributionRoleID();
        }
        HashMap_ roleID2ObjectIDRW = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        roleID2ObjectIDRW.put((Object)role1, (Object)objectID1);
        roleID2ObjectIDRW.put((Object)role2, (Object)objectID2);
        this.relationTypeID = relationType.getRepositoryRelationTypeID();
        this.roleID2ObjectID = roleID2ObjectIDRW;
    }

    @Override
    public IRepositoryRelationTypeID getRelationTypeID() {
        return this.relationTypeID;
    }

    @Override
    public IRepositoryPropertySetSample getObjectID(IRepositoryRelationContributionRoleID roleID) {
        return (IRepositoryPropertySetSample)this.roleID2ObjectID.getByKey((Object)roleID);
    }

    @Override
    public ISet_<IRepositoryRelationContributionRoleID> getRelationContributionRoleIDs() {
        return this.roleID2ObjectID.keySet();
    }

    @Override
    public IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample> getRoleID2ObjectIDMap() {
        return this.roleID2ObjectID;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("CrossLinkRepositoryRelationSample: ");
        str.append(this.relationTypeID);
        str.append(" {");
        IIterator_ rcIter = this.roleID2ObjectID.iterator();
        while (rcIter.hasNext()) {
            IEntry_ relationContribution = (IEntry_)rcIter.next();
            str.append(relationContribution.getKey());
            str.append('=');
            str.append(relationContribution.getValue());
            if (!rcIter.hasNext()) continue;
            str.append(", ");
        }
        str.append('}');
        return str.toString();
    }
}

