/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.genericmodifications.interFace.transactions;

import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILockDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILocksAndPermissionsManagerDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.AbstractEXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockForCrossLinkRelationDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockForObjectOperationDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockForOccurrenceModificationDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.ObjectOperation;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.MessageSet;
import com.arcway.repository.interFace.importexport.exceptions.EXMissingObject;
import com.arcway.repository.interFace.importexport.exceptions.EXMissingParent;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.OccurrenceRelationContribution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RSAComplexGenericModification;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.TransactionHelper;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationReference;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReferenceWithIDDefiningObjectTypeID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class TransactionLockAllocator {
    private TransactionLockAllocator() {
    }

    public static Tuple<IMessageSet, Collection<ILockDeprecated>> allocateLocks(RSAComplexGenericModification complexTransaction, IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        Tuple result;
        CrossLinkRepositoryRelationsReference relationsReference;
        MessageSet messages = new MessageSet();
        MessageSet fatalException = new MessageSet();
        ArrayList<ILockDeprecated> locks = new ArrayList<ILockDeprecated>();
        ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = repositorySnapshot.getRepositoryInterface().getLocksAndPermissionsManagerDeprecated();
        IRepositoryTypeManagerRO typeManager = repositorySnapshot.getTypeManager();
        ISet_<IRepositoryObjectReference> allObjectsToCreate = TransactionHelper.determineObjectsToCreate(complexTransaction, repositorySnapshot);
        for (RepositoryObjectSampleWithParentObjectReference objectToCreate : complexTransaction.getObjectsToCreate()) {
            IRepositoryObjectType objectType = typeManager.getObjectType(objectToCreate.getObjectSample().getObjectTypeID());
            IRepositoryObjectReference parentObjectReference = objectToCreate.getParentObjectReference();
            try {
                if (allObjectsToCreate.contains((Object)parentObjectReference)) continue;
                IRepositoryObject parentObject = RepositoryReferences.getObjectFromReference(parentObjectReference, repositorySnapshot);
                locks.add(locksAndPermissionsMgr.getLockForCreateCockpitData(parentObject, objectType));
            }
            catch (EXObjectReferenceCannotBeResolved e) {
                fatalException.add(new EXMissingParent(parentObjectReference));
            }
            catch (EXLockDenied e) {
                IRepositoryObjectReference objectToCreateReference = objectToCreate.getObjectSample().getObjectReference(typeManager);
                messages.add(new EXLockForObjectOperationDenied(objectToCreateReference, objectToCreate.getObjectSample(), ObjectOperation.CREATE, e.getConflictingLockInformation()));
            }
        }
        for (IRepositoryObjectReference objectToDeleteReference : complexTransaction.getObjectsToDelete()) {
            try {
                IRepositoryObject objectToDelete = RepositoryReferences.getObjectFromReference(objectToDeleteReference, repositorySnapshot);
                try {
                    locks.add(locksAndPermissionsMgr.getLockForDeleteCockpitData(objectToDelete));
                }
                catch (EXLockDenied e) {
                    messages.add(new EXLockForObjectOperationDenied(objectToDeleteReference, objectToDelete.sample(), ObjectOperation.DELTE, e.getConflictingLockInformation()));
                }
            }
            catch (EXObjectReferenceCannotBeResolved e) {
                fatalException.add(new EXMissingObject(objectToDeleteReference));
            }
        }
        for (ICrossLinkRepositoryRelationSample relationToCreate : complexTransaction.getRelationsToCreate()) {
            relationsReference = new CrossLinkRepositoryRelationsReference(relationToCreate.getRelationTypeID(), relationToCreate.getRoleID2ObjectIDMap());
            try {
                locks.add(locksAndPermissionsMgr.getLockForCreateOrDeleteLink(relationsReference, repositorySnapshot));
            }
            catch (EXLockDenied e) {
                messages.add(new EXLockForCrossLinkRelationDenied(new CrossLinkRepositoryRelationReference(relationToCreate), e.getConflictingLockInformation()));
            }
        }
        for (ICrossLinkRepositoryRelationReference relationToDelete : complexTransaction.getRelationsToDelete()) {
            relationsReference = new CrossLinkRepositoryRelationsReference(relationToDelete.getRelationTypeID(), relationToDelete.getRoleID2ObjectIDMap());
            try {
                locks.add(locksAndPermissionsMgr.getLockForCreateOrDeleteLink(relationsReference, repositorySnapshot));
            }
            catch (EXLockDenied e) {
                messages.add(new EXLockForCrossLinkRelationDenied(relationToDelete, e.getConflictingLockInformation()));
            }
        }
        for (Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID> entry_objectReference_categoryID : complexTransaction.getObjectTypeCategoriesToChange()) {
            TransactionLockAllocator.checkLockForModifyingObject((IRepositoryObjectReference)entry_objectReference_categoryID.getT1(), locks, messages, fatalException, repositorySnapshot, locksAndPermissionsMgr);
        }
        for (IRepositoryPropertyReference propertyToModify : complexTransaction.getPropertiesToModify().keySet()) {
            TransactionLockAllocator.checkLockForModifyingObject(propertyToModify.getObjectReference(), locks, messages, fatalException, repositorySnapshot, locksAndPermissionsMgr);
        }
        if (!complexTransaction.getOccurrenceModificationData(repositorySnapshot).isEmpty()) {
            for (IEntry_ occurenceModificationDataEntry : complexTransaction.getOccurrenceModificationData(repositorySnapshot)) {
                HashSet_ conflictingLockInformation = new HashSet_(AbstractEXLockDenied.ConflictingLockInformation.EQUAL_LOCK_INFORMATION_HASHER);
                OccurrenceRelationContribution occRC = (OccurrenceRelationContribution)occurenceModificationDataEntry.getKey();
                Tuple occModificationData = (Tuple)occurenceModificationDataEntry.getValue();
                try {
                    locks.add(locksAndPermissionsMgr.getLockForOccurrenceRelations(occRC, (ICollection_<IOccurrenceRepositoryRelationReference>)((ICollection_)occModificationData.getT1()), (ICollection_<IOccurrenceRepositoryRelationSample>)((ICollection_)occModificationData.getT2()), repositorySnapshot));
                }
                catch (EXLockDenied e) {
                    conflictingLockInformation.addAll(e.getConflictingLockInformation());
                }
                if (conflictingLockInformation.isEmpty()) continue;
                IRepositoryObjectType objectType = occRC.getOccurrenceRCType().getRelatedPropertyType().getAttributeSetType().getObjectType();
                messages.add(new EXLockForOccurrenceModificationDenied((ISet_<AbstractEXLockDenied.ConflictingLockInformation>)conflictingLockInformation, new RepositoryObjectReferenceWithIDDefiningObjectTypeID(objectType, occRC.getOccurrenceContainingObjectObjectID())));
            }
        }
        if (fatalException.isEmpty()) {
            result = new Tuple((Object)messages, locks);
        } else {
            for (ILockDeprecated lockToRelease : locks) {
                lockToRelease.release();
            }
            result = new Tuple((Object)fatalException, Collections.emptyList());
        }
        return result;
    }

    private static void checkLockForModifyingObject(IRepositoryObjectReference objectToModify, Collection<ILockDeprecated> locks, MessageSet messages, MessageSet fatalException, IRepositorySnapshotRO repositorySnapshot, ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr) throws EXNotReproducibleSnapshot {
        try {
            IRepositoryObject repositoryObject = RepositoryReferences.getObjectFromReference(objectToModify, repositorySnapshot);
            try {
                locks.add(locksAndPermissionsMgr.getLockForModifyCockpitData(repositoryObject));
            }
            catch (EXLockDenied e) {
                messages.add(new EXLockForObjectOperationDenied(objectToModify, repositoryObject.sample(), ObjectOperation.MODIFY, e.getConflictingLockInformation()));
            }
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            fatalException.add(new EXMissingObject(objectToModify));
        }
    }
}

