/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.genericmodifications.interFace.transactions;

import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollectionRW_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.data.RepositoryObjects;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IOccurrenceRepositoryRelationContributionType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IParentRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.CrossLinkRelationContribution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.OccurrenceRelationContribution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.ParentChildRelationContribution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RSAComplexGenericModification;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;

public class TransactionHelper {
    private TransactionHelper() {
    }

    public static ISet_<IRepositoryObjectReference> determineObjectsToCreate(RSAComplexGenericModification complexTransaction, IRepositorySnapshotRO repositorySnapshot) {
        HashSet_ objectsToCreate = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        for (RepositoryObjectSampleWithParentObjectReference objectToCreate : complexTransaction.getObjectsToCreate()) {
            objectsToCreate.add((Object)objectToCreate.getObjectSample().getObjectReference(repositorySnapshot.getTypeManager()));
        }
        return objectsToCreate;
    }

    public static Tuple<IList_<ParentChildRelationContribution>, IList_<CrossLinkRelationContribution>> determineDataForCardinalityCheckForObjectsToCreate(IList_<RepositoryObjectSampleWithParentObjectReference> objectsToCreate, IRepositorySnapshotRO snapshot) {
        IRepositoryTypeManagerRO typeManager = snapshot.getTypeManager();
        ArrayList_ parentChildContributions = new ArrayList_(objectsToCreate.size() * 3);
        ArrayList_ crossLinkRelationReferences = new ArrayList_(objectsToCreate.size() * 3);
        for (RepositoryObjectSampleWithParentObjectReference objectSampleWithParentAttributeSetReference : objectsToCreate) {
            IRepositoryObjectSample objectSample = objectSampleWithParentAttributeSetReference.getObjectSample();
            IRepositoryObjectType objectType = typeManager.getObjectType(objectSample.getObjectTypeID());
            IRepositoryObjectReference objectReference = objectSample.getObjectReference(typeManager);
            IRepositoryObjectReference parentObject = objectSampleWithParentAttributeSetReference.getParentObjectReference();
            IRepositoryObjectType parentObjectType = typeManager.getObjectType(parentObject.getObjectTypeID());
            IParentRepositoryRelationContributionType parentRCTypeToParent = parentObjectType.getParentRelationContributionTypeOfChildObjectType(objectType);
            parentChildContributions.add((Object)TransactionHelper.getParentChildRelationContribution(parentObject, parentRCTypeToParent, 0));
            for (IRepositoryAttributeSetType asType : objectType.getAttributeSetTypes()) {
                for (ICrossLinkRepositoryRelationContributionType rcType : asType.getCrossLinkRelationContributionTypesToConcreteRelationTypes()) {
                    IRepositoryPropertySetSample objectID = objectReference.getObjectID();
                    crossLinkRelationReferences.add((Object)TransactionHelper.getCrossLinkRelationContribution(rcType, objectID));
                }
                for (IRepositoryObjectType childObjectType : asType.getChildObjectTypes()) {
                    IParentRepositoryRelationContributionType parentRCTypeToChild = objectType.getParentRelationContributionTypeOfChildObjectType(childObjectType);
                    parentChildContributions.add((Object)TransactionHelper.getParentChildRelationContribution(objectReference, parentRCTypeToChild, 1));
                }
            }
        }
        return new Tuple((Object)parentChildContributions, (Object)crossLinkRelationReferences);
    }

    public static Tuple<IList_<ParentChildRelationContribution>, IList_<CrossLinkRelationContribution>> determineDataForCardinalityCheckForObjectsToDelete(ISet_<IRepositoryObjectReference> objectsToDelete, IRepositorySnapshotRO snapshot) throws EXObjectReferenceCannotBeResolved, EXNotReproducibleSnapshot {
        ArrayList_ parentChildContributions = new ArrayList_(objectsToDelete.size() * 3);
        ArrayList_ crossLinkRelationReferences = new ArrayList_(objectsToDelete.size() * 3);
        for (IRepositoryObjectReference objectReference : objectsToDelete) {
            IRepositoryObject object = RepositoryReferences.getObjectFromReference(objectReference, snapshot);
            IRepositoryObject parentObject = RepositoryObjects.getParentObject(object);
            RepositoryObjectReference parentObjectReference = new RepositoryObjectReference(parentObject);
            IRepositoryObjectType objectType = object.getObjectType();
            IRepositoryObjectType parentObjectType = parentObject.getObjectType();
            IParentRepositoryRelationContributionType parentRCType = parentObjectType.getParentRelationContributionTypeOfChildObjectType(objectType);
            parentChildContributions.add((Object)TransactionHelper.getParentChildRelationContribution(parentObjectReference, parentRCType, 0));
            for (IRepositoryAttributeSetType asType : objectType.getAttributeSetTypes()) {
                for (ICrossLinkRepositoryRelationContributionType rcType : asType.getCrossLinkRelationContributionTypesToConcreteRelationTypes()) {
                    IRepositoryPropertySetSample objectID = objectReference.getObjectID();
                    crossLinkRelationReferences.add((Object)TransactionHelper.getCrossLinkRelationContribution(rcType, objectID));
                }
                for (IRepositoryObjectType childObjectType : asType.getChildObjectTypes()) {
                    IParentRepositoryRelationContributionType parentRCTypeToChild = objectType.getParentRelationContributionTypeOfChildObjectType(childObjectType);
                    parentChildContributions.add((Object)TransactionHelper.getParentChildRelationContribution(objectReference, parentRCTypeToChild, 1));
                }
            }
        }
        return new Tuple((Object)parentChildContributions, (Object)crossLinkRelationReferences);
    }

    public static IList_<CrossLinkRelationContribution> determineDataForCardinalityCheckForRelationsToCreate(ISet_<ICrossLinkRepositoryRelationSample> relationsToCreate, IRepositorySnapshotRO snapshot) {
        ArrayList_ crossLinkRelationReferences = new ArrayList_(relationsToCreate.size() * 2);
        for (ICrossLinkRepositoryRelationSample relationSample : relationsToCreate) {
            ICrossLinkRepositoryRelationType relationType = snapshot.getTypeManager().getCrossLinkRelationType(relationSample.getRelationTypeID());
            for (IRepositoryRelationContributionRoleID roleID : relationSample.getRelationContributionRoleIDs()) {
                ICrossLinkRepositoryRelationContributionType rcType = relationType.getRelationContributionType(roleID);
                IRepositoryPropertySetSample objectID = relationSample.getObjectID(roleID);
                crossLinkRelationReferences.add((Object)TransactionHelper.getCrossLinkRelationContribution(rcType, objectID));
            }
        }
        return crossLinkRelationReferences;
    }

    public static IList_<CrossLinkRelationContribution> determineDataForCardinalityCheckForRelationsToDelete(ISet_<ICrossLinkRepositoryRelationReference> relationsToDelete, IRepositorySnapshotRO snapshot) {
        ArrayList_ crossLinkRelationReferences = new ArrayList_(relationsToDelete.size() * 2);
        for (ICrossLinkRepositoryRelationReference relationReference : relationsToDelete) {
            ICrossLinkRepositoryRelationType relationType = snapshot.getTypeManager().getCrossLinkRelationType(relationReference.getRelationTypeID());
            for (IRepositoryRelationContributionRoleID roleID : relationReference.getRelationContributionRoleIDs()) {
                ICrossLinkRepositoryRelationContributionType rcType = relationType.getRelationContributionType(roleID);
                IRepositoryPropertySetSample objectID = relationReference.getObjectID(roleID);
                crossLinkRelationReferences.add((Object)TransactionHelper.getCrossLinkRelationContribution(rcType, objectID));
            }
        }
        return crossLinkRelationReferences;
    }

    private static ParentChildRelationContribution getParentChildRelationContribution(IRepositoryObjectReference parentObjectReference, IParentRepositoryRelationContributionType parentRelationContributionType, int parentRCTypeTarget) {
        return new ParentChildRelationContribution(parentObjectReference, parentRelationContributionType, parentRCTypeTarget);
    }

    private static CrossLinkRelationContribution getCrossLinkRelationContribution(ICrossLinkRepositoryRelationContributionType rcType, IRepositoryPropertySetSample objectID) {
        return new CrossLinkRelationContribution(rcType, objectID);
    }

    public static IMapRW_<OccurrenceRelationContribution, Tuple<ICollectionRW_<IOccurrenceRepositoryRelationReference>, ICollectionRW_<IOccurrenceRepositoryRelationSample>>> determineOccurrenceModificationData(ICollection_<IOccurrenceRepositoryRelationReference> occurrenceRelationsToDelete, ICollection_<IOccurrenceRepositoryRelationSample> occurrenceRelationsToCreate, IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        ArrayList_ occRelToCreate;
        ArrayList_ occRelToDelete;
        Tuple occModificationData;
        OccurrenceRelationContribution occRC;
        IRepositoryTypeManagerRO typeManager = repositorySnapshot.getTypeManager();
        int sizeHint = occurrenceRelationsToCreate.size() + occurrenceRelationsToDelete.size();
        HashMap_ occurencesToModify = new HashMap_(sizeHint, OccurrenceRelationContribution.HASHER);
        for (IOccurrenceRepositoryRelationReference occurrenceRelationToDelete : occurrenceRelationsToDelete) {
            IRepositoryPropertySetSample objectIDofOccurrenceContainingObject = occurrenceRelationToDelete.getObjectIDofOccurrenceContainingObject();
            IOccurrenceRepositoryRelation relationToDelete = RepositoryReferences.getFromReference(occurrenceRelationToDelete, repositorySnapshot);
            IOccurrenceRepositoryRelationContributionType occurrenceRCType = relationToDelete.getRelationType().getOccurrenceRelationContributionType();
            occRC = new OccurrenceRelationContribution(occurrenceRCType, objectIDofOccurrenceContainingObject);
            occModificationData = (Tuple)occurencesToModify.getByKey((Object)occRC);
            if (occModificationData == null) {
                occRelToDelete = new ArrayList_();
                occRelToCreate = new ArrayList_();
                occRelToDelete.add((Object)occurrenceRelationToDelete);
                occModificationData = new Tuple((Object)occRelToDelete, (Object)occRelToCreate);
                occurencesToModify.put((Object)occRC, (Object)occModificationData);
                continue;
            }
            ((ICollectionRW_)occModificationData.getT1()).add((Object)occurrenceRelationToDelete);
        }
        for (IOccurrenceRepositoryRelationSample occurrenceRelationToCreate : occurrenceRelationsToCreate) {
            IRepositoryPropertySetSample objectIDofOccurrenceContainingObject;
            IOccurrenceRepositoryRelationType occurrenceRelationType = typeManager.getOccurrenceRelationType(occurrenceRelationToCreate.getRelationTypeID());
            IOccurrenceRepositoryRelationContributionType occurrenceRCType = occurrenceRelationType.getOccurrenceRelationContributionType();
            occRC = new OccurrenceRelationContribution(occurrenceRCType, objectIDofOccurrenceContainingObject = occurrenceRelationToCreate.getObjectIDofOccurrenceContainingObject());
            occModificationData = (Tuple)occurencesToModify.getByKey((Object)occRC);
            if (occModificationData == null) {
                occRelToDelete = new ArrayList_();
                occRelToCreate = new ArrayList_();
                occRelToCreate.add((Object)occurrenceRelationToCreate);
                occModificationData = new Tuple((Object)occRelToDelete, (Object)occRelToCreate);
                occurencesToModify.put((Object)occRC, (Object)occModificationData);
                continue;
            }
            ((ICollectionRW_)occModificationData.getT2()).add((Object)occurrenceRelationToCreate);
        }
        return occurencesToModify;
    }
}

