/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.genericmodifications.interFace.transactions;

import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollectionRW_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.RepositoryRelations;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSetReference;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IRepositoryIterator_ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.RepositoryRelationContributionTypeCardinality;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IParentRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.IRepositoryElementaryActionFactory;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionContext;
import com.arcway.repository.interFace.transactions.exceptions.EXCannotDeleteObjectWithChildren;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRCTypeCardinalityViolated;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.interFace.transactions.exceptions.EXParentChildRCTypeCardinalityViolated;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import com.arcway.repository.lib.high.declaration.type.attributeset.RepositoryAttributeSetTypeID;
import com.arcway.repository.lib.high.declaration.type.object.BaseRepositoryObjectTypeAttributeSetTypes;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.AbstractSemanticAction;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.CrossLinkRelationContribution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.OccurrenceRelationContribution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.ParentChildRelationContribution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.TransactionHelper;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.TransactionValidator;
import com.arcway.repository.lib.high.implementation.access.RepositoryAttributeSetReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySetSample;
import java.util.ArrayList;
import java.util.Collection;

public class RSAComplexGenericModification
extends AbstractSemanticAction {
    private final IList_<RepositoryObjectSampleWithParentObjectReference> objectsToCreate;
    private final ISet_<ICrossLinkRepositoryRelationSample> relationsToCreate;
    private final ISet_<IRepositoryObjectReference> objectsToDelete;
    private final ISet_<ICrossLinkRepositoryRelationReference> relationsToDelete;
    private final IMap_<IRepositoryPropertyReference, IRepositoryPropertySample> propertiesToModify;
    private final Collection<Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID>> objectTypeCategoriesToChange;
    private final ICollection_<IOccurrenceRepositoryRelationReference> occurrenceRelationsToDelete;
    private final ICollection_<IOccurrenceRepositoryRelationSample> occurrenceRelationsToCreate;
    private IMapRW_<OccurrenceRelationContribution, Tuple<ICollectionRW_<IOccurrenceRepositoryRelationReference>, ICollectionRW_<IOccurrenceRepositoryRelationSample>>> occurrenceModificationData = null;
    private final ISetRW_<CrossLinkRelationContribution> crossLinkRelationsReferencesToCheckCardinality = new HashSet_(CrossLinkRelationContribution.CROSS_LINK_RELATION_CONTRIBUTION_HASHER);
    private final ISetRW_<ParentChildRelationContribution> parentChildRelationsReferencesToCheckCardinality = new HashSet_(ParentChildRelationContribution.PARENT_CHILD_RELATION_CONTRIBUTIONS_HASHER);
    private static final IList_<RepositoryObjectSampleWithParentObjectReference> NO_OBJECTS_TO_CREATE = new ArrayList_();
    private static final ISet_<ICrossLinkRepositoryRelationSample> NO_RELATIONS_TO_CREATE = new HashSet_(ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
    private static final ISet_<IRepositoryObjectReference> NO_OBJECTS_TO_DELETE = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
    private static final ISet_<ICrossLinkRepositoryRelationReference> NO_RELATIONS_TO_DELETE = new HashSet_(ICrossLinkRepositoryRelationReference.REFERENCING_EQUAL_RELATIONS_HASHER);
    private static final IMap_<IRepositoryPropertyReference, IRepositoryPropertySample> NO_PROPERTIES_TO_MODIFIY = new HashMap_(IRepositoryPropertyReference.REFERENCES_EQUAL_PROPERTY_HASHER);
    private static final Collection<Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID>> NO_OBJECTTYPECATEGORIES_TO_CHANGE = new ArrayList<Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID>>();
    private static final ICollection_<IOccurrenceRepositoryRelationReference> NO_OCC_REL_TO_DELETE = new ArrayList_();
    private static final ICollection_<IOccurrenceRepositoryRelationSample> NO_OCC_REL_TO_CREATE = new ArrayList_();

    public RSAComplexGenericModification(ISet_<ICrossLinkRepositoryRelationReference> relationsToDelete, ISet_<IRepositoryObjectReference> objectsToDelete, IList_<RepositoryObjectSampleWithParentObjectReference> objectsToCreate, ISet_<ICrossLinkRepositoryRelationSample> relationsToCreate, Collection<Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID>> objectTypeCategoriesToBeChanged, IMap_<IRepositoryPropertyReference, IRepositoryPropertySample> propertiesToModify, ICollection_<IOccurrenceRepositoryRelationReference> occurrenceRelationsToDelete, ICollection_<IOccurrenceRepositoryRelationSample> occurrenceRelationsToCreate) {
        this.relationsToDelete = relationsToDelete != null ? relationsToDelete : NO_RELATIONS_TO_DELETE;
        this.objectsToDelete = objectsToDelete != null ? objectsToDelete : NO_OBJECTS_TO_DELETE;
        this.objectsToCreate = objectsToCreate != null ? objectsToCreate : NO_OBJECTS_TO_CREATE;
        this.relationsToCreate = relationsToCreate != null ? relationsToCreate : NO_RELATIONS_TO_CREATE;
        this.propertiesToModify = propertiesToModify != null ? propertiesToModify : NO_PROPERTIES_TO_MODIFIY;
        this.objectTypeCategoriesToChange = objectTypeCategoriesToBeChanged != null ? objectTypeCategoriesToBeChanged : NO_OBJECTTYPECATEGORIES_TO_CHANGE;
        this.occurrenceRelationsToDelete = occurrenceRelationsToDelete != null ? occurrenceRelationsToDelete : NO_OCC_REL_TO_DELETE;
        this.occurrenceRelationsToCreate = occurrenceRelationsToCreate != null ? occurrenceRelationsToCreate : NO_OCC_REL_TO_CREATE;
    }

    public Tuple<Boolean, IMessageSet> validate(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        Tuple<Boolean, IMessageSet> validationResult = TransactionValidator.validate(this, repositorySnapshot);
        return new Tuple((Object)((Boolean)validationResult.getT1()), (Object)((IMessageSet)validationResult.getT2()));
    }

    @Override
    public void execute(IRepositoryTransactionContext transaction) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        this.crossLinkRelationsReferencesToCheckCardinality.clear();
        this.parentChildRelationsReferencesToCheckCardinality.clear();
        IRepositoryElementaryActionFactory reaFactory = transaction.getElementaryActionFactory();
        IRepositorySnapshotRO snapshot = transaction.getSnapshot();
        for (ICrossLinkRepositoryRelationReference relationToDelete : this.relationsToDelete) {
            transaction.appendAction(reaFactory.createDeleteRelationAction(relationToDelete));
        }
        this.crossLinkRelationsReferencesToCheckCardinality.addAll(TransactionHelper.determineDataForCardinalityCheckForRelationsToDelete(this.relationsToDelete, snapshot));
        Tuple<IList_<ParentChildRelationContribution>, IList_<CrossLinkRelationContribution>> deletionResult = TransactionHelper.determineDataForCardinalityCheckForObjectsToDelete(this.objectsToDelete, snapshot);
        IList_ parentChildRCs = (IList_)deletionResult.getT1();
        for (ParentChildRelationContribution parentChildRC : parentChildRCs) {
            if (parentChildRC.getParentRCTypeTarget() != 0 || this.objectsToDelete.contains((Object)parentChildRC.getParentObjectReference())) continue;
            this.parentChildRelationsReferencesToCheckCardinality.add((Object)parentChildRC);
        }
        HashSet_ alreadyDeletedObjects = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        for (IRepositoryObjectReference objectToDelete : this.objectsToDelete) {
            this.deleteObject(objectToDelete, (ISetRW_<IRepositoryObjectReference>)alreadyDeletedObjects, transaction);
        }
        HashSet_ alreadyCreatedObjects = new HashSet_(IRepositoryObjectSample.REPRESENTS_EQUAL_OBJECTS_HASHER);
        for (RepositoryObjectSampleWithParentObjectReference objectToCreate : this.objectsToCreate) {
            this.createObject(objectToCreate, (ISetRW_<IRepositoryObjectSample>)alreadyCreatedObjects, transaction);
        }
        Tuple<IList_<ParentChildRelationContribution>, IList_<CrossLinkRelationContribution>> createResult = TransactionHelper.determineDataForCardinalityCheckForObjectsToCreate(this.objectsToCreate, snapshot);
        this.parentChildRelationsReferencesToCheckCardinality.addAll((ICollection_)createResult.getT1());
        this.crossLinkRelationsReferencesToCheckCardinality.addAll((ICollection_)createResult.getT2());
        for (ICrossLinkRepositoryRelationSample relationToCreate : this.relationsToCreate) {
            transaction.appendAction(reaFactory.createCreateRelationAction(relationToCreate));
        }
        this.crossLinkRelationsReferencesToCheckCardinality.addAll(TransactionHelper.determineDataForCardinalityCheckForRelationsToCreate(this.relationsToCreate, snapshot));
        for (Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID> entry_objectRefrence_categoryID : this.objectTypeCategoriesToChange) {
            transaction.appendAction(reaFactory.createModifyObjectTypeCategoryAction((IRepositoryObjectReference)entry_objectRefrence_categoryID.getT1(), (IRepositoryObjectTypeCategoryID)entry_objectRefrence_categoryID.getT2()));
        }
        HashMap_ asRef2PropertySetSampleContent = new HashMap_(IRepositoryAttributeSetReference.REFERENCES_EQUAL_ATTRIBUTE_SETS_HASHER);
        ISet_ propertyReferences = this.propertiesToModify.keySet();
        for (IRepositoryPropertyReference propertyToModify : propertyReferences) {
            IRepositoryPropertySample newPropertySample = (IRepositoryPropertySample)this.propertiesToModify.getByKey((Object)propertyToModify);
            IRepositoryPropertyTypeID propertyTypeIDOfPropertyToModify = propertyToModify.getPropertyTypeID();
            IRepositoryObjectReference objectReference = propertyToModify.getObjectReference();
            IRepositoryObject repositoryObject = RepositoryReferences.getObjectFromReference(objectReference, snapshot);
            IRepositoryObjectType objectType = repositoryObject.getObjectType();
            IRepositoryAttributeSetType asType = objectType.getAttributeSetType(propertyTypeIDOfPropertyToModify);
            IRepositoryAttributeSet attributeSetToModify = repositoryObject.getAttributeSet(asType);
            RepositoryAttributeSetReference asReferenceToModify = new RepositoryAttributeSetReference(attributeSetToModify);
            IRepositoryPropertySetSample propertySetSampleOfAS = attributeSetToModify.sample();
            if (asRef2PropertySetSampleContent.containsKey((Object)asReferenceToModify)) {
                IMapRW_ propertyTypeID2PropertySample = (IMapRW_)asRef2PropertySetSampleContent.getByKey((Object)asReferenceToModify);
                propertyTypeID2PropertySample.replace((Object)propertyTypeIDOfPropertyToModify, (Object)newPropertySample);
                continue;
            }
            ICollection_<? extends IRepositoryPropertyType> allPropertyTypes = asType.getPropertyTypes();
            HashMap_ propertyTypeID2PropertySample = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
            for (IRepositoryPropertyType propertyTypeOfAS : allPropertyTypes) {
                IRepositoryPropertyTypeID propertyTypeIDOfAS = propertyTypeOfAS.getRepositoryPropertyTypeID();
                if (IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER.isEqual((Object)propertyTypeIDOfAS, (Object)propertyTypeIDOfPropertyToModify)) {
                    propertyTypeID2PropertySample.put((Object)propertyTypeIDOfAS, (Object)newPropertySample);
                    continue;
                }
                propertyTypeID2PropertySample.put((Object)propertyTypeIDOfAS, (Object)propertySetSampleOfAS.getPropertySample(propertyTypeIDOfAS));
            }
            asRef2PropertySetSampleContent.put((Object)asReferenceToModify, (Object)propertyTypeID2PropertySample);
        }
        for (IRepositoryAttributeSetReference asReference : asRef2PropertySetSampleContent.keySet()) {
            IMapRW_ propertyTypeID2PropertySample = (IMapRW_)asRef2PropertySetSampleContent.getByKey((Object)asReference);
            RepositoryPropertySetSample propertySetSample = new RepositoryPropertySetSample((IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample>)propertyTypeID2PropertySample);
            transaction.appendAction(reaFactory.createModifyAttributeSetAction(asReference, propertySetSample));
        }
        for (IEntry_ occurenceModificationDataEntry : this.getOccurrenceModificationData(snapshot)) {
            OccurrenceRelationContribution occRC = (OccurrenceRelationContribution)occurenceModificationDataEntry.getKey();
            Tuple occModificationData = (Tuple)occurenceModificationDataEntry.getValue();
            transaction.appendAction(reaFactory.createModifyOccurrenceAction(occRC, (ICollection_<IOccurrenceRepositoryRelationReference>)((ICollection_)occModificationData.getT1()), (ICollection_<IOccurrenceRepositoryRelationSample>)((ICollection_)occModificationData.getT2())));
        }
        RSAComplexGenericModification.checkChildCardinality(this.parentChildRelationsReferencesToCheckCardinality, snapshot);
        RSAComplexGenericModification.checkCrossLinkCardinality(this.crossLinkRelationsReferencesToCheckCardinality, snapshot);
    }

    private void createObject(RepositoryObjectSampleWithParentObjectReference objectToCreateWithParentAttributeSetReference, ISetRW_<IRepositoryObjectSample> alreadyCreatedObjects, IRepositoryTransactionContext transaction) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        IRepositoryObjectSample objectToCreate = objectToCreateWithParentAttributeSetReference.getObjectSample();
        if (!alreadyCreatedObjects.contains((Object)objectToCreate)) {
            IRepositoryElementaryActionFactory reaFactory = transaction.getElementaryActionFactory();
            IRepositoryTypeManagerRO typeManager = transaction.getSnapshot().getTypeManager();
            IRepositoryObjectReference parentObject = objectToCreateWithParentAttributeSetReference.getParentObjectReference();
            for (RepositoryObjectSampleWithParentObjectReference otherObjectToBeCreated : this.objectsToCreate) {
                IRepositoryObjectSample otherObjectToBeCreated_objectSample = otherObjectToBeCreated.getObjectSample();
                IRepositoryPropertySetSample otherObjectToBeCreated_objectID = otherObjectToBeCreated_objectSample.getObjectID(typeManager);
                IRepositoryObjectTypeID otherObjectToBeCreated_objectTypeID = otherObjectToBeCreated_objectSample.getObjectTypeID();
                if (!IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)otherObjectToBeCreated_objectID, (Object)parentObject.getObjectID()) || !IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)otherObjectToBeCreated_objectTypeID, (Object)parentObject.getObjectTypeID())) continue;
                this.createObject(otherObjectToBeCreated, alreadyCreatedObjects, transaction);
            }
            transaction.appendAction(reaFactory.createCreateObjectAction(parentObject, objectToCreate));
            alreadyCreatedObjects.add((Object)objectToCreate);
        }
    }

    private void deleteObject(IRepositoryObjectReference objectToDeleteReference, ISetRW_<IRepositoryObjectReference> alreadyDeletedObjects, IRepositoryTransactionContext transaction) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        if (!alreadyDeletedObjects.contains((Object)objectToDeleteReference)) {
            IRepositoryElementaryActionFactory reaFactory = transaction.getElementaryActionFactory();
            IRepositorySnapshotRO snapshot = transaction.getSnapshot();
            IRepositoryTypeManagerRO typeManager = snapshot.getTypeManager();
            IRepositoryObjectType objectType = typeManager.getObjectType(objectToDeleteReference.getObjectTypeID());
            RepositoryAttributeSetTypeID baseIDASTypeID = BaseRepositoryObjectTypeAttributeSetTypes.NonInherited.ID_ID;
            IRepositoryObject objectToDelete = RepositoryReferences.getObjectFromReference(objectToDeleteReference, snapshot);
            for (IRepositoryAttributeSetType asType : objectType.getAttributeSetTypes()) {
                IRepositoryAttributeSetTypeID asTypeID = asType.getRepositoryAttributeSetTypeID();
                if (IRepositoryAttributeSetTypeID.IS_EQUAL_ATTRIBUTE_SET_TYPE_ID_HASHER.isEqual((Object)asTypeID, (Object)baseIDASTypeID)) continue;
                for (IRepositoryObjectType childObjectType : asType.getChildObjectTypes()) {
                    IRepositoryIterator_IRepositoryObject itChildObjects = objectToDelete.getAttributeSet(asType).childObjectIterator(childObjectType);
                    while (itChildObjects.hasNext()) {
                        IRepositoryObject childObject = itChildObjects.nextIRepositoryObject();
                        RepositoryObjectReference childObjectReference = new RepositoryObjectReference(childObject);
                        if (this.objectsToDelete.contains((Object)childObjectReference)) {
                            this.deleteObject(childObjectReference, alreadyDeletedObjects, transaction);
                            continue;
                        }
                        throw new EXCannotDeleteObjectWithChildren(childObject.sample());
                    }
                }
            }
            transaction.appendAction(reaFactory.createDeleteObjectAction(objectToDeleteReference));
            alreadyDeletedObjects.add((Object)objectToDeleteReference);
        }
    }

    private static void checkChildCardinality(ICollectionRW_<ParentChildRelationContribution> parentChildRelationContributions, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXTransactionExecution {
        for (ParentChildRelationContribution parentChildRelationContribution : parentChildRelationContributions) {
            IRepositoryObjectReference parentObjectReference = parentChildRelationContribution.getParentObjectReference();
            IParentRepositoryRelationContributionType parentRelationContributionType = parentChildRelationContribution.getParentRelationContributionType();
            IRepositoryObjectType childObjectType = parentRelationContributionType.getRelatedRelationType().getChildRelationContributionType().getRelatedObjectType();
            IRepositoryObject parentObject = RepositoryReferences.getObjectFromReference(parentObjectReference, snapshot);
            RepositoryRelationContributionTypeCardinality rcTypeCardinality = parentRelationContributionType.getCardinality();
            int countElements = 0;
            boolean checkIsNecessary = true;
            IRepositoryObjectType concreteParentObjectType = parentObject.getObjectType();
            IRepositoryAttributeSetType abstractRepositoryAttributeSetType = parentRelationContributionType.getRelatedAttributeSetType();
            IRepositoryAttributeSetType concreteRepositoryAttributeSetType = concreteParentObjectType.getAttributeSetType(abstractRepositoryAttributeSetType.getRepositoryAttributeSetTypeID());
            IRepositoryIterator_IRepositoryObject iteratorChildObjects = parentObject.getAttributeSet(concreteRepositoryAttributeSetType).childObjectIterator(childObjectType);
            while (countElements < 2 && iteratorChildObjects.hasNext()) {
                iteratorChildObjects.nextIRepositoryObject();
                ++countElements;
            }
            if (iteratorChildObjects.hasNext()) {
                iteratorChildObjects.abortIteration();
            }
            if (!checkIsNecessary) continue;
            IRepositoryRelationTypeID relationTypeID = parentRelationContributionType.getRelatedRelationType().getRepositoryRelationTypeID();
            boolean checkFailed = false;
            if (rcTypeCardinality == RepositoryRelationContributionTypeCardinality.C0_1) {
                if (countElements > 1) {
                    checkFailed = true;
                }
            } else if (rcTypeCardinality == RepositoryRelationContributionTypeCardinality.C1_1) {
                if (countElements != 1) {
                    checkFailed = true;
                }
            } else if (rcTypeCardinality == RepositoryRelationContributionTypeCardinality.C1_n && countElements < 1) {
                checkFailed = true;
            }
            if (!checkFailed) continue;
            throw new EXParentChildRCTypeCardinalityViolated(relationTypeID, rcTypeCardinality, parentObjectReference);
        }
    }

    private static void checkCrossLinkCardinality(ICollectionRW_<CrossLinkRelationContribution> relationsReferences, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXTransactionExecution {
        for (CrossLinkRelationContribution crossLinkRelationContribution : relationsReferences) {
            IRepositoryPropertySetSample objectID;
            ICrossLinkRepositoryRelationContributionType crossLinkRCType = crossLinkRelationContribution.getRelationContributionType();
            ICrossLinkRepositoryRelationType relationType = crossLinkRCType.getRelatedRelationType();
            IRepositoryRelationTypeID relationTypeID = relationType.getRepositoryRelationTypeID();
            IRepositoryRelationContributionRoleID roleID = crossLinkRCType.getRepositoryRelationContributionRoleID();
            int countElements = 0;
            boolean checkIsNecessary = true;
            RepositoryRelationContributionTypeCardinality rcTypeCardinality = null;
            ArrayList_ allRoleIDsOfCurrentRelationType = new ArrayList_();
            rcTypeCardinality = relationType.getRelationContributionType(roleID).getCardinality();
            for (ICrossLinkRepositoryRelationContributionType rcType : relationType.getAllRelationContributionTypes()) {
                IRepositoryRelationContributionRoleID currentRoleID = rcType.getRepositoryRelationContributionRoleID();
                allRoleIDsOfCurrentRelationType.add((Object)currentRoleID);
            }
            try {
                objectID = crossLinkRelationContribution.getObjectID();
                IRepositoryIterator_ICrossLinkRepositoryRelation iteratorFoundRelations = RepositoryRelations.findAllCrossLinkRelationsRelationContributionIsPartOf(relationTypeID, objectID, roleID, snapshot);
                while (countElements < 2 && iteratorFoundRelations.hasNext()) {
                    iteratorFoundRelations.nextIRepositoryRelation();
                    ++countElements;
                }
                if (iteratorFoundRelations.hasNext()) {
                    iteratorFoundRelations.abortIteration();
                }
            }
            catch (EXMissingCrossLinkTarget ex) {
                checkIsNecessary = false;
                objectID = null;
            }
            if (!checkIsNecessary) continue;
            boolean checkFailed = false;
            if (rcTypeCardinality == RepositoryRelationContributionTypeCardinality.C0_1) {
                if (countElements > 1) {
                    checkFailed = true;
                }
            } else if (rcTypeCardinality == RepositoryRelationContributionTypeCardinality.C1_1) {
                if (countElements != 1) {
                    checkFailed = true;
                }
            } else if (rcTypeCardinality == RepositoryRelationContributionTypeCardinality.C1_n && countElements < 1) {
                checkFailed = true;
            }
            if (!checkFailed) continue;
            throw new EXCrossLinkRCTypeCardinalityViolated(relationType, roleID, objectID, rcTypeCardinality);
        }
    }

    public IMapRW_<OccurrenceRelationContribution, Tuple<ICollectionRW_<IOccurrenceRepositoryRelationReference>, ICollectionRW_<IOccurrenceRepositoryRelationSample>>> getOccurrenceModificationData(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        if (this.occurrenceModificationData == null) {
            this.occurrenceModificationData = TransactionHelper.determineOccurrenceModificationData(this.occurrenceRelationsToDelete, this.occurrenceRelationsToCreate, repositorySnapshot);
        }
        return this.occurrenceModificationData;
    }

    public IList_<RepositoryObjectSampleWithParentObjectReference> getObjectsToCreate() {
        return this.objectsToCreate;
    }

    public ISet_<ICrossLinkRepositoryRelationSample> getRelationsToCreate() {
        return this.relationsToCreate;
    }

    public ISet_<IRepositoryObjectReference> getObjectsToDelete() {
        return this.objectsToDelete;
    }

    public ISet_<ICrossLinkRepositoryRelationReference> getRelationsToDelete() {
        return this.relationsToDelete;
    }

    public IMap_<IRepositoryPropertyReference, IRepositoryPropertySample> getPropertiesToModify() {
        return this.propertiesToModify;
    }

    public Collection<Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID>> getObjectTypeCategoriesToChange() {
        return this.objectTypeCategoriesToChange;
    }

    @Override
    public String getName() {
        return "repository semantic action complex generic modification";
    }
}

