/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.plugin.extensions;

import com.arcway.lib.extensioning.ObjectExtensionPoint;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.plugin.ARCWAYRepositoryInterfacePlugin;
import com.arcway.repository.interFace.registration.type.IRepositoryDataTypeExtension;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;

public final class RepositoryDataTypeExtensionPoint
extends ObjectExtensionPoint {
    private static final ILogger LOGGER = Logger.getLogger(RepositoryDataTypeExtensionPoint.class);
    private static final String EXTENSION_POINT_ID = "repositorydatatypeextension";
    private static final String CONFIG_ELEMENT_NAME = "repositorydatatypeextension";
    private static final String ATTRIBUTE_NAME = "repositorydatatypeextension";
    private static final Class<?> INSTANCE_CLASS = IRepositoryDataTypeExtension.class;
    private static RepositoryDataTypeExtensionPoint INSTANCE = null;
    private ICollection_<IRepositoryDataTypeRegistration> cachedRegistrations;
    private IMap_<IRepositoryDataTypeID, IRepositoryDataType> map_dataTypeID_dataType;

    private RepositoryDataTypeExtensionPoint() {
        super(ARCWAYRepositoryInterfacePlugin.getDefault(), "repositorydatatypeextension", "repositorydatatypeextension", "repositorydatatypeextension", INSTANCE_CLASS);
    }

    public static final synchronized RepositoryDataTypeExtensionPoint getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RepositoryDataTypeExtensionPoint();
        }
        return INSTANCE;
    }

    protected void storeCreatedObjects(ICollection_<Object> instances) {
        ArrayList_ concreteInstances = new ArrayList_();
        HashMap_ map_dataTypeID_dataType_RW = new HashMap_(IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER);
        for (Object currentObject : instances) {
            IRepositoryDataTypeExtension extension = (IRepositoryDataTypeExtension)currentObject;
            ICollection_<IRepositoryDataTypeRegistration> registrations = extension.getRepositoryDataTypeRegistrations();
            concreteInstances.addAll(registrations);
            for (IRepositoryDataTypeRegistration registration : registrations) {
                IRepositoryDataType dataType = registration.getRepositoryDataType();
                IRepositoryDataTypeID dataTypeID = dataType.getRepositoryDataTypeID();
                if (map_dataTypeID_dataType_RW.getByKey((Object)dataTypeID) == null) {
                    map_dataTypeID_dataType_RW.put((Object)dataTypeID, (Object)dataType);
                    continue;
                }
                LOGGER.warn("Duplicate data type registration for id \"" + dataTypeID.toCanonicalString() + "\".");
            }
        }
        this.cachedRegistrations = concreteInstances;
        this.map_dataTypeID_dataType = map_dataTypeID_dataType_RW;
    }

    public ICollection_<IRepositoryDataTypeRegistration> getRepositoryDataTypeRegistrations() {
        return this.cachedRegistrations;
    }

    public IRepositoryDataType getRepositoryDataType(IRepositoryDataTypeID dataTypeID) {
        return (IRepositoryDataType)this.map_dataTypeID_dataType.getByKey((Object)dataTypeID);
    }
}

