/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT.importjobeditors.automatic;

import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.importexport.imporT.IImportJobEditor;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportJob;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObjectType;
import java.util.Collection;

public class AIJEObjectTypeCategoryToObjectAssigner
implements IImportJobEditor {
    private final ISet_<IRepositoryObjectTypeID> objectTypesToBeConsidered;

    public AIJEObjectTypeCategoryToObjectAssigner() {
        this.objectTypesToBeConsidered = null;
    }

    public AIJEObjectTypeCategoryToObjectAssigner(Collection<IRepositoryObjectTypeID> objectTypesToBeConsidered) {
        this.objectTypesToBeConsidered = new HashSet_(objectTypesToBeConsidered, IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
    }

    @Override
    public IImportJobEditor.ResultCode editImportJob(IImportJob importJob, IRepositorySnapshotRO snapshot, boolean executionMessagesOccurred) throws EXNotReproducibleSnapshot {
        this.handleObjectTypes(importJob.getImportedObjectTypes());
        return IImportJobEditor.ResultCode.COMPLETED_NOMORECALLS;
    }

    private void handleObjectTypes(Collection<? extends IImportedObjectType> objectTypes) throws EXNotReproducibleSnapshot {
        for (IImportedObjectType iImportedObjectType : objectTypes) {
            if (this.objectTypesToBeConsidered != null && RepositoryObjectTypes.findMostSpecificSuperObjectType(iImportedObjectType.getObjectType(), this.objectTypesToBeConsidered) == null) continue;
            AIJEObjectTypeCategoryToObjectAssigner.handleObjectType(iImportedObjectType);
        }
    }

    private static void handleObjectType(IImportedObjectType objectType) throws EXNotReproducibleSnapshot {
        for (IImportedObject iImportedObject : objectType.getObjects()) {
            iImportedObject.setToBeRepositoryObjectTypeCategory(iImportedObject.getImportedObjectTypeCategory() != null ? iImportedObject.getImportedObjectTypeCategory().getMatchingObjectTypeCategoryID() : null);
        }
    }
}

