/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT.importjob.impl;

import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.IListenerCaller;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.listener.ListenerManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryFileArchive;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILockDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.MessageSet;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRO;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRW;
import com.arcway.repository.interFace.importexport.imporT.ImportTransactionFactory;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ContextObjectType;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.CrossLinkRelationType;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.IImportJobRelatedItem;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportedObjectType;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.OccurrenceRelationType;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.OccurringRelationContributionTypeKey;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportJobChangeListener;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportJob;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.transactions.AbstractRepositoryAction;
import com.arcway.repository.interFace.transactions.IRepositoryTransaction;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RSAComplexGenericModification;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.TransactionLockAllocator;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportJob
implements IImportJob,
IImportJobRelatedItem {
    private static final ILogger LOGGER = Logger.getLogger(ImportJob.class);
    private final ImportTransactionFactory transactionFactory = new ImportTransactionFactory(this);
    private final List<IRepositoryData> temporaryFiles = new ArrayList<IRepositoryData>();
    private Collection<ILockDeprecated> temporaryLocks = null;
    private final IMessageSet interpretationMessages;
    private IMessageSet lockMessages = new MessageSet();
    private final IMapRW_<IRepositoryObjectTypeID, ImportedObjectType> importedObjectTypes = new HashMap_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
    private final IMapRW_<IRepositoryObjectTypeID, ContextObjectType> contextObjectTypes = new HashMap_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
    private final IMapRW_<IRepositoryRelationTypeID, CrossLinkRelationType> crossLinkRelationTypes = new HashMap_(IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER);
    private final Map<OccurringRelationContributionTypeKey, OccurrenceRelationType> occurrenceRelationTypes = new HashMap<OccurringRelationContributionTypeKey, OccurrenceRelationType>();
    private final IRepositoryFileArchive fileArchive;
    private final ListenerManager<IImportJobChangeListener> changeListenerManager = new ListenerManager();

    public ImportJob(IMessageSet interpretationMessages, IRepositoryFileArchive fileArchive) {
        this.interpretationMessages = interpretationMessages;
        this.fileArchive = fileArchive;
    }

    @Override
    public void addChangeListener(ListenerKey key, IImportJobChangeListener listener) {
        this.changeListenerManager.addListener(key, (IDisposeListener)listener);
    }

    @Override
    public IImportJobChangeListener removeChangeListener(ListenerKey key) {
        return (IImportJobChangeListener)this.changeListenerManager.removeListener(key);
    }

    @Override
    public IImportJobChangeListener getListener(ListenerKey key) {
        return (IImportJobChangeListener)this.changeListenerManager.getListener(key);
    }

    @Override
    public void fireChange() throws EXNotReproducibleSnapshot {
        final EXNotReproducibleSnapshot[] exnrs = new EXNotReproducibleSnapshot[1];
        this.changeListenerManager.callListeners((IListenerCaller)new IListenerCaller<IImportJobChangeListener>(){

            public void callListener(IImportJobChangeListener listener) {
                try {
                    listener.importJobChanged();
                }
                catch (EXNotReproducibleSnapshot e) {
                    exnrs[0] = e;
                }
            }
        });
        if (exnrs[0] != null) {
            throw exnrs[0];
        }
    }

    @Override
    public Tuple<Boolean, IMessageSet> isExecutable(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        MessageSet messages = new MessageSet();
        Tuple<RSAComplexGenericModification, IMessageSet> importTransactionAndMessages = this.transactionFactory.createImportTransaction(repositorySnapshot);
        messages.addAll((IMessageSet)importTransactionAndMessages.getT2());
        Tuple<Boolean, IMessageSet> validationResult = ((RSAComplexGenericModification)importTransactionAndMessages.getT1()).validate(repositorySnapshot);
        Boolean isExecutable = (Boolean)validationResult.getT1();
        IMessageSet validationMessages = (IMessageSet)validationResult.getT2();
        messages.addAll(validationMessages);
        return new Tuple((Object)isExecutable, (Object)messages);
    }

    @Override
    public void updateLocks(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        Tuple<IMessageSet, Collection<ILockDeprecated>> lockAllocationResult = this.allocateLocks(repositorySnapshot);
        this.lockMessages = (IMessageSet)lockAllocationResult.getT1();
        this.releaseLocks((Collection)lockAllocationResult.getT2());
        this.fireChange();
    }

    @Override
    public IMessageSet getLockMessages() {
        return this.lockMessages;
    }

    private Tuple<IMessageSet, Collection<ILockDeprecated>> allocateLocks(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        Tuple<RSAComplexGenericModification, IMessageSet> importTransactionAndMessages = this.transactionFactory.createImportTransaction(repositorySnapshot);
        Tuple<IMessageSet, Collection<ILockDeprecated>> lockResult = TransactionLockAllocator.allocateLocks((RSAComplexGenericModification)importTransactionAndMessages.getT1(), repositorySnapshot);
        return lockResult;
    }

    public IMessageSet execute(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        IMessageSet executionMessages = this.executeImport(repositorySnapshot);
        if (executionMessages.isEmpty()) {
            this.releaseLocks(null);
            this.fireChange();
        }
        return executionMessages;
    }

    /*
     * Loose catch block
     */
    private IMessageSet executeImport(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        MessageSet messages;
        block10: {
            IRepositoryInterfaceRO repositoryInterface = repositorySnapshot.getRepositoryInterface();
            IRepositoryWorkspaceRO workspace = repositoryInterface.getWorkspace();
            assert (workspace instanceof IRepositoryWorkspaceRW);
            IRepositoryWorkspaceRW workspaceRW = (IRepositoryWorkspaceRW)workspace;
            messages = new MessageSet();
            Tuple<RSAComplexGenericModification, IMessageSet> importTransactionAndMessages = this.transactionFactory.createImportTransaction(repositorySnapshot);
            IRepositoryTransaction repositoryTransaction = workspaceRW.getTransactionManager().openTransaction(RepositorySamples.getSnapshotID(repositorySnapshot.getSnapshotInformation(), repositoryInterface.getTypeManager()));
            try {
                try {
                    repositoryTransaction.appendAction((AbstractRepositoryAction)importTransactionAndMessages.getT1());
                }
                catch (EXTransactionExecution e) {
                    messages.add(e);
                    repositoryTransaction.closeTransaction();
                }
                catch (EXPermissionDenied e) {
                    messages.add(e);
                    repositoryTransaction.closeTransaction();
                }
                catch (EXLockDenied e) {
                    messages.add(e);
                    repositoryTransaction.closeTransaction();
                    break block10;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                repositoryTransaction.closeTransaction();
            }
        }
        return messages;
    }

    public boolean loadImportedTempFile(IStreamResource file, IRepositoryData originalFileReference, IRepositoryObjectSample sourceCreationSnapshotInformation, long sourceCreationDate, IRepositoryPropertyType propertyType) {
        try {
            RDTFile fileDataType = RDTFile.getInstance();
            boolean isNew = fileDataType.loadFileIntoTemporaryStorage(file, originalFileReference, sourceCreationSnapshotInformation, sourceCreationDate, this.fileArchive);
            if (isNew) {
                fileDataType.snapAndCheckData(originalFileReference, propertyType.getDataTypeParameters());
                this.temporaryFiles.add(originalFileReference);
            }
            return true;
        }
        catch (RDTFile.EXFilenamePostifxInvalid eFPI) {
            LOGGER.error("File could not be loaded into temporary storage.", (Throwable)eFPI);
            return false;
        }
        catch (AbstractRepositoryDataType.EXValueNotSet eVNS) {
            LOGGER.error("File could not be loaded into temporary storage.", (Throwable)eVNS);
            return false;
        }
        catch (EXValueInvalid eVI) {
            LOGGER.error("File could not be loaded into temporary storage.", (Throwable)eVI);
            return false;
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            LOGGER.error("File could not be loaded into temporary storage.", (Throwable)jeriE);
            return false;
        }
    }

    @Override
    public IRepositoryData loadUserProvidedTempFile(IStreamResource file, IRepositoryPropertyType propertyType) throws EXNotReproducibleSnapshot {
        try {
            RDTFile fileDataType = RDTFile.getInstance();
            IRepositoryData fileReference = fileDataType.loadFileIntoTemporaryStorage(file, this.fileArchive);
            fileDataType.snapAndCheckData(fileReference, propertyType.getDataTypeParameters());
            this.temporaryFiles.add(fileReference);
            this.fireChange();
            return fileReference;
        }
        catch (RDTFile.EXFilenamePostifxInvalid eFPI) {
            LOGGER.error("File could not be loaded into temporary storage.", (Throwable)eFPI);
            return null;
        }
        catch (AbstractRepositoryDataType.EXValueNotSet eVNS) {
            LOGGER.error("File could not be loaded into temporary storage.", (Throwable)eVNS);
            return null;
        }
        catch (EXValueInvalid eVI) {
            LOGGER.error("File could not be loaded into temporary storage.", (Throwable)eVI);
            return null;
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            LOGGER.error("File could not be loaded into temporary storage.", (Throwable)jeriE);
            return null;
        }
    }

    @Override
    public IMessageSet getInterpretationMessages() {
        return this.interpretationMessages;
    }

    public Collection<ImportedObjectType> getImportedObjectTypes() {
        return Collections.unmodifiableCollection(this.importedObjectTypes.values().asJavaCollection());
    }

    @Override
    public ImportedObjectType getImportedObjectType(IRepositoryObjectTypeID repositoryObjectTypeID) {
        return (ImportedObjectType)this.importedObjectTypes.getByKey((Object)repositoryObjectTypeID);
    }

    public ImportedObjectType createOrGetImportedObjectType(IRepositoryObjectType objectType) {
        IRepositoryObjectTypeID objectTypeID = objectType.getRepositoryObjectTypeID();
        ImportedObjectType importedObjectType = this.getImportedObjectType(objectTypeID);
        if (importedObjectType == null) {
            importedObjectType = new ImportedObjectType(this, objectType);
            this.importedObjectTypes.put((Object)objectTypeID, (Object)importedObjectType);
        }
        return importedObjectType;
    }

    public Collection<ContextObjectType> getContextObjectTypes() {
        return Collections.unmodifiableCollection(this.contextObjectTypes.values().asJavaCollection());
    }

    @Override
    public ContextObjectType getContextObjectType(IRepositoryObjectTypeID objectTypeID) {
        return (ContextObjectType)this.contextObjectTypes.getByKey((Object)objectTypeID);
    }

    public ContextObjectType createOrGetContextObjectType(IRepositoryObjectType objectType) {
        IRepositoryObjectTypeID objectTypeID = objectType.getRepositoryObjectTypeID();
        ContextObjectType importedObjectType = this.getContextObjectType(objectTypeID);
        if (importedObjectType == null) {
            importedObjectType = new ContextObjectType(this, objectType);
            this.contextObjectTypes.put((Object)objectTypeID, (Object)importedObjectType);
        }
        return importedObjectType;
    }

    public Collection<CrossLinkRelationType> getCrossLinkRelationTypes() {
        return Collections.unmodifiableCollection(this.crossLinkRelationTypes.values().asJavaCollection());
    }

    @Override
    public CrossLinkRelationType getCrossLinkRelationType(IRepositoryRelationTypeID relationTypeID) {
        return (CrossLinkRelationType)this.crossLinkRelationTypes.getByKey((Object)relationTypeID);
    }

    public CrossLinkRelationType createOrGetCrossLinkRelationType(ICrossLinkRepositoryRelationType relationType) {
        IRepositoryRelationTypeID relationTypeID = relationType.getRepositoryRelationTypeID();
        CrossLinkRelationType crossLinkRelationType = this.getCrossLinkRelationType(relationTypeID);
        if (crossLinkRelationType == null) {
            crossLinkRelationType = new CrossLinkRelationType(this, relationType);
            this.crossLinkRelationTypes.put((Object)relationTypeID, (Object)crossLinkRelationType);
        }
        return crossLinkRelationType;
    }

    public Collection<OccurrenceRelationType> getOccurrenceRelationTypes() {
        return Collections.unmodifiableCollection(this.occurrenceRelationTypes.values());
    }

    @Override
    public OccurrenceRelationType getOccurrenceRelationType(IRepositoryObjectTypeID objectTypeID, IRepositoryPropertyTypeID propertyTypeID) {
        return this.occurrenceRelationTypes.get(new OccurringRelationContributionTypeKey(objectTypeID, propertyTypeID));
    }

    public OccurrenceRelationType createOrGetOccurrenceRelationType(IRepositoryPropertyType propertyType) {
        OccurringRelationContributionTypeKey key = new OccurringRelationContributionTypeKey(propertyType.getAttributeSetType().getObjectType().getRepositoryObjectTypeID(), propertyType.getRepositoryPropertyTypeID());
        OccurrenceRelationType crossLinkRelationType = this.occurrenceRelationTypes.get(key);
        if (crossLinkRelationType == null) {
            crossLinkRelationType = new OccurrenceRelationType(this, propertyType);
            this.occurrenceRelationTypes.put(key, crossLinkRelationType);
        }
        return crossLinkRelationType;
    }

    public void dispose() {
        this.changeListenerManager.dispose();
        for (IRepositoryData file : this.temporaryFiles) {
            RDTFile fileDataType = RDTFile.getInstance();
            fileDataType.removeFileFromTemporaryStorage(file, this.fileArchive);
        }
        this.releaseLocks(null);
    }

    private void releaseLocks(Collection<ILockDeprecated> newLocks) {
        if (this.temporaryLocks != null) {
            for (ILockDeprecated temporaryLock : this.temporaryLocks) {
                temporaryLock.release();
            }
        }
        this.temporaryLocks = newLocks;
    }
}

