/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT.importjob;

import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.data.relationcontribution.IRepositoryIterator_ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.MessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.importexport.exceptions.EXMissingObject;
import com.arcway.repository.interFace.importexport.exceptions.EXOccurrenceContainingObjectNotImported;
import com.arcway.repository.interFace.importexport.exceptions.EXOccurrenceContainingObjectNotMatched;
import com.arcway.repository.interFace.importexport.exceptions.EXOccurringObjectNotImported;
import com.arcway.repository.interFace.importexport.exceptions.EXOccurringObjectNotMatched;
import com.arcway.repository.interFace.importexport.exceptions.EXRelatedObject;
import com.arcway.repository.interFace.importexport.exceptions.EXRelatedObjectNotImported;
import com.arcway.repository.interFace.importexport.exceptions.EXRelatedObjectNotMatched;
import com.arcway.repository.interFace.importexport.imporT.importjob.RelationSampleWithObjectTypes;
import com.arcway.repository.interFace.importexport.imporT.importjob.RelationSampleWithRelationCreationRequests;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IContextObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IContextObjectTypeRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.ICrossLinkRelationContributionTypeForContextObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.ICrossLinkRelationContributionTypeForImportedObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.ICrossLinkRelationContributionTypeRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.ICrossLinkRelationRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.ICrossLinkRelationTypeRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportJobRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportedObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportedObjectTypeRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IOccurrenceRelationRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IPropertyRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IRelationRelatedRequestRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.ICrossLinkRelationContributionTypeForImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IProperty;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.implementation.access.OccurrenceRepositoryRelationReference;
import com.arcway.repository.lib.high.implementation.access.OccurrenceRepositoryRelationSample;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectSample;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectTypeCategoryReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import java.util.ArrayList;
import java.util.Collection;

public class ImportJobHelper {
    public static final boolean isPropertyModified(IPropertyRO property, IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        boolean propertyIsModified = false;
        try {
            IRepositoryPropertyReference propertyReference = ImportJobHelper.getPropertyReference(property);
            IRepositoryData toBeValue = property.getToBeValue();
            if (toBeValue == null) {
                toBeValue = ImportJobHelper.determineEffectivePropertyValueIfToBeValueIsNullDependingOnImportMode(property, repositorySnapshot);
            }
            IRepositoryProperty currentPropertyValue = RepositoryReferences.getPropertyFromReference(propertyReference, repositorySnapshot);
            boolean toBeValueEqualsCurrentValue = toBeValue.getDataType().getEqualComparator().isEqual(property.getToBeValue(), currentPropertyValue.getValue());
            if (!toBeValueEqualsCurrentValue) {
                propertyIsModified = true;
            }
        }
        catch (EXObjectReferenceCannotBeResolved eXObjectReferenceCannotBeResolved) {
        }
        catch (RelatedObjectNotMatched relatedObjectNotMatched) {
            // empty catch block
        }
        return propertyIsModified;
    }

    public static final boolean isPropertyAssumingImportedValue(IPropertyRO property, IRepositorySnapshotRO repositorySnapshot) {
        boolean isImportedValueAssumed = false;
        if (property.getImportedValue() != null) {
            IRepositoryData toBeValue = property.getToBeValue();
            if (toBeValue == null) {
                toBeValue = ImportJobHelper.determineEffectivePropertyValueIfToBeValueIsNullDependingOnImportMode(property, repositorySnapshot);
            }
            isImportedValueAssumed = toBeValue.getDataType().getEqualComparator().isEqual(property.getToBeValue(), property.getImportedValue());
        }
        return isImportedValueAssumed;
    }

    public static final IRepositoryData determineEffectivePropertyValueIfToBeValueIsNullDependingOnImportMode(IPropertyRO property, IRepositorySnapshotRO snapshot) {
        IRepositoryData toBeValue = null;
        int importMode = property.getObject().getImportMode();
        if (importMode == 2) {
            toBeValue = ImportJobHelper.getPropertyValueOfMatchingObject(property, snapshot);
        }
        if (toBeValue == null) {
            toBeValue = property.getImportedValue();
        }
        return toBeValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final IRepositoryData getPropertyValueOfMatchingObject(IPropertyRO property, IRepositorySnapshotRO snapshot) {
        try {
            IRepositoryPropertyReference currentPropertyRef = ImportJobHelper.getPropertyReference(property);
            try {
                IRepositoryProperty currentProperty = RepositoryReferences.getPropertyFromReference(currentPropertyRef, snapshot);
                return currentProperty.getValue();
            }
            catch (EXObjectReferenceCannotBeResolved e) {
                return null;
            }
            catch (EXNotReproducibleSnapshot e) {
                return null;
            }
        }
        catch (RelatedObjectNotMatched e1) {
            return null;
        }
    }

    public static final IRepositoryObjectTypeCategoryID determineEffectiveObjectTypeCategoryValueIfToBeValueIsNotSet(IImportedObjectRO object, IRepositorySnapshotRO snapshot) {
        IRepositoryObjectTypeCategoryID toBeValue = null;
        int importMode = object.getImportMode();
        if (importMode == 2) {
            toBeValue = ImportJobHelper.getObjectTypeCategoryValueOfMatchingObject(object, snapshot);
        }
        if (toBeValue == null) {
            toBeValue = object.getImportedObjectTypeCategory() != null ? object.getImportedObjectTypeCategory().getMatchingObjectTypeCategoryID() : null;
        }
        return toBeValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final IRepositoryObjectTypeCategoryID getObjectTypeCategoryValueOfMatchingObject(IImportedObjectRO object, IRepositorySnapshotRO snapshot) {
        try {
            IRepositoryObjectReference matchingObjectReference = ImportJobHelper.getObjectReference(object);
            try {
                IRepositoryObject matchingObject = RepositoryReferences.getObjectFromReference(matchingObjectReference, snapshot);
                IRepositoryObjectTypeCategory objectTypeCategory = matchingObject.getObjectTypeCategory();
                if (objectTypeCategory == null) return null;
                IRepositoryObjectTypeCategoryID iRepositoryObjectTypeCategoryID = objectTypeCategory.getObjectTypeCategoryID();
                return iRepositoryObjectTypeCategoryID;
            }
            catch (EXObjectReferenceCannotBeResolved e) {
                return null;
            }
            catch (EXNotReproducibleSnapshot e) {
                return null;
            }
        }
        catch (RelatedObjectNotMatched e1) {
            return null;
        }
    }

    public static final IRepositoryObjectSample getObjectSample(IImportedObject importedObject, IRepositorySnapshotRO repositorySnapshot) {
        HashMap_ propertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        for (IProperty iProperty : importedObject.getProperties()) {
            IRepositoryData propertyValue = iProperty.getToBeValue();
            if (propertyValue == null) {
                propertyValue = ImportJobHelper.determineEffectivePropertyValueIfToBeValueIsNullDependingOnImportMode(iProperty, repositorySnapshot);
            }
            propertySamples.put((Object)iProperty.getRepositoryPropertyType().getRepositoryPropertyTypeID(), (Object)new RepositoryPropertySample(propertyValue));
        }
        RepositoryObjectSample repositoryObjectSample = new RepositoryObjectSample(importedObject.getObjectType().getObjectType(), importedObject.getToBeRepositoryObjectTypeCategory(), (IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample>)propertySamples);
        return repositoryObjectSample;
    }

    /*
     * WARNING - void declaration
     */
    public static final Tuple<RelationSampleWithObjectTypes, IMessageSet> getRelationSampleForImportedRelation(ICrossLinkRelationRO relation) {
        void var9_13;
        MessageSet messages = new MessageSet();
        HashMap_ roleID2ObjectID = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        HashMap_ roleID2ObjectType = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        Collection<? extends ICrossLinkRelationContributionTypeRO> getRelationContributions = relation.getRelationContributions();
        HashMap_ relatedObjectOKContributions = new HashMap_(getRelationContributions.size(), IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        ArrayList<ICrossLinkRelationContributionTypeRO> relatedObjectNotMatchedContributions = new ArrayList<ICrossLinkRelationContributionTypeRO>(getRelationContributions.size());
        ArrayList<ICrossLinkRelationContributionTypeRO> relatedObjectNotImportedContributions = new ArrayList<ICrossLinkRelationContributionTypeRO>(getRelationContributions.size());
        boolean allRelatedObjectsAreDefined = true;
        for (ICrossLinkRelationContributionTypeRO iCrossLinkRelationContributionTypeRO : getRelationContributions) {
            IRepositoryPropertySetSample objectID;
            try {
                objectID = ImportJobHelper.getObjectIDOfRelatedObject(iCrossLinkRelationContributionTypeRO.getRelatedObject());
                relatedObjectOKContributions.put((Object)iCrossLinkRelationContributionTypeRO.getRelationContributionType().getRepositoryRelationContributionRoleID(), (Object)objectID);
            }
            catch (RelatedObjectNotMatched e) {
                relatedObjectNotMatchedContributions.add(iCrossLinkRelationContributionTypeRO);
                allRelatedObjectsAreDefined = false;
                continue;
            }
            catch (RelatedObjectNotImported e) {
                relatedObjectNotImportedContributions.add(iCrossLinkRelationContributionTypeRO);
                allRelatedObjectsAreDefined = false;
                continue;
            }
            roleID2ObjectID.put((Object)iCrossLinkRelationContributionTypeRO.getRelationContributionType().getRepositoryRelationContributionRoleID(), (Object)objectID);
            roleID2ObjectType.put((Object)iCrossLinkRelationContributionTypeRO.getRelationContributionType().getRepositoryRelationContributionRoleID(), (Object)iCrossLinkRelationContributionTypeRO.getRelatedObject().getObjectType().getObjectType().getRepositoryObjectTypeID());
        }
        if (allRelatedObjectsAreDefined) {
            RelationSampleWithObjectTypes relationSampleWithObjectTypes = new RelationSampleWithObjectTypes(relation.getRelationType().getRelationType().getRepositoryRelationTypeID(), (IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample>)roleID2ObjectID, (IMap_<IRepositoryRelationContributionRoleID, IRepositoryObjectTypeID>)roleID2ObjectType);
        } else {
            EXRelatedObject e;
            Object var9_12 = null;
            ICrossLinkRepositoryRelationType relationType = relation.getRelationType().getRelationType();
            if (!relatedObjectNotMatchedContributions.isEmpty()) {
                e = new EXRelatedObjectNotMatched(relationType, (IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample>)relatedObjectOKContributions, relatedObjectNotMatchedContributions, relatedObjectNotImportedContributions);
                messages.add(e);
            }
            if (!relatedObjectNotImportedContributions.isEmpty()) {
                e = new EXRelatedObjectNotImported(relationType, (IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample>)relatedObjectOKContributions, relatedObjectNotImportedContributions, relatedObjectNotMatchedContributions);
                messages.add(e);
            }
        }
        return new Tuple((Object)var9_13, (Object)messages);
    }

    private static final Tuple<RelationSampleWithRelationCreationRequests, RepositoryAccessException> getRelationSampleForRelationCreationRequest(ICrossLinkRelationContributionTypeForImportedObjectRO contributionTypeForImportedObject, IRelationRelatedRequestRO relationCreationRequest) {
        HashMap_ roleID2ObjectID = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        HashMap_ roleID2ObjectType = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        EXRelatedObject exception = null;
        Exception relatedObjectException = null;
        try {
            IRepositoryRelationContributionRoleID roleID = contributionTypeForImportedObject.getRelationContributionType().getRepositoryRelationContributionRoleID();
            IRepositoryPropertySetSample objectID = ImportJobHelper.getObjectIDOfRelatedObject(contributionTypeForImportedObject.getRelatedObject());
            roleID2ObjectID.put((Object)roleID, (Object)objectID);
            IRepositoryObjectTypeID objectTypeID = contributionTypeForImportedObject.getRelatedObject().getObjectType().getObjectType().getRepositoryObjectTypeID();
            roleID2ObjectType.put((Object)roleID, (Object)objectTypeID);
        }
        catch (RelatedObjectNotMatched e) {
            relatedObjectException = e;
        }
        catch (RelatedObjectNotImported e) {
            relatedObjectException = e;
        }
        RelationSampleWithRelationCreationRequests sample = null;
        if (relatedObjectException == null) {
            for (IEntry_ entry : relationCreationRequest.getRelatedObjects()) {
                roleID2ObjectID.put((Object)((IRepositoryRelationContributionRoleID)entry.getKey()), (Object)((IRepositoryObjectReference)entry.getValue()).getObjectID());
                roleID2ObjectType.put((Object)((IRepositoryRelationContributionRoleID)entry.getKey()), (Object)((IRepositoryObjectReference)entry.getValue()).getObjectTypeID());
            }
            sample = new RelationSampleWithRelationCreationRequests(contributionTypeForImportedObject.getRelationType().getRelationType().getRepositoryRelationTypeID(), (IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample>)roleID2ObjectID, (IMap_<IRepositoryRelationContributionRoleID, IRepositoryObjectTypeID>)roleID2ObjectType, relationCreationRequest, (ICrossLinkRelationContributionTypeForImportedObject)contributionTypeForImportedObject);
        } else {
            HashMap_ relatedObjectOKContributions = new HashMap_(relationCreationRequest.getRelatedObjects().size(), IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
            ArrayList<ICrossLinkRelationContributionTypeRO> relatedObjectNotMatchedContributions = new ArrayList<ICrossLinkRelationContributionTypeRO>();
            ArrayList<ICrossLinkRelationContributionTypeRO> relatedObjectNotImportedContributions = new ArrayList<ICrossLinkRelationContributionTypeRO>();
            for (IEntry_ entry : relationCreationRequest.getRelatedObjects()) {
                relatedObjectOKContributions.put((Object)((IRepositoryRelationContributionRoleID)entry.getKey()), (Object)((IRepositoryObjectReference)entry.getValue()).getObjectID());
            }
            ICrossLinkRepositoryRelationType relationType = contributionTypeForImportedObject.getRelationType().getRelationType();
            if (relatedObjectException instanceof RelatedObjectNotMatched) {
                relatedObjectNotMatchedContributions.add(contributionTypeForImportedObject);
                exception = new EXRelatedObjectNotMatched(relationType, (IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample>)relatedObjectOKContributions, relatedObjectNotMatchedContributions, relatedObjectNotImportedContributions);
            }
            if (relatedObjectException instanceof RelatedObjectNotImported) {
                relatedObjectNotImportedContributions.add(contributionTypeForImportedObject);
                exception = new EXRelatedObjectNotImported(relationType, (IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample>)relatedObjectOKContributions, relatedObjectNotImportedContributions, relatedObjectNotMatchedContributions);
            }
        }
        return new Tuple((Object)sample, exception);
    }

    public static final Tuple<ISet_<RelationSampleWithObjectTypes>, RepositoryAccessException> findExistingRelations(ICrossLinkRelationContributionTypeRO relationContributionTypeForObject, IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        HashSet_ relationSamples = new HashSet_(ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        EXMissingObject message = null;
        IRepositoryObjectReference matchingObjectReference = relationContributionTypeForObject.getRelatedObject().getMatchingObject();
        if (matchingObjectReference != null) {
            try {
                IRepositoryObject matchingObject = RepositoryReferences.getObjectFromReference(matchingObjectReference, repositorySnapshot);
                ICrossLinkRepositoryRelationContributionType relationContributionType = relationContributionTypeForObject.getRelationContributionType();
                IRepositoryAttributeSetType attributeSetType = relationContributionType.getRelatedAttributeSetType();
                IRepositoryIterator_ICrossLinkRepositoryRelationContribution relationContributionIterator = matchingObject.getAttributeSet(attributeSetType).relationContributionIterator(relationContributionType);
                while (relationContributionIterator.hasNext()) {
                    ICrossLinkRepositoryRelationContribution relationContribution = relationContributionIterator.nextIRepositoryRelationContribution();
                    ICrossLinkRepositoryRelation relation = relationContribution.getRelation();
                    relationSamples.add((Object)new RelationSampleWithObjectTypes(relation));
                }
            }
            catch (EXObjectReferenceCannotBeResolved eORCNBR) {
                message = new EXMissingObject(matchingObjectReference);
            }
        }
        return new Tuple((Object)relationSamples, message);
    }

    public static final ThreeTuple<ISet_<RelationSampleWithRelationCreationRequests>, ISet_<RelationSampleWithObjectTypes>, IMessageSet> getRelationSamplesForCreationAndDeletionRequests(ICrossLinkRelationTypeRO relationType, IImportJobRO importJob, IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        HashSet_ creationRequests = new HashSet_(ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        HashSet_ deletionRequests = new HashSet_(ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        MessageSet messages = new MessageSet();
        IRepositoryRelationTypeID relationTypeID = relationType.getRelationType().getRepositoryRelationTypeID();
        for (ICrossLinkRepositoryRelationContributionType contributionType : relationType.getRelationType().getAllRelationContributionTypes()) {
            Tuple<ISet_<RelationSampleWithObjectTypes>, RepositoryAccessException> samplesAndMessages;
            IRepositoryRelationContributionRoleID roleID = contributionType.getRepositoryRelationContributionRoleID();
            IRepositoryObjectType relatedObjectType = contributionType.getRelatedObjectType();
            for (IImportedObjectTypeRO importedObjectType : importJob.getImportedObjectTypes()) {
                if (!importedObjectType.getObjectType().isSubTypeOf(relatedObjectType)) continue;
                for (IImportedObjectRO importedObject : importedObjectType.getObjects()) {
                    ICrossLinkRelationContributionTypeForImportedObjectRO contributionTypeForImportedObject;
                    if (!importedObject.getImportFlag() || (contributionTypeForImportedObject = importedObject.getCrossLinkRelationContributionType(relationTypeID, roleID)) == null) continue;
                    for (IRelationRelatedRequestRO creationRequest : contributionTypeForImportedObject.getRelationCreationRequests()) {
                        Tuple<RelationSampleWithRelationCreationRequests, RepositoryAccessException> sampleOfRelationToBeCreated_andMessage = ImportJobHelper.getRelationSampleForRelationCreationRequest(contributionTypeForImportedObject, creationRequest);
                        if (sampleOfRelationToBeCreated_andMessage.getT2() != null) {
                            messages.add((RepositoryAccessException)sampleOfRelationToBeCreated_andMessage.getT2());
                        }
                        if (sampleOfRelationToBeCreated_andMessage.getT1() == null) continue;
                        RelationSampleWithRelationCreationRequests alreadyFoundSample = (RelationSampleWithRelationCreationRequests)creationRequests.get((Object)((RelationSampleWithRelationCreationRequests)sampleOfRelationToBeCreated_andMessage.getT1()));
                        if (alreadyFoundSample != null) {
                            alreadyFoundSample.addAllRelationCreationRequests((RelationSampleWithRelationCreationRequests)sampleOfRelationToBeCreated_andMessage.getT1());
                            continue;
                        }
                        creationRequests.add((Object)((RelationSampleWithRelationCreationRequests)sampleOfRelationToBeCreated_andMessage.getT1()));
                    }
                    if (!contributionTypeForImportedObject.getDeleteAllExistingRelationsFlag() || importedObject.getImportMode() != 2) continue;
                    samplesAndMessages = ImportJobHelper.findExistingRelations(contributionTypeForImportedObject, repositorySnapshot);
                    if (samplesAndMessages.getT2() != null) {
                        messages.add((RepositoryAccessException)samplesAndMessages.getT2());
                    }
                    deletionRequests.addAll((ICollection_)samplesAndMessages.getT1());
                }
            }
            for (IContextObjectTypeRO contextObjectType : importJob.getContextObjectTypes()) {
                if (!contextObjectType.getObjectType().isSubTypeOf(relatedObjectType)) continue;
                for (IContextObjectRO contextObject : contextObjectType.getObjects()) {
                    ICrossLinkRelationContributionTypeForContextObjectRO contributionTypeForContextObject = contextObject.getCrossLinkRelationContributionType(relationTypeID, roleID);
                    if (contributionTypeForContextObject == null || !contributionTypeForContextObject.getDeleteAllExistingRelationsFlag()) continue;
                    samplesAndMessages = ImportJobHelper.findExistingRelations(contributionTypeForContextObject, repositorySnapshot);
                    if (samplesAndMessages.getT2() != null) {
                        messages.add((RepositoryAccessException)samplesAndMessages.getT2());
                    }
                    deletionRequests.addAll((ICollection_)samplesAndMessages.getT1());
                }
            }
        }
        return new ThreeTuple((Object)creationRequests, (Object)deletionRequests, (Object)messages);
    }

    public static final IRepositoryPropertyReference getPropertyReference(IPropertyRO property) throws RelatedObjectNotMatched {
        IImportedObjectRO object = property.getObject();
        IRepositoryObjectReference reporsitoryObjectReference = ImportJobHelper.getObjectReference(object);
        return new RepositoryPropertyReference(reporsitoryObjectReference, property.getRepositoryPropertyType().getRepositoryPropertyTypeID());
    }

    public static final IRepositoryObjectTypeCategoryReference getObjectTypeCategoryReference(IImportedObjectRO importedObject) throws RelatedObjectNotMatched {
        IRepositoryObjectReference objectReference = ImportJobHelper.getObjectReference(importedObject);
        return new RepositoryObjectTypeCategoryReference(objectReference);
    }

    public static IRepositoryObjectReference getObjectReference(IObjectRO object) throws RelatedObjectNotMatched {
        IRepositoryObjectTypeID repositoryObjectTypeID = object.getObjectType().getObjectType().getRepositoryObjectTypeID();
        IRepositoryPropertySetSample objectID = ImportJobHelper.getObjectIDOfObject(object);
        RepositoryObjectReference objectReference = new RepositoryObjectReference(repositoryObjectTypeID, objectID);
        return objectReference;
    }

    private static final IRepositoryPropertySetSample getObjectIDOfRelatedObject(IObjectRO relatedObject) throws RelatedObjectNotMatched, RelatedObjectNotImported {
        IImportedObjectRO relatedImportedObject;
        if (relatedObject instanceof IImportedObjectRO && !(relatedImportedObject = (IImportedObjectRO)relatedObject).getImportFlag()) {
            throw new RelatedObjectNotImported();
        }
        return ImportJobHelper.getObjectIDOfObject(relatedObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final IRepositoryPropertySetSample getObjectIDOfObject(IObjectRO relatedObject) throws RelatedObjectNotMatched {
        IRepositoryPropertySetSample objectID = null;
        if (relatedObject instanceof IImportedObjectRO) {
            IImportedObjectRO relatedImportedObject = (IImportedObjectRO)relatedObject;
            if (relatedImportedObject.getImportMode() == 1) {
                objectID = relatedImportedObject.getObjectID();
            } else if (relatedImportedObject.getImportMode() == 2) {
                if (relatedImportedObject.getMatchingObject() == null) throw new RelatedObjectNotMatched();
                objectID = relatedImportedObject.getMatchingObject().getObjectID();
            }
        } else if (relatedObject instanceof IContextObjectRO) {
            IContextObjectRO relatedContextObject = (IContextObjectRO)relatedObject;
            if (relatedContextObject.getMatchingObject() == null) throw new RelatedObjectNotMatched();
            objectID = relatedContextObject.getMatchingObject().getObjectID();
        } else assert (false);
        assert (objectID != null);
        return objectID;
    }

    public static Tuple<ICollection_<? extends IOccurrenceRepositoryRelationReference>, RepositoryAccessException> findExistingOccurrences(IPropertyRO property, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        IImportedObjectRO objectInImportJob = property.getObject();
        try {
            if (objectInImportJob.getImportMode() == 2 && objectInImportJob.getMatchingObject() != null) {
                IRepositoryObject object = RepositoryReferences.getObjectFromReference(objectInImportJob.getMatchingObject(), snapshot);
                return new Tuple(ImportJobHelper.findExistingOccurrences(property, object), null);
            }
            return new Tuple((Object)new ArrayList_(), null);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            return new Tuple((Object)new ArrayList_(), (Object)new EXMissingObject(objectInImportJob.getMatchingObject()));
        }
    }

    public static ICollection_<? extends IOccurrenceRepositoryRelationReference> findExistingOccurrences(IPropertyRO property, IRepositoryObject object) throws EXNotReproducibleSnapshot {
        ArrayList_ existingOccurrences = new ArrayList_();
        IRepositoryPropertyType propertyType = property.getRepositoryPropertyType();
        IRepositoryPropertyTypeID propertyTypeID = propertyType.getRepositoryPropertyTypeID();
        IImportedObjectRO objectInImportJob = property.getObject();
        IRepositoryAttributeSet repositoryAttributeSet = object.getAttributeSet(objectInImportJob.getObjectType().getObjectType().getAttributeSetType(propertyTypeID));
        IRepositoryProperty repositoryProperty = repositoryAttributeSet.getProperty(propertyType);
        for (IOccurrenceRepositoryRelation occurrence : repositoryProperty.getOccurrenceRelations()) {
            OccurrenceRepositoryRelationReference occurrenceReference = new OccurrenceRepositoryRelationReference(occurrence);
            existingOccurrences.add((Object)occurrenceReference);
        }
        return existingOccurrences;
    }

    public static Tuple<IOccurrenceRepositoryRelationSample, IMessageSet> getOccurrenceRelationSample(IOccurrenceRelationRO occurrence) {
        IRepositoryPropertyReference propertyReference;
        IRepositoryObjectReference objectReference;
        IRepositoryObjectTypeID repositoryObjectTypeID2;
        IRepositoryRelationTypeID relationTypeID = occurrence.getRelationType().getPropertyType().getOccuringRelationContributionType().getRelatedRelationType().getRepositoryRelationTypeID();
        IRepositoryPropertySetSample objectIDOfOccurrenceContainingObject = null;
        IRepositoryPropertySetSample objectIDOfOccurringObject = null;
        MessageSet messageSet = new MessageSet();
        try {
            objectIDOfOccurrenceContainingObject = ImportJobHelper.getObjectIDOfRelatedObject(occurrence.getOccurrenceProperty().getObject());
        }
        catch (RelatedObjectNotMatched e) {
            try {
                repositoryObjectTypeID2 = occurrence.getOccurrenceProperty().getObject().getObjectType().getObjectType().getRepositoryObjectTypeID();
                objectReference = ImportJobHelper.getObjectReference(occurrence.getOccurringRelationContribution().getRelatedObject());
                messageSet.add(new EXOccurrenceContainingObjectNotMatched(objectReference, repositoryObjectTypeID2));
            }
            catch (RelatedObjectNotMatched repositoryObjectTypeID2) {}
        }
        catch (RelatedObjectNotImported e) {
            try {
                repositoryObjectTypeID2 = occurrence.getOccurrenceProperty().getObject().getObjectType().getObjectType().getRepositoryObjectTypeID();
                objectReference = ImportJobHelper.getObjectReference(occurrence.getOccurringRelationContribution().getRelatedObject());
                messageSet.add(new EXOccurrenceContainingObjectNotImported(objectReference, repositoryObjectTypeID2));
            }
            catch (RelatedObjectNotMatched repositoryObjectTypeID3) {
                // empty catch block
            }
        }
        try {
            objectIDOfOccurringObject = ImportJobHelper.getObjectIDOfRelatedObject(occurrence.getOccurringRelationContribution().getRelatedObject());
        }
        catch (RelatedObjectNotMatched e) {
            try {
                repositoryObjectTypeID2 = occurrence.getOccurringRelationContribution().getRelatedObject().getObjectType().getObjectType().getRepositoryObjectTypeID();
                propertyReference = ImportJobHelper.getPropertyReference(occurrence.getOccurrenceProperty());
                messageSet.add(new EXOccurringObjectNotMatched(propertyReference, repositoryObjectTypeID2));
            }
            catch (RelatedObjectNotMatched repositoryObjectTypeID4) {}
        }
        catch (RelatedObjectNotImported e) {
            try {
                repositoryObjectTypeID2 = occurrence.getOccurringRelationContribution().getRelatedObject().getObjectType().getObjectType().getRepositoryObjectTypeID();
                propertyReference = ImportJobHelper.getPropertyReference(occurrence.getOccurrenceProperty());
                messageSet.add(new EXOccurringObjectNotImported(propertyReference, repositoryObjectTypeID2));
            }
            catch (RelatedObjectNotMatched relatedObjectNotMatched) {
                // empty catch block
            }
        }
        OccurrenceRepositoryRelationSample occurrenceSample = null;
        if (objectIDOfOccurrenceContainingObject != null && objectIDOfOccurringObject != null) {
            occurrenceSample = new OccurrenceRepositoryRelationSample(relationTypeID, objectIDOfOccurringObject, objectIDOfOccurrenceContainingObject, occurrence.getOccurrenceID());
        }
        return new Tuple(occurrenceSample, (Object)messageSet);
    }

    private static class RelatedObjectNotImported
    extends Exception {
    }

    public static class RelatedObjectNotMatched
    extends Exception {
    }
}

