/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT;

import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.MessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;

public class InterpretationMessageCollector {
    private static final ThreadLocal<MessageSet> interpretationMessages = new ThreadLocal();

    public static IMessageSet doWhileCollectingInterpretationMessages(Runnable runnable) {
        Assert.checkState((interpretationMessages.get() == null ? 1 : 0) != 0);
        try {
            interpretationMessages.set(new MessageSet());
            runnable.run();
            IMessageSet iMessageSet = interpretationMessages.get();
            return iMessageSet;
        }
        finally {
            interpretationMessages.set(null);
        }
    }

    public static void logInterpretationMessage(RepositoryAccessException interpretationMessage) {
        MessageSet messages = interpretationMessages.get();
        if (messages != null) {
            messages.add(interpretationMessage);
        }
    }

    private InterpretationMessageCollector() {
    }
}

