/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT;

import com.arcway.lib.java.Counter;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResourceWithOverwrittenName;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.Messages;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategorySample;
import com.arcway.repository.interFace.data.object.RepositoryObjectReferenceMap;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.importexport.IFileArchiveSnippetFile;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.importexport.ImportExportException;
import com.arcway.repository.interFace.importexport.exceptions.EXMissingProperty;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ContextObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ContextObjectType;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.CrossLinkRelation;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.CrossLinkRelationContributionTypeForContextObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.CrossLinkRelationContributionTypeForImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.CrossLinkRelationType;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportJob;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportedObjectType;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportedObjectTypeCategory;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.OccurrenceRelation;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.OccurrenceRelationType;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.OccurringRelationContributionType;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.OccurringRelationContributionTypeForContextObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.OccurringRelationContributionTypeForImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.Property;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IOccurrenceRepositoryRelationContributionType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IOccurringRepositoryRelationContributionType;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.IGenericModificationObjectType;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.manager.IGenericModificationTypeManager;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ImportInterpreter {
    private static final ILogger LOGGER = Logger.getLogger(ImportInterpreter.class);

    public static ImportJob createInitialImportJob(IRepositorySnippetRO repositorySnippet, IMessageSet interpretationMessages, IRepositoryInterfaceRO repositoryInterface) {
        ImportJob importJob = new ImportJob(interpretationMessages, repositoryInterface.getFileArchive());
        int initialSize = repositorySnippet.getExplicitObjects().size() + repositorySnippet.getImplicitObjects().size() + repositorySnippet.getContextObjects().size();
        RepositoryObjectReferenceMap<Object> objectMapping = new RepositoryObjectReferenceMap<Object>(initialSize);
        Counter objectCounter = new Counter();
        HashMap<ImportedObject, Integer> objectOrdinalNumberMapping = new HashMap<ImportedObject, Integer>();
        ImportInterpreter.handleObjectTypeCategories(repositorySnippet.getObjectTypeCategories(), importJob, repositoryInterface.getTypeManager());
        ImportInterpreter.handleObjects(repositorySnippet.getExplicitObjects(), true, repositorySnippet, importJob, repositoryInterface.getTypeManager(), objectMapping, objectCounter, objectOrdinalNumberMapping);
        ImportInterpreter.handleObjects(repositorySnippet.getImplicitObjects(), false, repositorySnippet, importJob, repositoryInterface.getTypeManager(), objectMapping, objectCounter, objectOrdinalNumberMapping);
        ImportInterpreter.handleContextObjects(repositorySnippet.getContextObjects(), importJob, repositoryInterface.getTypeManager(), objectMapping);
        ImportInterpreter.handleParentChildRelations(repositorySnippet.getExplicitObjects(), objectMapping, repositoryInterface.getTypeManager());
        ImportInterpreter.handleParentChildRelations(repositorySnippet.getImplicitObjects(), objectMapping, repositoryInterface.getTypeManager());
        ImportInterpreter.handleCrossLinkRelations(repositorySnippet.getCrossLinkRelations(), objectMapping, importJob, repositoryInterface.getTypeManager());
        ImportInterpreter.handleOccurrenceRelations(repositorySnippet.getOccurrenceRelations(), objectMapping, importJob, repositoryInterface.getTypeManager());
        for (ImportedObjectType objectType : importJob.getImportedObjectTypes()) {
            objectType.determineRootObjects();
            for (ImportedObject object : objectType.getObjects()) {
                ImportInterpreter.sortChildren(object, objectOrdinalNumberMapping);
            }
        }
        return importJob;
    }

    private static void handleObjectTypeCategories(ICollection_<IRepositoryObjectTypeCategorySample> objectTypeCategories, ImportJob importJob, IRepositoryTypeManagerRO typeManager) {
        for (IRepositoryObjectTypeCategorySample objectTypeCategory : objectTypeCategories) {
            ImportedObjectTypeCategory importedCategory = new ImportedObjectTypeCategory(objectTypeCategory);
            IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeCategory.getObjectType());
            for (IRepositoryObjectType concreteObjectType : objectType.getAllInstanciableObjectTypesOfThisType()) {
                ImportedObjectType importedObjectType = importJob.createOrGetImportedObjectType(concreteObjectType);
                importedObjectType.addImportedObjectTypeCategory(importedCategory);
            }
        }
    }

    private static void handleObjects(IList_<RepositoryObjectSampleWithParentObjectReference> objects, boolean areExplicitelyExported, IRepositorySnippetRO repositorySnippet, ImportJob importJob, IRepositoryTypeManagerRO typeManager, RepositoryObjectReferenceMap<Object> objectMapping, Counter objectCounter, Map<ImportedObject, Integer> objectOrdinalNumberMapping) {
        IGenericModificationTypeManager genericModificationTypeManager = GenericModificationTypeManager.getGenericModificationTypeManager(typeManager);
        HashMap_ filesInArchiveMap = new HashMap_(IRepositoryFileID.IS_EQUAL_FILE_ID_HASHER);
        for (IFileArchiveSnippetFile fileArchiveSnippetFile : repositorySnippet.getFiles()) {
            IRepositoryFileID fileID = fileArchiveSnippetFile.getFileID();
            filesInArchiveMap.put((Object)fileID, (Object)fileArchiveSnippetFile);
        }
        IMapRW_<IRepositoryObjectTypeID, ISetRW_<IRepositoryPropertyTypeID>> objectType2missingPropertyTypes = ImportInterpreter.determineMissingPropertyTypes(importJob);
        for (RepositoryObjectSampleWithParentObjectReference objectWithParentReference : objects) {
            IRepositoryObjectSample object = objectWithParentReference.getObjectSample();
            IRepositoryObjectTypeID objectTypeID = object.getObjectTypeID();
            IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
            ImportedObjectType objectTypeInImportJob = importJob.createOrGetImportedObjectType(objectType);
            IRepositoryObjectTypeCategoryID importedCategoryID = object.getObjectTypeCategoryID();
            ImportedObjectTypeCategory objectTypeCategoryInImportJob = importedCategoryID != null ? objectTypeInImportJob.getObjectTypeCategory(importedCategoryID) : null;
            IGenericModificationObjectType genericModificationObjectType = genericModificationTypeManager.getGenericModificationObjectType(objectType);
            IRepositoryPropertySetSample newObjectID = genericModificationObjectType.allocateNewObjectID();
            ImportedObject objectInImportJob = new ImportedObject(newObjectID, objectTypeInImportJob, areExplicitelyExported, objectTypeCategoryInImportJob);
            for (IRepositoryAttributeSetType attributeSetType : objectType.getAttributeSetTypes()) {
                for (IRepositoryPropertyType propertyType : attributeSetType.getPropertyTypes()) {
                    RDTFile fileDataType;
                    IRepositoryFileID oldFileID;
                    IRepositoryPropertySample propertySample = object.getPropertySetSample().getPropertySample(propertyType.getRepositoryPropertyTypeID());
                    assert (propertySample != null) : "Missing property sample for property " + propertyType.getRepositoryPropertyTypeID();
                    IRepositoryData propertyValue = propertySample.getValue();
                    if (propertyValue.getDataType().getRepositoryDataTypeID().equals(RDTFile.DATA_TYPE_ID) && (oldFileID = (fileDataType = RDTFile.getInstance()).dataToFileID(propertyValue)) != null) {
                        ThreeTuple<IStreamResource, IRepositoryObjectSample, Date> tempFileAndMetaInformation = ImportInterpreter.getTemporaryFileAndMetaInformationForFileID((IMapRW_<IRepositoryFileID, IFileArchiveSnippetFile>)filesInArchiveMap, oldFileID);
                        if (tempFileAndMetaInformation != null) {
                            boolean successful = importJob.loadImportedTempFile((IStreamResource)tempFileAndMetaInformation.getComponent1(), propertyValue, (IRepositoryObjectSample)tempFileAndMetaInformation.getComponent2(), ((Date)tempFileAndMetaInformation.getComponent3()).getTime(), propertyType);
                            if (!successful) {
                                propertyValue = genericModificationTypeManager.getGenericModificationPropertyType(propertyType).getDefaultValue();
                            }
                        } else {
                            LOGGER.warn("File referenced in property of an imported object could not be found in the file archive snippet ( object type: " + objectType.getRepositoryObjectTypeID().toCanonicalString() + " / property: " + propertyType.getRepositoryPropertyTypeID().toCanonicalString() + " / file id: " + oldFileID.toCanonicalString() + ").");
                            propertyValue = genericModificationTypeManager.getGenericModificationPropertyType(propertyType).getDefaultValue();
                        }
                    }
                    boolean importedValueAsToBeValue = true;
                    ISetRW_ missingPropertyTypesOfObjectType = (ISetRW_)objectType2missingPropertyTypes.getByKey((Object)objectType.getRepositoryObjectTypeID());
                    if (missingPropertyTypesOfObjectType != null && missingPropertyTypesOfObjectType.contains((Object)propertyType.getRepositoryPropertyTypeID())) {
                        importedValueAsToBeValue = false;
                    }
                    Property propertyInImportJob = new Property(objectInImportJob, propertyType, propertyValue, importedValueAsToBeValue);
                    objectInImportJob.addProperty(propertyInImportJob);
                    importJob.createOrGetOccurrenceRelationType(propertyType);
                }
                for (ICrossLinkRepositoryRelationContributionType relationContributionType : attributeSetType.getCrossLinkRelationContributionTypesToConcreteRelationTypes()) {
                    ICrossLinkRepositoryRelationType relationType = relationContributionType.getRelatedRelationType();
                    CrossLinkRelationType relationTypeInImportJob = importJob.createOrGetCrossLinkRelationType(relationType);
                    CrossLinkRelationContributionTypeForImportedObject relationContributionTypeInImportJob = new CrossLinkRelationContributionTypeForImportedObject(objectInImportJob, relationTypeInImportJob, relationContributionType);
                    objectInImportJob.addCrossLinkRelationContributionType(relationContributionTypeInImportJob);
                }
            }
            for (IOccurrenceRepositoryRelationContributionType occurrenceRelationContributionType : objectType.getOccurrenceRelationContributionTypes()) {
                OccurringRelationContributionTypeForImportedObject relationContributionTypeInImportJob = new OccurringRelationContributionTypeForImportedObject(objectInImportJob, occurrenceRelationContributionType.getRelatedRelationType().getOccurringRelationContributionType());
                objectInImportJob.addOccurringRelationContributionType(relationContributionTypeInImportJob);
            }
            objectTypeInImportJob.addImportedObject(objectInImportJob);
            objectCounter.next();
            objectOrdinalNumberMapping.put(objectInImportJob, objectCounter.getCount());
            objectMapping.put(objectType, object.getObjectID(typeManager), objectInImportJob);
        }
    }

    private static void handleParentChildRelations(IList_<RepositoryObjectSampleWithParentObjectReference> objects, RepositoryObjectReferenceMap<Object> objectMapping, IRepositoryTypeManagerRO typeManager) {
        for (RepositoryObjectSampleWithParentObjectReference objectWithParentReference : objects) {
            IRepositoryObjectReference parentObjectReference = objectWithParentReference.getParentObjectReference();
            if (parentObjectReference == null) continue;
            IRepositoryObjectTypeID parentObjectTypeID = parentObjectReference.getObjectTypeID();
            IRepositoryObjectType parentObjectType = typeManager.getObjectType(parentObjectTypeID);
            IRepositoryPropertySetSample parentObjectID = parentObjectReference.getObjectID();
            Object parentInImportJob = objectMapping.get(parentObjectType, parentObjectID);
            IRepositoryObjectReference childObjectReference = objectWithParentReference.getObjectSample().getObjectReference(typeManager);
            IRepositoryObjectTypeID childObjectTypeID = childObjectReference.getObjectTypeID();
            IRepositoryObjectType childObjectType = typeManager.getObjectType(childObjectTypeID);
            IRepositoryPropertySetSample childObjectID = childObjectReference.getObjectID();
            Object childInImportJob = objectMapping.get(childObjectType, childObjectID);
            if (parentInImportJob instanceof ImportedObject && childInImportJob instanceof ImportedObject) {
                assert (((ImportedObject)childInImportJob).getParent() == null);
                ((ImportedObject)parentInImportJob).addChild((ImportedObject)childInImportJob);
                ((ImportedObject)childInImportJob).setParent((ImportedObject)parentInImportJob);
                continue;
            }
            if (parentInImportJob == null) {
                LOGGER.warn("Parent object not found for parent child relation (parent object id: " + RepositoryReferences.createCanonicalString(parentObjectReference) + ").");
                continue;
            }
            if (childInImportJob == null) {
                LOGGER.warn("Child object not found for parent child relation (child object id: " + RepositoryReferences.createCanonicalString(childObjectReference) + ").");
                continue;
            }
            LOGGER.warn("Related objects are not imported objects for parent child relation (parent object id: " + RepositoryReferences.createCanonicalString(parentObjectReference) + " / child object id: " + RepositoryReferences.createCanonicalString(childObjectReference) + ").");
        }
    }

    private static void handleContextObjects(ICollection_<IRepositoryObjectSample> objects, ImportJob importJob, IRepositoryTypeManagerRO typeManager, RepositoryObjectReferenceMap<Object> objectMapping) {
        for (IRepositoryObjectSample object : objects) {
            IRepositoryObjectTypeID objectTypeID = object.getObjectTypeID();
            IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
            ContextObjectType objectTypeInImportJob = importJob.createOrGetContextObjectType(objectType);
            ContextObject objectInImportJob = new ContextObject(objectTypeInImportJob, object);
            objectTypeInImportJob.addContextObject(objectInImportJob);
            objectMapping.put(objectType, object.getObjectID(typeManager), objectInImportJob);
        }
    }

    private static void handleCrossLinkRelations(ICollection_<ICrossLinkRepositoryRelationSample> relations, RepositoryObjectReferenceMap<Object> objectMapping, ImportJob importJob, IRepositoryTypeManagerRO typeManager) {
        for (ICrossLinkRepositoryRelationSample relation : relations) {
            final IRepositoryRelationTypeID relationTypeID = relation.getRelationTypeID();
            ICrossLinkRepositoryRelationType relationType = typeManager.getCrossLinkRelationType(relationTypeID);
            final CrossLinkRelationType relationTypeInImportJob = importJob.createOrGetCrossLinkRelationType(relationType);
            final CrossLinkRelation relationInImportJob = new CrossLinkRelation(relationTypeInImportJob);
            boolean allRelatedObjectsFound = true;
            ArrayList<1> contributionCreationTasks = new ArrayList<1>();
            for (final ICrossLinkRepositoryRelationContributionType contributionType : relationType.getAllRelationContributionTypes()) {
                Runnable contributionCreationTask;
                final IRepositoryRelationContributionRoleID roleID = contributionType.getRepositoryRelationContributionRoleID();
                IRepositoryPropertySetSample relatedObjectID = relation.getObjectID(roleID);
                IRepositoryObjectType relatedObjectType = contributionType.getRelatedObjectType();
                final Object relatedObjectInImportJob = objectMapping.get(relatedObjectType, relatedObjectID);
                if (relatedObjectInImportJob instanceof ImportedObject) {
                    contributionCreationTask = new Runnable(){

                        @Override
                        public void run() {
                            CrossLinkRelationContributionTypeForImportedObject contributionInImportJob = ((ImportedObject)relatedObjectInImportJob).getCrossLinkRelationContributionType(relationTypeID, roleID);
                            contributionInImportJob.addRelation(relationInImportJob);
                            relationInImportJob.addRelationContribution(contributionInImportJob);
                        }
                    };
                    contributionCreationTasks.add(contributionCreationTask);
                    continue;
                }
                if (relatedObjectInImportJob instanceof ContextObject) {
                    contributionCreationTask = new Runnable(){

                        @Override
                        public void run() {
                            CrossLinkRelationContributionTypeForContextObject contributionInImportJob = ((ContextObject)relatedObjectInImportJob).getCrossLinkRelationContributionType(relationTypeID, roleID);
                            if (contributionInImportJob == null) {
                                contributionInImportJob = new CrossLinkRelationContributionTypeForContextObject((ContextObject)relatedObjectInImportJob, relationTypeInImportJob, contributionType);
                                ((ContextObject)relatedObjectInImportJob).addCrossLinkRelationContributionType(contributionInImportJob);
                            }
                            contributionInImportJob.addRelation(relationInImportJob);
                            relationInImportJob.addRelationContribution(contributionInImportJob);
                        }
                    };
                    contributionCreationTasks.add(contributionCreationTask);
                    continue;
                }
                LOGGER.warn("Could not find related object (relation type: " + relationTypeID.toCanonicalString() + " / contribution role: " + contributionType.getRepositoryRelationContributionRoleID() + " / related object id: " + RepositorySamples.createCanonicalString(relatedObjectID) + ").");
                allRelatedObjectsFound = false;
            }
            if (!allRelatedObjectsFound) continue;
            relationTypeInImportJob.addRelation(relationInImportJob);
            for (Runnable contributionCreationTask : contributionCreationTasks) {
                contributionCreationTask.run();
            }
        }
    }

    private static void handleOccurrenceRelations(ICollection_<IOccurrenceRepositoryRelationSample> relations, RepositoryObjectReferenceMap<Object> objectMapping, ImportJob importJob, IRepositoryTypeManagerRO typeManager) {
        for (IOccurrenceRepositoryRelationSample relation : relations) {
            OccurringRelationContributionType occurringContributionInImportJob;
            IRepositoryRelationTypeID relationTypeID = relation.getRelationTypeID();
            IOccurrenceRepositoryRelationType relationType = typeManager.getOccurrenceRelationType(relationTypeID);
            IOccurrenceRepositoryRelationContributionType occurrenceContributionType = relationType.getOccurrenceRelationContributionType();
            IRepositoryObjectType occurrenceObjectType = occurrenceContributionType.getRelatedObjectType();
            IRepositoryPropertyType occurrencePropertyType = occurrenceContributionType.getRelatedPropertyType();
            IOccurringRepositoryRelationContributionType occurringContributionType = relationType.getOccurringRelationContributionType();
            IRepositoryObjectType occurringObjectType = occurringContributionType.getRelatedObjectType();
            OccurrenceRelationType relationTypeInImportJob = importJob.getOccurrenceRelationType(occurrenceObjectType.getRepositoryObjectTypeID(), occurrencePropertyType.getRepositoryPropertyTypeID());
            OccurrenceRelation relationInImportJob = new OccurrenceRelation(relationTypeInImportJob, relation.getOccurrenceID());
            IRepositoryPropertySetSample occurrenceObjectID = relation.getObjectIDofOccurrenceContainingObject();
            Object occurrenceObjectInImportJob = objectMapping.get(occurrenceObjectType, occurrenceObjectID);
            if (occurrenceObjectInImportJob == null || !(occurrenceObjectInImportJob instanceof ImportedObject)) {
                LOGGER.warn("Could not find occurrence object or it does not belong to the imported objects (relation type: " + relationTypeID.toCanonicalString() + " / related object id: " + RepositorySamples.createCanonicalString(occurrenceObjectID) + ").");
                continue;
            }
            IRepositoryPropertySetSample occurringObjectID = relation.getObjectIDofOccuringObject();
            Object occurringObjectInImportJob = objectMapping.get(occurringObjectType, occurringObjectID);
            if (occurringObjectInImportJob == null || !(occurringObjectInImportJob instanceof ImportedObject) && !(occurringObjectInImportJob instanceof ContextObject)) {
                LOGGER.warn("Could not find occurrence object or it does not belong to the imported or context objects (relation type: " + relationTypeID.toCanonicalString() + " / related object id: " + RepositorySamples.createCanonicalString(occurringObjectID) + ").");
                continue;
            }
            Property occurrencePropertyInImportJob = ((ImportedObject)occurrenceObjectInImportJob).getProperty(occurrencePropertyType.getRepositoryPropertyTypeID());
            occurrencePropertyInImportJob.addOccurrenceRelation(relationInImportJob);
            relationInImportJob.setOccurrenceProperty(occurrencePropertyInImportJob);
            if (occurringObjectInImportJob instanceof ImportedObject) {
                occurringContributionInImportJob = ((ImportedObject)occurringObjectInImportJob).getOccurringRelationContributionType(occurrenceObjectType.getRepositoryObjectTypeID(), occurrencePropertyType.getRepositoryPropertyTypeID());
                occurringContributionInImportJob.addRelation(relationInImportJob);
                relationInImportJob.setOccurringRelationContribution(occurringContributionInImportJob);
            } else if (occurringObjectInImportJob instanceof ContextObject) {
                occurringContributionInImportJob = ((ContextObject)occurringObjectInImportJob).getOccurringRelationContributionType(occurrenceObjectType.getRepositoryObjectTypeID(), occurrencePropertyType.getRepositoryPropertyTypeID());
                if (occurringContributionInImportJob == null) {
                    occurringContributionInImportJob = new OccurringRelationContributionTypeForContextObject((ContextObject)occurringObjectInImportJob, occurringContributionType);
                    ((ContextObject)occurringObjectInImportJob).addOccurringRelationContributionType((OccurringRelationContributionTypeForContextObject)occurringContributionInImportJob);
                }
                occurringContributionInImportJob.addRelation(relationInImportJob);
                relationInImportJob.setOccurringRelationContribution(occurringContributionInImportJob);
            }
            relationTypeInImportJob.addRelation(relationInImportJob);
        }
    }

    private static void sortChildren(ImportedObject object, final Map<ImportedObject, Integer> objectOrdinalNumberMapping) {
        object.sortChildren(new Comparator<ImportedObject>(){

            @Override
            public int compare(ImportedObject o1, ImportedObject o2) {
                int ordinalNumberO1 = (Integer)objectOrdinalNumberMapping.get(o1);
                int ordinalNumberO2 = (Integer)objectOrdinalNumberMapping.get(o2);
                return ordinalNumberO1 - ordinalNumberO2;
            }
        });
    }

    private static ThreeTuple<IStreamResource, IRepositoryObjectSample, Date> getTemporaryFileAndMetaInformationForFileID(IMapRW_<IRepositoryFileID, IFileArchiveSnippetFile> filesInArchiveMap, IRepositoryFileID fileID) {
        IFileArchiveSnippetFile temporaryFilePathAndOriginalFileName = (IFileArchiveSnippetFile)filesInArchiveMap.getByKey((Object)fileID);
        if (temporaryFilePathAndOriginalFileName != null) {
            return new ThreeTuple((Object)new FileResourceWithOverwrittenName(temporaryFilePathAndOriginalFileName.getContent(), temporaryFilePathAndOriginalFileName.getName()), (Object)temporaryFilePathAndOriginalFileName.getSourceCreationSnapshotInformation(), (Object)temporaryFilePathAndOriginalFileName.getSourceCreationDate());
        }
        return null;
    }

    private static IMapRW_<IRepositoryObjectTypeID, ISetRW_<IRepositoryPropertyTypeID>> determineMissingPropertyTypes(ImportJob importJob) {
        HashMap_ objectType2PropertyTypes = new HashMap_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
        IMessageSet interpretationMessages = importJob.getInterpretationMessages();
        for (RepositoryAccessException message : interpretationMessages.getMessages()) {
            if (!(message instanceof EXMissingProperty)) continue;
            EXMissingProperty exMissingProperty = (EXMissingProperty)message;
            IRepositoryObjectTypeID objectTypeIDOfPropertyType = exMissingProperty.getObjectTypeIDOfPropertyType();
            IRepositoryPropertyTypeID propertyTypeID = exMissingProperty.getPropertyTypeID();
            ISetRW_ propertyTypesToAdjust = (ISetRW_)objectType2PropertyTypes.getByKey((Object)objectTypeIDOfPropertyType);
            if (propertyTypesToAdjust == null) {
                propertyTypesToAdjust = new HashSet_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
                objectType2PropertyTypes.put((Object)objectTypeIDOfPropertyType, (Object)propertyTypesToAdjust);
            }
            propertyTypesToAdjust.add((Object)propertyTypeID);
        }
        return objectType2PropertyTypes;
    }

    public static void checkImportability(IRepositorySnippetRO repositorySnippet) throws ImportExportException {
        for (IFileArchiveSnippetFile archiveSnippetFile : repositorySnippet.getFiles()) {
            Exception fileInputStreamCreationFailureCause;
            block15: {
                File file = archiveSnippetFile.getContent();
                FileInputStream fi = null;
                fileInputStreamCreationFailureCause = null;
                try {
                    try {
                        fi = new FileInputStream(file);
                    }
                    catch (Exception e) {
                        fileInputStreamCreationFailureCause = e;
                        if (fi != null) {
                            try {
                                fi.close();
                            }
                            catch (IOException e2) {
                                LOGGER.debug("Unable to close FileInputStream (File=" + file + ").", (Throwable)e2);
                            }
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (fi != null) {
                        try {
                            fi.close();
                        }
                        catch (IOException e) {
                            LOGGER.debug("Unable to close FileInputStream (File=" + file + ").", (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException e) {
                        LOGGER.debug("Unable to close FileInputStream (File=" + file + ").", (Throwable)e);
                    }
                }
            }
            if (fileInputStreamCreationFailureCause == null) continue;
            throw new ImportExportException(Messages.getString("ImportInterpreter.checkImportabilityFailed.ExMessage"), fileInputStreamCreationFailureCause);
        }
    }
}

